/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;

public class ICC_ProfileGray
extends ICC_Profile {
    private static final long serialVersionUID = -1124721290732002649L;
    private transient float[] whitePoint = this.getXYZData(0x77747074);

    ICC_ProfileGray(int n) {
        super(n);
    }

    ICC_ProfileGray(byte[] byArray) {
        super(byArray);
    }

    public float[] getMediaWhitePoint() {
        float[] fArray = new float[]{this.whitePoint[0], this.whitePoint[1], this.whitePoint[2]};
        return fArray;
    }

    public float getGamma() {
        short[] sArray = this.getCurve(1800688195);
        if (sArray == null) {
            throw new IllegalArgumentException("Couldn't read Gray TRC data.");
        }
        if (sArray.length != 1) {
            throw new ProfileDataException("TRC is a table, not a gamma value.");
        }
        double d = (double)(sArray[0] & 0xFFFF) / 256.0;
        return (float)d;
    }

    public short[] getTRC() {
        short[] sArray = this.getCurve(1800688195);
        if (sArray == null) {
            throw new IllegalArgumentException("Couldn't read Gray TRC data.");
        }
        if (sArray.length <= 1) {
            throw new ProfileDataException("Gamma value, not a TRC table.");
        }
        return sArray;
    }
}

