/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Hashtable objectLookupTable;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private boolean readDataFromBlock;
    private boolean isDeserializing;
    private boolean fieldsAlreadyRead;
    private Vector validators;
    private Hashtable classLookupTable;
    private GetField prereadFields;
    private ClassLoader callersClassLoader;
    private static boolean dump;
    private int depth;

    private /* synthetic */ void finit$() {
        this.depth = 0;
    }

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.finit$();
        this.resolveEnabled = false;
        this.isDeserializing = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(inputStream);
        this.nextOID = 0x7E0000;
        this.objectLookupTable = new Hashtable();
        this.validators = new Vector();
        this.classLookupTable = new Hashtable();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object readObject() throws ClassNotFoundException, IOException {
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean bl = this.isDeserializing;
        boolean bl2 = false;
        boolean bl3 = this.setBlockDataMode(false);
        this.isDeserializing = true;
        byte by = this.realInputStream.readByte();
        this.depth += 2;
        if (dump) {
            this.dumpElement("MARKER: 0x" + Integer.toHexString(by) + " ");
        }
        try {
            switch (by) {
                case 120: {
                    Object object2 = null;
                    bl2 = true;
                    return object2;
                }
                case 119: 
                case 122: {
                    if (by == 122) {
                        if (dump) {
                            this.dumpElementln("BLOCKDATALONG");
                        }
                    } else if (dump) {
                        this.dumpElementln("BLOCKDATA");
                    }
                    this.readNextBlock(by);
                    throw new StreamCorruptedException("Unexpected blockData");
                }
                case 112: {
                    if (dump) {
                        this.dumpElementln("NULL");
                    }
                    Object object2 = null;
                    return object2;
                }
                case 113: {
                    if (dump) {
                        this.dumpElement("REFERENCE ");
                    }
                    Integer n = new Integer(this.realInputStream.readInt());
                    if (dump) {
                        this.dumpElementln(Integer.toHexString(n));
                    }
                    Object object2 = ((ObjectIdentityWrapper)this.objectLookupTable.get((Object)n)).object;
                    return object2;
                }
                case 118: {
                    if (dump) {
                        this.dumpElementln("CLASS");
                    }
                    ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                    Class clazz = objectStreamClass.forClass();
                    this.assignNewHandle(clazz);
                    Object object2 = clazz;
                    return object2;
                }
                case 125: {
                    boolean bl4;
                    if (dump) {
                        this.dumpElementln("PROXYCLASS");
                    }
                    boolean bl5 = this.realInputStream.readInt();
                    String[] stringArray = new String[bl5];
                    for (bl4 = false; bl4 < bl5; bl4 += 1) {
                        stringArray[bl4] = this.realInputStream.readUTF();
                    }
                    bl4 = this.setBlockDataMode(true);
                    Class clazz = this.resolveProxyClass(stringArray);
                    this.setBlockDataMode(bl4);
                    ObjectStreamClass objectStreamClass = this.lookupClass(clazz);
                    if (objectStreamClass.firstNonSerializableParentConstructor == null) {
                        objectStreamClass.realClassIsSerializable = true;
                        objectStreamClass.fieldMapping = new ObjectStreamField[0];
                        objectStreamClass.fields = objectStreamClass.fieldMapping;
                        try {
                            objectStreamClass.firstNonSerializableParentConstructor = ObjectInputStream.class$("java.lang.Object").getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw (InternalError)new InternalError("Object ctor missing").initCause(noSuchMethodException);
                        }
                    }
                    this.assignNewHandle(objectStreamClass);
                    if (!bl2) {
                        byte by2 = this.realInputStream.readByte();
                        if (by2 != 120) {
                            throw new IOException("Data annotated to class was not consumed." + by2);
                        }
                    } else {
                        bl2 = false;
                    }
                    ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
                    objectStreamClass.setSuperclass(objectStreamClass2);
                    Object object2 = objectStreamClass;
                    return object2;
                }
                case 114: {
                    ObjectStreamClass objectStreamClass = this.readClassDescriptor();
                    if (!bl2) {
                        byte by3 = this.realInputStream.readByte();
                        if (by3 != 120) {
                            throw new IOException("Data annotated to class was not consumed." + by3);
                        }
                    } else {
                        bl2 = false;
                    }
                    objectStreamClass.setSuperclass((ObjectStreamClass)this.readObject());
                    Object object2 = objectStreamClass;
                    return object2;
                }
                case 116: 
                case 124: {
                    if (dump) {
                        this.dumpElement("STRING=");
                    }
                    String string = this.realInputStream.readUTF();
                    if (dump) {
                        this.dumpElementln(string);
                    }
                    Object object2 = this.processResolution(null, string, this.assignNewHandle(string));
                    return object2;
                }
                case 117: {
                    if (dump) {
                        this.dumpElementln("ARRAY");
                    }
                    ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                    Class clazz = objectStreamClass.forClass().getComponentType();
                    if (dump) {
                        this.dumpElement("ARRAY LENGTH=");
                    }
                    int n = this.realInputStream.readInt();
                    if (dump) {
                        this.dumpElementln(n + "; COMPONENT TYPE=" + clazz);
                    }
                    Object object = Array.newInstance(clazz, n);
                    int n2 = this.assignNewHandle(object);
                    this.readArrayElements(object, clazz);
                    if (dump) {
                        int n3 = Array.getLength(object);
                        for (int i = 0; i < n3; ++i) {
                            this.dumpElementln("  ELEMENT[" + i + "]=" + Array.get(object, i));
                        }
                    }
                    Object object2 = this.processResolution(null, object, n2);
                    return object2;
                }
                case 115: {
                    Object object2;
                    if (dump) {
                        this.dumpElementln("OBJECT");
                    }
                    ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                    Class clazz = objectStreamClass.forClass();
                    if (!objectStreamClass.realClassIsSerializable) {
                        throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                    }
                    if (objectStreamClass.realClassIsExternalizable) {
                        Externalizable externalizable = objectStreamClass.newInstance();
                        int n = this.assignNewHandle(externalizable);
                        boolean bl6 = (objectStreamClass.getFlags() & 8) != 0;
                        boolean bl7 = this.readDataFromBlock;
                        if (bl6) {
                            this.setBlockDataMode(true);
                        }
                        externalizable.readExternal(this);
                        if (bl6) {
                            this.setBlockDataMode(bl7);
                            if (!bl7 && this.realInputStream.readByte() != 120) {
                                throw new IOException("No end of block data seen for class with readExternal (ObjectInputStream) method.");
                            }
                        }
                        object2 = this.processResolution(objectStreamClass, externalizable, n);
                        return object2;
                    } else {
                        Object object = this.newObject(clazz, objectStreamClass.firstNonSerializableParentConstructor);
                        int n = this.assignNewHandle(object);
                        Object object3 = this.currentObject;
                        ObjectStreamClass objectStreamClass3 = this.currentObjectStreamClass;
                        this.currentObject = object;
                        ObjectStreamClass[] objectStreamClassArray = this.inputGetObjectStreamClasses(clazz);
                        for (int i = 0; i < objectStreamClassArray.length; ++i) {
                            Method method;
                            this.currentObjectStreamClass = objectStreamClassArray[i];
                            if (dump) {
                                this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                            }
                            if ((method = this.currentObjectStreamClass.readObjectMethod) != null) {
                                this.fieldsAlreadyRead = false;
                                boolean bl8 = this.setBlockDataMode(true);
                                this.callReadMethod(method, this.currentObjectStreamClass.forClass(), object);
                                this.setBlockDataMode(bl8);
                            } else {
                                this.readFields(object, this.currentObjectStreamClass);
                            }
                            if (!this.currentObjectStreamClass.hasWriteMethod()) continue;
                            if (dump) {
                                this.dumpElement("ENDBLOCKDATA? ");
                            }
                            try {
                                if (this.realInputStream.readByte() != 120) {
                                    throw new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.");
                                }
                                if (!dump) continue;
                                this.dumpElementln("yes");
                                continue;
                            }
                            catch (IOException iOException) {
                                if (!dump) continue;
                                this.dumpElementln("no, got IOException");
                            }
                        }
                        this.currentObject = object3;
                        this.currentObjectStreamClass = objectStreamClass3;
                        object2 = this.processResolution(objectStreamClass, object, n);
                        return object2;
                    }
                }
                case 121: {
                    if (dump) {
                        this.dumpElementln("RESET");
                    }
                    this.clearHandles();
                    Object object2 = this.readObject();
                    return object2;
                }
                case 123: {
                    if (dump) {
                        this.dumpElement("EXCEPTION=");
                    }
                    Exception exception = (Exception)this.readObject();
                    if (dump) {
                        this.dumpElementln(exception.toString());
                    }
                    this.clearHandles();
                    throw new WriteAbortedException("Exception thrown during writing of stream", exception);
                }
                default: {
                    throw new IOException("Unknown marker on stream: " + by);
                }
            }
        }
        finally {
            Object var6_14 = null;
            this.setBlockDataMode(bl3);
            this.isDeserializing = bl;
            this.depth -= 2;
            if (!bl && this.validators.size() > 0) {
                this.invokeValidators();
            }
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void checkTypeConsistency(String string, ObjectStreamField[] objectStreamFieldArray, ObjectStreamField[] objectStreamFieldArray2) throws InvalidClassException {
        int n = 0;
        for (n = 0; n < objectStreamFieldArray.length && objectStreamFieldArray[n].isPrimitive(); ++n) {
        }
        if (n == objectStreamFieldArray.length) {
            return;
        }
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length && n < objectStreamFieldArray.length) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[n];
            ObjectStreamField objectStreamField2 = objectStreamFieldArray2[n2];
            if (!objectStreamField2.isPrimitive()) break;
            int n3 = objectStreamField.getName().compareTo(objectStreamField2.getName());
            if (n3 < 0) {
                ++n;
                continue;
            }
            if (n3 > 0) {
                ++n2;
                continue;
            }
            throw new InvalidClassException("invalid field type for " + objectStreamField2.getName() + " in class " + string);
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws ClassNotFoundException, IOException {
        Class clazz;
        Object object;
        Object object2;
        if (dump) {
            this.dumpElement("CLASSDESC NAME=");
        }
        String string = this.realInputStream.readUTF();
        if (dump) {
            this.dumpElement(string + "; UID=");
        }
        long l = this.realInputStream.readLong();
        if (dump) {
            this.dumpElement(Long.toHexString(l) + "; FLAGS=");
        }
        byte by = this.realInputStream.readByte();
        if (dump) {
            this.dumpElement(Integer.toHexString(by) + "; FIELD COUNT=");
        }
        int n = this.realInputStream.readShort();
        if (dump) {
            this.dumpElementln(Short.toString((short)n));
        }
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[n];
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l, by, objectStreamFieldArray);
        this.assignNewHandle(objectStreamClass);
        if (this.callersClassLoader == null) {
            this.callersClassLoader = this.currentLoader();
        }
        for (int i = 0; i < n; ++i) {
            if (dump) {
                this.dumpElement("  TYPE CODE=");
            }
            char c = (char)this.realInputStream.readByte();
            if (dump) {
                this.dumpElement(c + "; FIELD NAME=");
            }
            object2 = this.realInputStream.readUTF();
            if (dump) {
                this.dumpElementln((String)object2);
            }
            object = c == 'L' || c == '[' ? (String)this.readObject() : String.valueOf(c);
            objectStreamFieldArray[i] = new ObjectStreamField((String)object2, (String)object, this.callersClassLoader);
        }
        try {
            clazz = this.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals("void")) {
                clazz = Void.TYPE;
            }
            if (string.equals("boolean")) {
                clazz = Boolean.TYPE;
            }
            if (string.equals("byte")) {
                clazz = Byte.TYPE;
            }
            if (string.equals("short")) {
                clazz = Short.TYPE;
            }
            if (string.equals("char")) {
                clazz = Character.TYPE;
            }
            if (string.equals("int")) {
                clazz = Integer.TYPE;
            }
            if (string.equals("long")) {
                clazz = Long.TYPE;
            }
            if (string.equals("float")) {
                clazz = Float.TYPE;
            }
            if (string.equals("double")) {
                clazz = Double.TYPE;
            }
            throw classNotFoundException;
        }
        boolean bl = this.setBlockDataMode(true);
        objectStreamClass.setClass(clazz, this.lookupClass(clazz.getSuperclass()));
        this.classLookupTable.put(clazz, objectStreamClass);
        this.setBlockDataMode(bl);
        object2 = clazz.getSuperclass();
        if (object2 == null) {
            object2 = clazz;
        } else {
            while (ObjectInputStream.class$("java.io.Serializable").isAssignableFrom((Class)object2) || Modifier.isAbstract(((Class)object2).getModifiers())) {
                object2 = ((Class)object2).getSuperclass();
            }
        }
        object = object2;
        objectStreamClass.firstNonSerializableParentConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedAction(this, (Class)object){
            private /* synthetic */ ObjectInputStream this$0;
            private /* synthetic */ Class val$local_constructor_class;
            {
                this.this$0 = objectInputStream;
                this.finit$(clazz);
            }

            private /* synthetic */ void finit$(Class clazz) {
                this.val$local_constructor_class = clazz;
            }

            public Object run() {
                try {
                    Constructor constructor = this.val$local_constructor_class.getDeclaredConstructor(new Class[0]);
                    if (Modifier.isPrivate(constructor.getModifiers())) {
                        return null;
                    }
                    return constructor;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        objectStreamClass.realClassIsSerializable = ObjectInputStream.class$("java.io.Serializable").isAssignableFrom(clazz);
        objectStreamClass.realClassIsExternalizable = ObjectInputStream.class$("java.io.Externalizable").isAssignableFrom(clazz);
        ObjectStreamField[] objectStreamFieldArray2 = objectStreamClass.fields;
        ObjectStreamField[] objectStreamFieldArray3 = ObjectStreamClass.lookupForClassObject((Class)clazz).fields;
        ObjectStreamField[] objectStreamFieldArray4 = new ObjectStreamField[2 * Math.max(objectStreamFieldArray2.length, objectStreamFieldArray3.length)];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.checkTypeConsistency(string, objectStreamFieldArray3, objectStreamFieldArray2);
        this.checkTypeConsistency(string, objectStreamFieldArray2, objectStreamFieldArray3);
        while (n2 < objectStreamFieldArray2.length || n3 < objectStreamFieldArray3.length) {
            ObjectStreamField objectStreamField = null;
            ObjectStreamField objectStreamField2 = null;
            if (n2 == objectStreamFieldArray2.length) {
                objectStreamField2 = objectStreamFieldArray3[n3++];
            } else if (n3 == objectStreamFieldArray3.length) {
                objectStreamField = objectStreamFieldArray2[n2++];
            } else {
                int n5 = objectStreamFieldArray3[n3].compareTo(objectStreamFieldArray2[n2]);
                if (n5 < 0) {
                    objectStreamField2 = objectStreamFieldArray3[n3++];
                } else if (n5 > 0) {
                    objectStreamField = objectStreamFieldArray2[n2++];
                } else {
                    objectStreamField = objectStreamFieldArray2[n2++];
                    objectStreamField2 = objectStreamFieldArray3[n3++];
                    if (objectStreamField.getType() != objectStreamField2.getType()) {
                        throw new InvalidClassException("invalid field type for " + objectStreamField2.getName() + " in class " + string);
                    }
                }
            }
            if (n4 == objectStreamFieldArray4.length) {
                ObjectStreamField[] objectStreamFieldArray5 = new ObjectStreamField[objectStreamFieldArray4.length + 2];
                System.arraycopy(objectStreamFieldArray4, 0, objectStreamFieldArray5, 0, objectStreamFieldArray4.length);
                objectStreamFieldArray4 = objectStreamFieldArray5;
            }
            objectStreamFieldArray4[n4++] = objectStreamField;
            objectStreamFieldArray4[n4++] = objectStreamField2;
        }
        objectStreamClass.fieldMapping = objectStreamFieldArray4;
        return objectStreamClass;
    }

    public void defaultReadObject() throws ClassNotFoundException, IOException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        boolean bl = this.setBlockDataMode(false);
        this.readFields(this.currentObject, this.currentObjectStreamClass);
        this.setBlockDataMode(bl);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws InvalidObjectException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        this.validators.addElement(new ValidatorAndPriority(objectInputValidation, n));
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        block0: {
            if (this.callersClassLoader != null) break block0;
            this.callersClassLoader = this.currentLoader();
        }
        return Class.forName(objectStreamClass.getName(), true, this.callersClassLoader);
    }

    private native ClassLoader currentLoader();

    private ObjectStreamClass lookupClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.classLookupTable.get(clazz);
        if (objectStreamClass == null) {
            return ObjectStreamClass.lookup(clazz);
        }
        return objectStreamClass;
    }

    private ObjectStreamClass[] inputGetObjectStreamClasses(Class clazz) {
        ObjectStreamClass objectStreamClass = this.lookupClass(clazz);
        if (objectStreamClass == null) {
            return new ObjectStreamClass[0];
        }
        Vector vector = new Vector();
        while (objectStreamClass != null) {
            vector.addElement(objectStreamClass);
            objectStreamClass = objectStreamClass.getSuper();
        }
        int n = vector.size();
        ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n];
        for (int i = n - 1; i >= 0; --i) {
            objectStreamClassArray[n - i - 1] = (ObjectStreamClass)vector.elementAt(i);
        }
        return objectStreamClassArray;
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        int n;
        ClassLoader classLoader = this.currentLoader();
        Class[] classArray = new Class[stringArray.length];
        if (classLoader == null) {
            for (n = 0; n < stringArray.length; ++n) {
                classArray[n] = Class.forName(stringArray[n]);
            }
            classLoader = ClassLoader.getSystemClassLoader();
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                classArray[n] = classLoader.loadClass(stringArray[n]);
            }
        }
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean bl2 = this.resolveEnabled;
        this.resolveEnabled = bl;
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (dump) {
            this.dumpElement("STREAM MAGIC ");
        }
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        if (dump) {
            this.dumpElementln("STREAM VERSION ");
        }
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition + n2 > this.blockDataBytes) {
                int n3 = this.blockDataBytes - this.blockDataPosition;
                if (n3 != 0) {
                    System.arraycopy(this.blockData, this.blockDataPosition, byArray, n, n3);
                    n += n3;
                    n2 -= n3;
                }
                this.readNextBlock();
            }
            System.arraycopy(this.blockData, this.blockDataPosition, byArray, n, n2);
            this.blockDataPosition += n2;
            return n2;
        }
        return this.realInputStream.read(byArray, n, n2);
    }

    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    public void close() throws IOException {
        this.realInputStream.close();
    }

    public boolean readBoolean() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        boolean bl3 = this.dataInputStream.readBoolean();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return bl3;
    }

    public byte readByte() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        byte by = this.dataInputStream.readByte();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return by;
    }

    public int readUnsignedByte() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 1) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readUnsignedByte();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    public short readShort() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        short s = this.dataInputStream.readShort();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return s;
    }

    public int readUnsignedShort() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readUnsignedShort();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    public char readChar() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 2) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        char c = this.dataInputStream.readChar();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return c;
    }

    public int readInt() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 4) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        int n = this.dataInputStream.readInt();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return n;
    }

    public long readLong() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 8) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        long l = this.dataInputStream.readLong();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return l;
    }

    public float readFloat() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 4) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        float f = this.dataInputStream.readFloat();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return f;
    }

    public double readDouble() throws IOException {
        boolean bl = true;
        boolean bl2 = this.readDataFromBlock;
        if (!bl2 || this.blockDataBytes - this.blockDataPosition >= 8) {
            bl = false;
        }
        if (bl) {
            bl2 = this.setBlockDataMode(true);
        }
        double d = this.dataInputStream.readDouble();
        if (bl) {
            this.setBlockDataMode(bl2);
        }
        return d;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dataInputStream.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dataInputStream.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.prereadFields != null) {
            return this.prereadFields;
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        ObjectStreamClass objectStreamClass = this.currentObjectStreamClass;
        byte[] byArray = new byte[objectStreamClass.primFieldSize];
        Object[] objectArray = new Object[objectStreamClass.objectFieldCount];
        boolean bl = this.setBlockDataMode(false);
        this.readFully(byArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.readObject();
        }
        this.setBlockDataMode(bl);
        this.prereadFields = new GetField(this, objectArray, byArray, objectStreamClass){
            private /* synthetic */ ObjectInputStream this$0;
            private /* synthetic */ Object[] val$objs;
            private /* synthetic */ byte[] val$prim_field_data;
            private /* synthetic */ ObjectStreamClass val$clazz;
            {
                this.this$0 = objectInputStream;
                this.finit$(objectArray, byArray, objectStreamClass);
            }

            private /* synthetic */ void finit$(Object[] objectArray, byte[] byArray, ObjectStreamClass objectStreamClass) {
                this.val$clazz = objectStreamClass;
                this.val$prim_field_data = byArray;
                this.val$objs = objectArray;
            }

            public ObjectStreamClass getObjectStreamClass() {
                return this.val$clazz;
            }

            public boolean defaulted(String string) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.val$clazz.getField(string);
                if (objectStreamField != null) {
                    return objectStreamField.isPersistent() && !objectStreamField.isToSet();
                }
                try {
                    return this.val$clazz.forClass().getDeclaredField(string) != null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException(noSuchFieldException.getMessage());
                }
            }

            public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Boolean.TYPE);
                if (objectStreamField == null) {
                    return bl;
                }
                return this.val$prim_field_data[objectStreamField.getOffset()] != 0;
            }

            public char get(String string, char c) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Character.TYPE);
                if (objectStreamField == null) {
                    return c;
                }
                int n = objectStreamField.getOffset();
                return (char)((this.val$prim_field_data[n++] & 0xFF) << 8 | this.val$prim_field_data[n] & 0xFF);
            }

            public byte get(String string, byte by) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Byte.TYPE);
                if (objectStreamField == null) {
                    return by;
                }
                return this.val$prim_field_data[objectStreamField.getOffset()];
            }

            public short get(String string, short s) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Short.TYPE);
                if (objectStreamField == null) {
                    return s;
                }
                int n = objectStreamField.getOffset();
                return (short)((short)((this.val$prim_field_data[n++] & 0xFF) << 8) | (short)this.val$prim_field_data[n] & 0xFF);
            }

            public int get(String string, int n) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Integer.TYPE);
                if (objectStreamField == null) {
                    return n;
                }
                int n2 = objectStreamField.getOffset();
                return (this.val$prim_field_data[n2++] & 0xFF) << 24 | (this.val$prim_field_data[n2++] & 0xFF) << 16 | (this.val$prim_field_data[n2++] & 0xFF) << 8 | this.val$prim_field_data[n2] & 0xFF;
            }

            public long get(String string, long l) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Long.TYPE);
                if (objectStreamField == null) {
                    return l;
                }
                int n = objectStreamField.getOffset();
                return ((long)this.val$prim_field_data[n++] & (long)255) << 56 | ((long)this.val$prim_field_data[n++] & (long)255) << 48 | ((long)this.val$prim_field_data[n++] & (long)255) << 40 | ((long)this.val$prim_field_data[n++] & (long)255) << 32 | (long)((this.val$prim_field_data[n++] & 0xFF) << 24) | (long)((this.val$prim_field_data[n++] & 0xFF) << 16) | (long)((this.val$prim_field_data[n++] & 0xFF) << 8) | (long)this.val$prim_field_data[n] & (long)255;
            }

            public float get(String string, float f) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Float.TYPE);
                if (objectStreamField == null) {
                    return f;
                }
                int n = objectStreamField.getOffset();
                return Float.intBitsToFloat((this.val$prim_field_data[n++] & 0xFF) << 24 | (this.val$prim_field_data[n++] & 0xFF) << 16 | (this.val$prim_field_data[n++] & 0xFF) << 8 | this.val$prim_field_data[n] & 0xFF);
            }

            public double get(String string, double d) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, Double.TYPE);
                if (objectStreamField == null) {
                    return d;
                }
                int n = objectStreamField.getOffset();
                return Double.longBitsToDouble(((long)this.val$prim_field_data[n++] & (long)255) << 56 | ((long)this.val$prim_field_data[n++] & (long)255) << 48 | ((long)this.val$prim_field_data[n++] & (long)255) << 40 | ((long)this.val$prim_field_data[n++] & (long)255) << 32 | (long)((this.val$prim_field_data[n++] & 0xFF) << 24) | (long)((this.val$prim_field_data[n++] & 0xFF) << 16) | (long)((this.val$prim_field_data[n++] & 0xFF) << 8) | (long)this.val$prim_field_data[n] & (long)255);
            }

            public Object get(String string, Object object) throws IOException, IllegalArgumentException {
                ObjectStreamField objectStreamField = this.getField(string, object == null ? null : object.getClass());
                if (objectStreamField == null) {
                    return object;
                }
                return this.val$objs[objectStreamField.getOffset()];
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private ObjectStreamField getField(String string, Class clazz) throws IllegalArgumentException {
                ObjectStreamField objectStreamField;
                boolean bl;
                ObjectStreamField objectStreamField2;
                block20: {
                    ObjectStreamField objectStreamField3;
                    block17: {
                        objectStreamField2 = this.val$clazz.getField(string);
                        bl = false;
                        try {
                            block19: {
                                block18: {
                                    try {
                                        String string2;
                                        Class clazz2 = objectStreamField2.getType();
                                        if (clazz == clazz2 || clazz == null && !clazz2.isPrimitive()) {
                                            objectStreamField3 = objectStreamField2;
                                            Object var7_9 = null;
                                            if (bl || objectStreamField2 == null) break block17;
                                            break block18;
                                        }
                                        bl = true;
                                        StringBuffer stringBuffer = new StringBuffer("Field requested is of type ").append(clazz2.getName()).append(", but requested type was ");
                                        if (clazz == null) {
                                            string2 = "Object";
                                            throw new IllegalArgumentException(stringBuffer.append(string2).toString());
                                        }
                                        string2 = clazz.getName();
                                        throw new IllegalArgumentException(stringBuffer.append(string2).toString());
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        break block19;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw illegalArgumentException;
                                    }
                                }
                                if (!objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                                    return null;
                                }
                                break block17;
                            }
                            objectStreamField = null;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            if (!bl && objectStreamField2 != null && !objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                                return null;
                            }
                            try {
                                Field field = this.val$clazz.forClass().getDeclaredField(string);
                                if (Modifier.isTransient(field.getModifiers())) {
                                    throw new IllegalArgumentException("no such field (non transient) " + string);
                                }
                                if (objectStreamField2 != null) throw throwable;
                                if (field.getType() == clazz) throw throwable;
                                throw new IllegalArgumentException("Invalid requested type for field " + string);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                if (objectStreamField2 != null) throw throwable;
                                throw new IllegalArgumentException(noSuchFieldException.getMessage());
                            }
                        }
                    }
                    try {}
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (objectStreamField2 != null) return objectStreamField3;
                        throw new IllegalArgumentException(noSuchFieldException.getMessage());
                    }
                    Field field = this.val$clazz.forClass().getDeclaredField(string);
                    if (Modifier.isTransient(field.getModifiers())) {
                        throw new IllegalArgumentException("no such field (non transient) " + string);
                    }
                    if (objectStreamField2 != null) return objectStreamField3;
                    if (field.getType() == clazz) return objectStreamField3;
                    throw new IllegalArgumentException("Invalid requested type for field " + string);
                }
                Object var7_12 = null;
                if (!bl && objectStreamField2 != null && !objectStreamField2.isToSet() && objectStreamField2.isPersistent()) {
                    return null;
                }
                try {}
                catch (NoSuchFieldException noSuchFieldException) {
                    if (objectStreamField2 != null) return objectStreamField;
                    throw new IllegalArgumentException(noSuchFieldException.getMessage());
                }
                Field field = this.val$clazz.forClass().getDeclaredField(string);
                if (Modifier.isTransient(field.getModifiers())) {
                    throw new IllegalArgumentException("no such field (non transient) " + string);
                }
                if (objectStreamField2 != null) return objectStreamField;
                if (field.getType() == clazz) return objectStreamField;
                throw new IllegalArgumentException("Invalid requested type for field " + string);
            }
        };
        this.fieldsAlreadyRead = true;
        return this.prereadFields;
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        this.finit$();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected Object readObjectOverride() throws ClassNotFoundException, IOException, OptionalDataException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private int assignNewHandle(Object object) {
        this.objectLookupTable.put(new Integer(this.nextOID), new ObjectIdentityWrapper(object));
        return this.nextOID++;
    }

    private Object processResolution(ObjectStreamClass objectStreamClass, Object object, int n) throws IOException {
        block8: {
            if (objectStreamClass != null && object instanceof Serializable) {
                try {
                    Method method = objectStreamClass.readResolveMethod;
                    if (method != null) {
                        object = method.invoke(object, new Object[0]);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof ObjectStreamException) {
                        throw (ObjectStreamException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (!(throwable instanceof Error)) break block8;
                    throw (Error)throwable;
                }
            }
        }
        if (this.resolveEnabled) {
            object = this.resolveObject(object);
        }
        this.objectLookupTable.put(new Integer(n), new ObjectIdentityWrapper(object));
        return object;
    }

    private void clearHandles() {
        this.objectLookupTable.clear();
        this.nextOID = 0x7E0000;
    }

    private void readNextBlock() throws IOException {
        this.readNextBlock(this.realInputStream.readByte());
    }

    private void readNextBlock(byte by) throws IOException {
        if (by == 119) {
            if (dump) {
                this.dumpElement("BLOCK DATA SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else if (by == 122) {
            if (dump) {
                this.dumpElement("BLOCK DATA LONG SIZE=");
            }
            this.blockDataBytes = this.realInputStream.readInt();
            if (dump) {
                this.dumpElementln(Integer.toString(this.blockDataBytes));
            }
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private void readArrayElements(Object object, Class clazz) throws ClassNotFoundException, IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = this.realInputStream.readBoolean();
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = this.realInputStream.readByte();
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = this.realInputStream.readChar();
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.realInputStream.readDouble();
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.realInputStream.readFloat();
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.realInputStream.readInt();
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = this.realInputStream.readLong();
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = this.realInputStream.readShort();
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.readObject();
            }
        }
    }

    private void readFields(Object object, ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fieldMapping;
        block11: for (int i = 0; i < objectStreamFieldArray.length; i += 2) {
            char c;
            String string;
            boolean bl;
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ObjectStreamField objectStreamField2 = objectStreamFieldArray[i + 1];
            boolean bl2 = objectStreamField != null && objectStreamField.getOffset() >= 0 && objectStreamField.isToSet();
            boolean bl3 = bl = objectStreamField2 != null && objectStreamField2.isToSet();
            if (objectStreamField != null) {
                string = objectStreamField.getName();
                c = objectStreamField.getTypeCode();
            } else {
                string = objectStreamField2.getName();
                c = objectStreamField2.getTypeCode();
            }
            switch (c) {
                case 'Z': {
                    boolean bl4;
                    boolean bl5 = bl4 = bl2 ? this.realInputStream.readBoolean() : false;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + bl4);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setBooleanField(object, bl4);
                    continue block11;
                }
                case 'B': {
                    byte by;
                    byte by2 = by = bl2 ? this.realInputStream.readByte() : (byte)0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + by);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setByteField(object, by);
                    continue block11;
                }
                case 'C': {
                    char c2;
                    char c3 = c2 = bl2 ? this.realInputStream.readChar() : (char)'\u0000';
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + c2);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setCharField(object, c2);
                    continue block11;
                }
                case 'D': {
                    double d;
                    double d2 = d = bl2 ? this.realInputStream.readDouble() : 0.0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + d);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setDoubleField(object, d);
                    continue block11;
                }
                case 'F': {
                    float f;
                    float f2 = f = bl2 ? this.realInputStream.readFloat() : 0.0f;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + f);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setFloatField(object, f);
                    continue block11;
                }
                case 'I': {
                    int n;
                    int n2 = n = bl2 ? this.realInputStream.readInt() : 0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + n);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setIntField(object, n);
                    continue block11;
                }
                case 'J': {
                    long l;
                    long l2 = l = bl2 ? this.realInputStream.readLong() : 0L;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + l);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setLongField(object, l);
                    continue block11;
                }
                case 'S': {
                    short s;
                    short s2 = s = bl2 ? this.realInputStream.readShort() : (short)0;
                    if (dump && bl2 && bl) {
                        this.dumpElementln("  " + string + ": " + s);
                    }
                    if (!bl) continue block11;
                    objectStreamField2.setShortField(object, s);
                    continue block11;
                }
                case 'L': 
                case '[': {
                    Object object2;
                    Object object3 = object2 = bl2 ? this.readObject() : null;
                    if (!bl) continue block11;
                    objectStreamField2.setObjectField(object, object2);
                    continue block11;
                }
                default: {
                    throw new InternalError("Invalid type code: " + c);
                }
            }
        }
    }

    private boolean setBlockDataMode(boolean bl) {
        boolean bl2 = this.readDataFromBlock;
        this.readDataFromBlock = bl;
        this.dataInputStream = bl ? this.blockDataInput : this.realInputStream;
        return bl2;
    }

    private Object newObject(Class clazz, Constructor constructor) throws ClassNotFoundException, IOException {
        if (constructor == null) {
            throw new InvalidClassException("Missing accessible no-arg base class constructor for " + clazz.getName());
        }
        try {
            return this.allocateObject(clazz, constructor.getDeclaringClass(), constructor);
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException("Instance of " + clazz + " could not be created");
        }
    }

    private void invokeValidators() throws InvalidObjectException {
        Object[] objectArray = new Object[this.validators.size()];
        this.validators.copyInto(objectArray);
        Arrays.sort(objectArray);
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ObjectInputValidation)objectArray[i]).validateObject();
            }
            Object var2_3 = null;
            this.validators.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.validators.removeAllElements();
            throw throwable;
        }
    }

    private void callReadMethod(Method method, Class clazz, Object object) throws ClassNotFoundException, IOException {
        try {
            method.invoke(object, new Object[]{this});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new IOException("Exception thrown from readObject() on " + clazz + ": " + throwable.getClass().getName());
        }
        catch (Exception exception) {
            throw new IOException("Failure invoking readObject() on " + clazz + ": " + exception.getClass().getName());
        }
        this.prereadFields = null;
    }

    private native Object allocateObject(Class var1, Class var2, Constructor var3) throws InstantiationException;

    private void dumpElement(String string) {
        System.out.print(string);
    }

    private void dumpElementln(String string) {
        System.out.println(string);
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(" ");
        }
        System.out.print(Thread.currentThread() + ": ");
    }

    private static final class ValidatorAndPriority
    implements Comparable {
        int priority;
        ObjectInputValidation validator;

        ValidatorAndPriority(ObjectInputValidation objectInputValidation, int n) {
            this.priority = n;
            this.validator = objectInputValidation;
        }

        public int compareTo(Object object) {
            ValidatorAndPriority validatorAndPriority = (ValidatorAndPriority)object;
            return this.priority - validatorAndPriority.priority;
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

