/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private byte[] key;
    private static final byte[][] WEAK_KEYS = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {-1, -1, -1, -1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1}, {31, 31, 31, 31, 14, 14, 14, 14}, {1, -2, 1, -2, 1, -2, 1, -2}, {31, -32, 31, -32, -32, 31, -32, 31}, {1, -32, 1, -32, 1, -15, 1, -15}, {31, -2, 31, -2, 14, -2, 14, -2}, {1, 31, 1, 31, 1, 14, 1, 14}, {-32, -2, -32, -2, -15, -2, -15, -2}};

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < 8; ++i) {
            bl2 = false;
            for (int j = 0; j < 8; ++j) {
                bl2 ^= (byArray[i + n] & 1 << (j & 0x1F)) != 0;
            }
            bl &= bl2;
        }
        return bl;
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES keys must be 8 bytes long");
        }
        for (int i = 0; i < WEAK_KEYS.length; ++i) {
            if (!DESKeySpec.equalsOrComplementEquals(byArray, n, WEAK_KEYS[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean equalsOrComplementEquals(byte[] byArray, int n, byte[] byArray2) {
        int n2;
        boolean bl = true;
        for (n2 = 0; n2 < 8; ++n2) {
            bl &= byArray[n + n2] == byArray2[n2];
        }
        if (bl) {
            return true;
        }
        bl = true;
        for (n2 = 0; n2 < 8; ++n2) {
            bl &= byArray[n + n2] == ~byArray2[n2];
        }
        return bl;
    }

    public byte[] getKey() {
        return this.key;
    }
}

