/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageReader {
    private boolean aborted;
    protected Locale[] availableLocales;
    protected boolean ignoreMetadata;
    protected Object input;
    protected Locale locale;
    protected int minIndex;
    protected ImageReaderSpi originatingProvider;
    protected List progressListeners;
    protected boolean seekForwardOnly;
    protected List updateListeners;
    protected List warningListeners;
    protected List warningLocales;

    private /* synthetic */ void finit$() {
        this.availableLocales = null;
        this.ignoreMetadata = false;
        this.input = null;
        this.locale = null;
        this.minIndex = 0;
        this.originatingProvider = null;
        this.progressListeners = null;
        this.seekForwardOnly = false;
        this.updateListeners = null;
        this.warningListeners = null;
        this.warningLocales = null;
    }

    protected ImageReader(ImageReaderSpi imageReaderSpi) {
        this.finit$();
        this.originatingProvider = imageReaderSpi;
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean abortRequested() {
        return this.aborted;
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null) {
            return;
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList();
        }
        this.progressListeners.add(iIOReadProgressListener);
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null) {
            return;
        }
        if (this.updateListeners == null) {
            this.updateListeners = new ArrayList();
        }
        this.updateListeners.add(iIOReadUpdateListener);
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null) {
            return;
        }
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList();
        }
        this.warningListeners.add(iIOReadWarningListener);
    }

    public boolean canReadRaster() {
        return false;
    }

    protected void clearAbortRequest() {
        this.aborted = false;
    }

    public void dispose() {
    }

    public float getAspectRatio(int n) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input is null");
        }
        return this.getWidth(n) / this.getHeight(n);
    }

    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            return null;
        }
        return (Locale[])this.availableLocales.clone();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public String getFormatName() throws IOException {
        return this.originatingProvider.getFormatNames()[0];
    }

    public abstract int getHeight(int var1) throws IOException;

    public abstract IIOMetadata getImageMetadata(int var1) throws IOException;

    public abstract Iterator getImageTypes(int var1) throws IOException;

    public void setInput(Object object, boolean bl, boolean bl2) {
        Class[] classArray = this.originatingProvider.getInputTypes();
        if (classArray == null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException();
            }
        } else {
            boolean bl3 = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isInstance(object)) continue;
                bl3 = true;
            }
            if (!bl3) {
                throw new IllegalArgumentException();
            }
        }
        this.input = object;
        this.seekForwardOnly = bl;
        this.ignoreMetadata = bl2;
        this.minIndex = 0;
    }

    public void setInput(Object object, boolean bl) {
        this.setInput(object, bl, false);
    }

    public void setInput(Object object) {
        this.setInput(object, false, false);
    }

    public Object getInput() {
        return this.input;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract int getNumImages(boolean var1) throws IOException;

    public int getNumThumbnails(int n) throws IOException {
        return 0;
    }

    public ImageReaderSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public abstract IIOMetadata getStreamMetadata() throws IOException;

    public int getThumbnailHeight(int n, int n2) throws IOException {
        return this.readThumbnail(n, n2).getHeight();
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        return this.readThumbnail(n, n2).getWidth();
    }

    public int getTileGridXOffset(int n) throws IOException {
        return 0;
    }

    public int getTileGridYOffset(int n) throws IOException {
        return 0;
    }

    public int getTileHeight(int n) throws IOException {
        return this.getHeight(n);
    }

    public int getTileWidth(int n) throws IOException {
        return this.getWidth(n);
    }

    public abstract int getWidth(int var1) throws IOException;

    public boolean hasThumbnails(int n) throws IOException {
        return this.getNumThumbnails(n) > 0;
    }

    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public boolean isImageTiled(int n) throws IOException {
        return false;
    }

    public boolean isRandomAccessEasy(int n) throws IOException {
        return false;
    }

    public boolean isSeekForwardOnly() {
        return this.seekForwardOnly;
    }

    protected void processImageComplete() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.imageComplete(this);
            }
        }
    }

    protected void processImageProgress(float f) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.imageProgress(this, f);
            }
        }
    }

    protected void processImageStarted(int n) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.imageStarted(this, n);
            }
        }
    }

    protected void processImageUpdate(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (this.updateListeners != null) {
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)iterator.next();
                iIOReadUpdateListener.imageUpdate(this, bufferedImage, n, n2, n3, n4, n5, n6, nArray);
            }
        }
    }

    protected void processPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners != null) {
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)iterator.next();
                iIOReadUpdateListener.passComplete(this, bufferedImage);
            }
        }
    }

    protected void processPassStarted(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners != null) {
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)iterator.next();
                iIOReadUpdateListener.passStarted(this, bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
            }
        }
    }

    protected void processReadAborted() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.readAborted(this);
            }
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.sequenceComplete(this);
            }
        }
    }

    protected void processSequenceStarted(int n) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.sequenceStarted(this, n);
            }
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.thumbnailComplete(this);
            }
        }
    }

    protected void processThumbnailPassComplete(BufferedImage bufferedImage) {
        if (this.updateListeners != null) {
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)iterator.next();
                iIOReadUpdateListener.thumbnailPassComplete(this, bufferedImage);
            }
        }
    }

    protected void processThumbnailPassStarted(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (this.updateListeners != null) {
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)iterator.next();
                iIOReadUpdateListener.thumbnailPassStarted(this, bufferedImage, n, n2, n3, n4, n5, n6, n7, nArray);
            }
        }
    }

    protected void processThumbnailProgress(float f) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.thumbnailProgress(this, f);
            }
        }
    }

    protected void processThumbnailStarted(int n, int n2) {
        if (this.progressListeners != null) {
            Iterator iterator = this.progressListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadProgressListener iIOReadProgressListener = (IIOReadProgressListener)iterator.next();
                iIOReadProgressListener.thumbnailStarted(this, n, n2);
            }
        }
    }

    protected void processThumbnailUpdate(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (this.updateListeners != null) {
            Iterator iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadUpdateListener iIOReadUpdateListener = (IIOReadUpdateListener)iterator.next();
                iIOReadUpdateListener.thumbnailUpdate(this, bufferedImage, n, n2, n3, n4, n5, n6, nArray);
            }
        }
    }

    protected void processWarningOccurred(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.warningListeners != null) {
            Iterator iterator = this.warningListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadWarningListener iIOReadWarningListener = (IIOReadWarningListener)iterator.next();
                iIOReadWarningListener.warningOccurred(this, string);
            }
        }
    }

    protected void processWarningOccurred(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, this.getLocale());
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no resource bundle found");
        }
        Object object = null;
        try {
            object = resourceBundle.getObject(string2);
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no results found for keyword");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("retrieved object not a String");
        }
        String string3 = (String)object;
        if (this.warningListeners != null) {
            Iterator iterator = this.warningListeners.iterator();
            while (iterator.hasNext()) {
                IIOReadWarningListener iIOReadWarningListener = (IIOReadWarningListener)iterator.next();
                iIOReadWarningListener.warningOccurred(this, string3);
            }
        }
    }

    public abstract BufferedImage read(int var1, ImageReadParam var2) throws IOException;

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        throw new UnsupportedOperationException();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIIOReadProgressListeners() {
        this.progressListeners = null;
    }

    public void removeAllIIOReadUpdateListeners() {
        this.updateListeners = null;
    }

    public void removeAllIIOReadWarningListeners() {
        this.warningListeners = null;
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        if (iIOReadProgressListener == null) {
            return;
        }
        if (this.progressListeners != null) {
            this.progressListeners.remove(iIOReadProgressListener);
        }
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        if (iIOReadUpdateListener == null) {
            return;
        }
        if (this.updateListeners != null) {
            this.updateListeners.remove(iIOReadUpdateListener);
        }
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        if (iIOReadWarningListener == null) {
            return;
        }
        if (this.warningListeners != null) {
            this.warningListeners.remove(iIOReadWarningListener);
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            boolean bl = false;
            if (this.availableLocales != null) {
                for (int i = this.availableLocales.length - 1; i >= 0; --i) {
                    if (!this.availableLocales[i].equals(locale)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("looale not available");
            }
        }
        this.locale = locale;
    }

    protected static void checkReadParamBandSettings(ImageReadParam imageReadParam, int n, int n2) {
        int[] nArray = imageReadParam.getSourceBands();
        int[] nArray2 = imageReadParam.getDestinationBands();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (nArray == null) {
            if (nArray2 == null) {
                if (n != n2) {
                    bl = true;
                }
            } else {
                if (n != nArray2.length) {
                    bl = true;
                }
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] <= n - 1) continue;
                    bl3 = true;
                    break;
                }
            }
        } else if (nArray2 == null) {
            if (nArray.length != n2) {
                bl = true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= n2 - 1) continue;
                bl2 = true;
                break;
            }
        } else {
            int n3;
            if (nArray.length != nArray2.length) {
                bl = true;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] <= n2 - 1) continue;
                bl2 = true;
                break;
            }
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                if (nArray2[n3] <= n - 1) continue;
                bl3 = true;
                break;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("array lengths differ");
        }
        if (bl2) {
            throw new IllegalArgumentException("source band index out-of-bounds");
        }
        if (bl3) {
            throw new IllegalArgumentException("destination band index out-of-bounds");
        }
    }

    protected static void computeRegions(ImageReadParam imageReadParam, int n, int n2, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            throw new IllegalArgumentException("null region");
        }
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("zero-sized region");
        }
        rectangle = ImageReader.getSourceRegion(imageReadParam, n, n2);
        rectangle2 = bufferedImage != null ? new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()) : new Rectangle(0, 0, n, n2);
        if (imageReadParam != null) {
            Point point = imageReadParam.getDestinationOffset();
            if (point.x < 0) {
                rectangle.x -= point.x;
                rectangle.width += point.x;
            }
            if (point.y < 0) {
                rectangle.y -= point.y;
                rectangle.height += point.y;
            }
            rectangle.width = rectangle.width > rectangle2.width ? rectangle2.width : rectangle.width;
            int n3 = rectangle.height = rectangle.height > rectangle2.height ? rectangle2.height : rectangle.height;
            if (point.x >= 0) {
                rectangle2.x += point.x;
                rectangle2.width -= point.x;
            }
            if (point.y >= 0) {
                rectangle2.y += point.y;
                rectangle2.height -= point.y;
            }
        }
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            throw new IllegalArgumentException("zero-sized region");
        }
    }

    protected static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator iterator, int n, int n2) throws IIOException {
        Object object;
        Object object2;
        Object object3;
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("negative dimension");
        }
        if (n * n2 < Math.min(n, n2)) {
            throw new IllegalArgumentException("width * height > Integer.MAX_VALUE");
        }
        BufferedImage bufferedImage = null;
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null && (bufferedImage = imageReadParam.getDestination()) == null && (object3 = imageReadParam.getDestinationType()) != null) {
            object2 = iterator;
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof ImageTypeSpecifier)) {
                    throw new IllegalArgumentException("non-ImageTypeSpecifier object");
                }
                ImageTypeSpecifier imageTypeSpecifier2 = (ImageTypeSpecifier)object;
                if (imageTypeSpecifier2.equals(object3)) {
                    bufferedImage = imageTypeSpecifier2.createBufferedImage(n, n2);
                    break;
                }
                if (imageTypeSpecifier != null) continue;
                throw new IIOException("invalid destination type");
            }
        }
        if (bufferedImage == null) {
            object3 = new Rectangle();
            object2 = new Rectangle();
            ImageReader.computeRegions(imageReadParam, n, n2, null, (Rectangle)object3, (Rectangle)object2);
            if (((Rectangle)object2).isEmpty()) {
                throw new IllegalArgumentException("destination region empty");
            }
            if (imageTypeSpecifier == null) {
                object = iterator.next();
                if (!(object instanceof ImageTypeSpecifier)) {
                    throw new IllegalArgumentException("non-ImageTypeSpecifier object");
                }
                bufferedImage = ((ImageTypeSpecifier)object).createBufferedImage(((Rectangle)object2).width, ((Rectangle)object2).height);
            } else {
                bufferedImage = imageTypeSpecifier.createBufferedImage(((Rectangle)object2).width, ((Rectangle)object2).height);
            }
        }
        return bufferedImage;
    }

    public IIOMetadata getImageMetadata(int n, String string, Set set) throws IOException {
        if (string == null || set == null) {
            throw new IllegalArgumentException("null argument");
        }
        return this.getImageMetadata(n);
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        return (ImageTypeSpecifier)this.getImageTypes(n).next();
    }

    protected static Rectangle getSourceRegion(ImageReadParam imageReadParam, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        if (imageReadParam != null) {
            Rectangle rectangle2 = imageReadParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle.x = rectangle2.x > rectangle.x ? rectangle2.x : rectangle.x;
                rectangle.y = rectangle2.y > rectangle.y ? rectangle2.y : rectangle.y;
                rectangle.width = rectangle2.width > rectangle.width ? rectangle2.width : rectangle.width;
                rectangle.height = rectangle2.height > rectangle.height ? rectangle2.height : rectangle.height;
            }
            int n3 = imageReadParam.getSubsamplingXOffset();
            rectangle.x += n3;
            rectangle.width -= n3;
            int n4 = imageReadParam.getSubsamplingYOffset();
            rectangle.y += n4;
            rectangle.height -= n4;
        }
        return rectangle;
    }

    public IIOMetadata getStreamMetadata(String string, Set set) throws IOException {
        if (string == null || set == null) {
            throw new IllegalArgumentException("null argument");
        }
        return this.getStreamMetadata();
    }

    public BufferedImage read(int n) throws IOException {
        return this.read(n, null);
    }

    public IIOImage readAll(int n, ImageReadParam imageReadParam) throws IOException {
        ImageReader.checkReadParamBandSettings(imageReadParam, imageReadParam.getSourceBands().length, imageReadParam.getDestinationBands().length);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.getNumThumbnails(n); ++i) {
            arrayList.add(this.readThumbnail(n, i));
        }
        return new IIOImage(ImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.getWidth(n), this.getHeight(n)), (List)arrayList, this.getImageMetadata(n));
    }

    public Iterator readAll(Iterator iterator) throws IOException {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (iterator.hasNext()) {
            if (iterator != null && !(iterator instanceof ImageReadParam)) {
                throw new IllegalArgumentException("non-ImageReadParam found");
            }
            arrayList.add(this.readAll(n++, (ImageReadParam)iterator.next()));
        }
        return arrayList.iterator();
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        return this.read(n, imageReadParam);
    }

    public BufferedImage readTile(int n, int n2, int n3) throws IOException {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException("tileX not 0 or tileY not 0");
        }
        return this.read(n);
    }

    public Raster readTileRaster(int n, int n2, int n3) throws IOException {
        if (!this.canReadRaster()) {
            throw new UnsupportedOperationException("cannot read rasters");
        }
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException("tileX not 0 or tileY not 0");
        }
        return this.readRaster(n, null);
    }

    public void reset() {
        this.setInput(null, false);
        this.setLocale(null);
        this.removeAllIIOReadUpdateListeners();
        this.removeAllIIOReadWarningListeners();
        this.removeAllIIOReadProgressListeners();
        this.clearAbortRequest();
    }
}

