/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

class DefaultPreviewPanel
extends JPanel {
    private static int largeGap = 6;
    private static int smallGap = 2;
    private static int squareSize = 36;
    private static int textPadding = 4;
    private static int rightSideRectWidth = 60;
    private static String sample = "Sample Text   Sample Text";

    DefaultPreviewPanel() {
        this.setBorder(new PreviewBorder(this));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = null;
        JColorChooser jColorChooser = (JColorChooser)SwingUtilities.getAncestorOfClass(DefaultPreviewPanel.class$("javax.swing.JColorChooser"), this);
        if (jColorChooser != null) {
            color = jColorChooser.getColor();
        }
        Color color2 = graphics.getColor();
        Insets insets = this.getInsets();
        int n = insets.top + squareSize + largeGap;
        int n2 = insets.left;
        this.paintSquare(graphics, n2, insets.top, Color.WHITE, color, Color.WHITE, -1, -1, -1);
        this.paintSquare(graphics, n2, n, color, null, null, -1, -1, -1);
        this.paintSquare(graphics, n2 += squareSize + largeGap, insets.top, Color.BLACK, color, Color.WHITE, -1, -1, -1);
        this.paintSquare(graphics, n2, n, Color.WHITE, color, null, -1, -1, -1);
        this.paintSquare(graphics, n2 += squareSize + largeGap, insets.top, Color.WHITE, color, Color.BLACK, -1, -1, -1);
        this.paintSquare(graphics, n2, n, Color.BLACK, color, null, -1, -1, -1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(sample);
        int n4 = fontMetrics.getHeight();
        n2 += squareSize + largeGap;
        int n5 = 2 * textPadding + n3;
        int n6 = 2 * textPadding + n4;
        int n7 = insets.top + textPadding;
        int n8 = insets.top + n6 + smallGap;
        int n9 = insets.top + 2 * (n6 + smallGap);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(n2, n9, n5, n6);
        graphics.setColor(color);
        graphics.drawString(sample, n2 + textPadding, n7 + textPadding + fontMetrics.getAscent());
        graphics.fillRect(n2, n8, n5, n6);
        graphics.drawString(sample, n2 + textPadding, n9 + textPadding + fontMetrics.getAscent());
        graphics.setColor(Color.BLACK);
        graphics.drawString(sample, n2 + textPadding, n8 + textPadding + fontMetrics.getAscent());
        graphics.setColor(Color.WHITE);
        graphics.fillRect(n2 += n5 + largeGap, insets.top, rightSideRectWidth, squareSize + largeGap / 2);
        graphics.setColor(color);
        graphics.fillRect(n2, insets.top + squareSize + largeGap / 2, rightSideRectWidth, squareSize + largeGap / 2);
        graphics.setColor(color2);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void paintSquare(Graphics graphics, int n, int n2, Color color, Color color2, Color color3, int n3, int n4, int n5) {
        Color color4 = graphics.getColor();
        if (n3 == -1) {
            n3 = squareSize;
        }
        if (n4 == -1) {
            n4 = squareSize * 2 / 3;
        }
        if (n5 == -1) {
            n5 = squareSize / 3;
        }
        int n6 = (n3 - n4) / 2;
        int n7 = (n3 - n5) / 2;
        if (color == null) {
            return;
        }
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n3);
        if (color2 == null) {
            return;
        }
        graphics.setColor(color2);
        graphics.fillRect(n + n6, n2 + n6, n4, n4);
        if (color3 == null) {
            return;
        }
        graphics.setColor(color3);
        graphics.fillRect(n + n7, n2 + n7, n5, n5);
        graphics.setColor(color4);
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.dispose();
        int n = fontMetrics.stringWidth(sample);
        int n2 = fontMetrics.getHeight();
        int n3 = (n2 + 2 * textPadding) * 3 + 2 * smallGap;
        int n4 = 2 * squareSize + largeGap;
        int n5 = Math.max(n3, n4);
        int n6 = 3 * (squareSize + largeGap) + n + 2 * textPadding + largeGap + rightSideRectWidth;
        Insets insets = this.getInsets();
        return new Dimension(n6 + insets.right + insets.left, n5 + insets.top + insets.bottom);
    }

    class PreviewBorder
    implements Border {
        private /* synthetic */ DefaultPreviewPanel this$0;
        private static final int edge = 20;
        private static final int lead = 5;
        private static final int gap = 3;

        public Insets getBorderInsets(Component component) {
            return new Insets(20, 20, 20, 20);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n + 10, n2 + 10, n + 10, n2 + n4 - 10);
            graphics.drawLine(n + 10, n2 + n4 - 10, n + n3 - 10, n2 + n4 - 10);
            graphics.drawLine(n + n3 - 10, n2 + 10, n + n3 - 10, n2 + n4 - 10);
            graphics.drawLine(n + 10, n2 + 10, n + 10 + 5, n2 + 10);
            int n5 = fontMetrics.stringWidth("Preview");
            graphics.drawString("Preview", n + 10 + 5 + 3, n2 + 10 + fontMetrics.getAscent() / 2);
            graphics.drawLine(n + 5 + 10 + n5 + 6, n2 + 10, n + n3 - 10, n2 + 10);
            graphics.setColor(color);
        }

        PreviewBorder(DefaultPreviewPanel defaultPreviewPanel) {
            this.this$0 = defaultPreviewPanel;
        }
    }
}

