/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    public BasicButtonListener(AbstractButton abstractButton) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ((string.equals("text") || string.equals("font")) && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            String string2 = abstractButton.getText();
            if (string2 == null) {
                string2 = "";
            }
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
            TextLayout textLayout = new TextLayout(string2, abstractButton.getFont(), fontRenderContext);
            abstractButton.putClientProperty("BasicGraphicsUtils.cachedTextLayout", textLayout);
        }
    }

    protected void checkOpacity(AbstractButton abstractButton) {
    }

    public void focusGained(FocusEvent focusEvent) {
        AbstractButton abstractButton;
        if (focusEvent.getSource() instanceof AbstractButton && (abstractButton = (AbstractButton)focusEvent.getSource()).isFocusPainted()) {
            abstractButton.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        AbstractButton abstractButton;
        if (focusEvent.getSource() instanceof AbstractButton && (abstractButton = (AbstractButton)focusEvent.getSource()).isFocusPainted()) {
            abstractButton.repaint();
        }
    }

    public void installKeyboardActions(JComponent jComponent) {
        jComponent.getActionMap().put("pressed", new AbstractAction(this){
            private /* synthetic */ BasicButtonListener this$0;
            {
                this.this$0 = basicButtonListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
            }
        });
        jComponent.getActionMap().put("released", new AbstractAction(this){
            private /* synthetic */ BasicButtonListener this$0;
            {
                this.this$0 = basicButtonListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        });
    }

    public void uninstallKeyboardActions(JComponent jComponent) {
        jComponent.getActionMap().put("pressed", null);
        jComponent.getActionMap().put("released", null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.isFocusOwner() && abstractButton.isRequestFocusEnabled()) {
                    abstractButton.requestFocus();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (mouseEvent.getButton() == 1) {
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setRollover(true);
            }
            if (buttonModel.isPressed()) {
                buttonModel.setArmed(true);
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled()) {
                buttonModel.setRollover(false);
            }
            buttonModel.setArmed(false);
        }
    }
}

