/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.bootstrap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

public final class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private Vector sources;

    private DOMImplementationRegistry(Vector vector) {
        this.sources = vector;
    }

    public static DOMImplementationRegistry newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        Vector vector = new Vector();
        ClassLoader classLoader = DOMImplementationRegistry.getClassLoader();
        String string = DOMImplementationRegistry.getSystemProperty(PROPERTY);
        if (string == null) {
            string = DOMImplementationRegistry.getServiceValue(classLoader);
        }
        if (string == null) {
            string = "gnu.xml.dom.ImplementationSource";
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Class clazz = null;
                clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)clazz.newInstance();
                vector.addElement(dOMImplementationSource);
            }
        }
        return new DOMImplementationRegistry(vector);
    }

    public DOMImplementation getDOMImplementation(String string) {
        int n = this.sources.size();
        Object var3_3 = null;
        for (int i = 0; i < n; ++i) {
            DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)this.sources.elementAt(i);
            DOMImplementation dOMImplementation = dOMImplementationSource.getDOMImplementation(string);
            if (dOMImplementation == null) continue;
            return dOMImplementation;
        }
        return null;
    }

    public DOMImplementationList getDOMImplementationList(String string) {
        Vector vector = new Vector();
        int n = this.sources.size();
        for (int i = 0; i < n; ++i) {
            DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)this.sources.elementAt(i);
            DOMImplementationList dOMImplementationList = dOMImplementationSource.getDOMImplementationList(string);
            for (int j = 0; j < dOMImplementationList.getLength(); ++j) {
                DOMImplementation dOMImplementation = dOMImplementationList.item(j);
                vector.addElement(dOMImplementation);
            }
        }
        return new DOMImplementationList(this, vector, string){
            private /* synthetic */ DOMImplementationRegistry this$0;
            private /* synthetic */ Vector val$implementations;
            private /* synthetic */ String val$features;
            {
                this.this$0 = dOMImplementationRegistry;
                this.finit$(vector, string);
            }

            private /* synthetic */ void finit$(Vector vector, String string) {
                this.val$features = string;
                this.val$implementations = vector;
            }

            public DOMImplementation item(int n) {
                if (n >= 0 && n < this.val$implementations.size()) {
                    try {
                        return (DOMImplementation)this.val$implementations.elementAt(n);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return null;
                    }
                }
                return null;
            }

            public int getLength() {
                return this.val$implementations.size();
            }
        };
    }

    public void addSource(DOMImplementationSource dOMImplementationSource) {
        if (dOMImplementationSource == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(dOMImplementationSource)) {
            this.sources.addElement(dOMImplementationSource);
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = DOMImplementationRegistry.getContextClassLoader();
            if (classLoader != null) {
                return classLoader;
            }
        }
        catch (Exception exception) {
            return DOMImplementationRegistry.class$("org.w3c.dom.bootstrap.DOMImplementationRegistry").getClassLoader();
        }
        return DOMImplementationRegistry.class$("org.w3c.dom.bootstrap.DOMImplementationRegistry").getClassLoader();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getServiceValue(ClassLoader classLoader) {
        block5: {
            String string = "META-INF/services/org.w3c.dom.DOMImplementationSourceList";
            try {
                BufferedReader bufferedReader;
                InputStream inputStream = DOMImplementationRegistry.getResourceAsStream(classLoader, string);
                if (inputStream == null) break block5;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
                }
                String string2 = bufferedReader.readLine();
                bufferedReader.close();
                if (string2 != null && string2.length() > 0) {
                    return string2;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static boolean isJRE11() {
        try {
            Class clazz = Class.forName("java.security.AccessController");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static ClassLoader getContextClassLoader() {
        if (DOMImplementationRegistry.isJRE11()) {
            return null;
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(null){
            private /* synthetic */ DOMImplementationRegistry this$0;
            {
                this.this$0 = dOMImplementationRegistry;
            }

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    private static String getSystemProperty(String string) {
        if (DOMImplementationRegistry.isJRE11()) {
            return System.getProperty(string);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(null, string){
            private /* synthetic */ DOMImplementationRegistry this$0;
            private /* synthetic */ String val$name;
            {
                this.this$0 = dOMImplementationRegistry;
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$name = string;
            }

            public Object run() {
                return System.getProperty(this.val$name);
            }
        });
    }

    private static InputStream getResourceAsStream(ClassLoader classLoader, String string) {
        if (DOMImplementationRegistry.isJRE11()) {
            InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
            return inputStream;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(null, classLoader, string){
            private /* synthetic */ DOMImplementationRegistry this$0;
            private /* synthetic */ ClassLoader val$classLoader;
            private /* synthetic */ String val$name;
            {
                this.this$0 = dOMImplementationRegistry;
                this.finit$(classLoader, string);
            }

            private /* synthetic */ void finit$(ClassLoader classLoader, String string) {
                this.val$name = string;
                this.val$classLoader = classLoader;
            }

            public Object run() {
                InputStream inputStream = this.val$classLoader == null ? ClassLoader.getSystemResourceAsStream(this.val$name) : this.val$classLoader.getResourceAsStream(this.val$name);
                return inputStream;
            }
        });
    }
}

