/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingFramePeer;
import gnu.java.awt.peer.swing.SwingMenuPeer;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuBarPeer;
import javax.swing.JMenuBar;

public class SwingMenuBarPeer
implements MenuBarPeer {
    MenuBar awtMenuBar;
    SwingMenuBar menuBar;
    SwingFramePeer framePeer;

    public void setFramePeer(SwingFramePeer swingFramePeer) {
        this.framePeer = swingFramePeer;
    }

    public void addMenu(Menu menu) {
        SwingMenuPeer swingMenuPeer = (SwingMenuPeer)menu.getPeer();
        this.menuBar.add(swingMenuPeer.menu);
    }

    public void addHelpMenu(Menu menu) {
        SwingMenuPeer swingMenuPeer = (SwingMenuPeer)menu.getPeer();
        this.menuBar.add(swingMenuPeer.menu);
    }

    public void delMenu(int n) {
        this.menuBar.remove(n);
    }

    public void dispose() {
        this.menuBar = null;
        this.awtMenuBar = null;
    }

    public void setFont(Font font) {
        this.menuBar.setFont(font);
    }

    public void setWidth(int n) {
        this.menuBar.setSize(n, this.menuBar.getPreferredSize().height);
        this.menuBar.doLayout();
    }

    public void peerPaint(Graphics graphics) {
        this.menuBar.paint(graphics);
    }

    public int getHeight() {
        return this.menuBar.getPreferredSize().height;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = 0;
        while (n < this.awtMenuBar.getMenuCount()) {
            Menu menu = this.awtMenuBar.getMenu(n);
            SwingMenuPeer swingMenuPeer = (SwingMenuPeer)menu.getPeer();
            int n2 = swingMenuPeer.getX();
            int n3 = n2 + swingMenuPeer.getWidth();
            if (point.x >= n2 && point.x <= n3) {
                mouseEvent.translatePoint(swingMenuPeer.getX(), swingMenuPeer.getY());
                swingMenuPeer.handleMouseEvent(mouseEvent);
                break;
            }
            ++n;
        }
    }

    public void handleMouseMotionEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = 0;
        while (n < this.awtMenuBar.getMenuCount()) {
            Menu menu = this.awtMenuBar.getMenu(n);
            SwingMenuPeer swingMenuPeer = (SwingMenuPeer)menu.getPeer();
            int n2 = swingMenuPeer.getX();
            int n3 = n2 + swingMenuPeer.getWidth();
            if (point.x >= n2 && point.x <= n3) {
                mouseEvent.translatePoint(swingMenuPeer.getX(), swingMenuPeer.getY());
                swingMenuPeer.handleMouseMotionEvent(mouseEvent);
                break;
            }
            ++n;
        }
    }

    public SwingMenuBarPeer(MenuBar menuBar) {
        this.awtMenuBar = menuBar;
        this.menuBar = new SwingMenuBar();
        this.menuBar.setDoubleBuffered(false);
        int n = 0;
        while (n < menuBar.getMenuCount()) {
            Menu menu = menuBar.getMenu(n);
            menu.addNotify();
            this.addMenu(menuBar.getMenu(n));
            ++n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SwingMenuBar
    extends JMenuBar {
        public Container getParent() {
            Container container = null;
            if (SwingMenuBarPeer.this.framePeer != null) {
                container = (Container)SwingMenuBarPeer.this.framePeer.awtComponent;
            }
            return container;
        }

        public boolean isShowing() {
            return true;
        }

        public void handleMouseEvent(MouseEvent mouseEvent) {
            mouseEvent.setSource(this);
            this.processMouseEvent(mouseEvent);
        }

        public Point getLocationOnScreen() {
            return SwingMenuBarPeer.this.framePeer.getMenuLocationOnScreen();
        }

        private SwingMenuBar() {
        }
    }
}

