/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.OutgoingMessage;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BaseKeyAgreementParty
implements IKeyAgreementParty {
    protected static final BigInteger TWO = BigInteger.valueOf(2);
    protected String name;
    protected boolean initialised;
    protected int step;
    protected boolean complete;
    protected SecureRandom rnd;
    protected IRandom irnd;
    private PRNG prng;

    public String name() {
        return this.name;
    }

    public void init(Map map) throws KeyAgreementException {
        if (this.initialised) {
            throw new IllegalStateException("already initialised");
        }
        this.engineInit(map);
        this.initialised = true;
        this.step = -1;
        this.complete = false;
    }

    public OutgoingMessage processMessage(IncomingMessage incomingMessage) throws KeyAgreementException {
        if (!this.initialised) {
            throw new IllegalStateException("not initialised");
        }
        if (this.complete) {
            throw new IllegalStateException("exchange has already concluded");
        }
        ++this.step;
        return this.engineProcessMessage(incomingMessage);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] getSharedSecret() throws KeyAgreementException {
        if (!this.initialised) {
            throw new KeyAgreementException("not yet initialised");
        }
        if (!this.isComplete()) {
            throw new KeyAgreementException("not yet computed");
        }
        return this.engineSharedSecret();
    }

    public void reset() {
        if (this.initialised) {
            this.engineReset();
            this.initialised = false;
        }
    }

    protected abstract void engineInit(Map var1) throws KeyAgreementException;

    protected abstract OutgoingMessage engineProcessMessage(IncomingMessage var1) throws KeyAgreementException;

    protected abstract byte[] engineSharedSecret() throws KeyAgreementException;

    protected abstract void engineReset();

    protected void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else if (this.irnd != null) {
            try {
                this.irnd.nextBytes(byArray, 0, byArray.length);
            }
            catch (LimitReachedException limitReachedException) {
                this.irnd = null;
                this.getDefaultPRNG().nextBytes(byArray);
            }
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private final PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }

    private final /* synthetic */ void this() {
        this.initialised = false;
        this.step = -1;
        this.complete = false;
        this.rnd = null;
        this.irnd = null;
        this.prng = null;
    }

    protected BaseKeyAgreementParty(String string) {
        this.this();
        this.name = string;
    }
}

