/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class StyledEditorKit
extends DefaultEditorKit {
    private static final long serialVersionUID = 7002391892985555948L;
    Element currentRun;
    MutableAttributeSet inputAttributes = new SimpleAttributeSet();
    CaretTracker caretTracker;
    StyledViewFactory viewFactory;

    public Object clone() {
        StyledEditorKit styledEditorKit = (StyledEditorKit)super.clone();
        return styledEditorKit;
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        Action[] actionArray2 = new Action[]{new FontSizeAction("font-size-8", 8), new FontSizeAction("font-size-10", 10), new FontSizeAction("font-size-12", 12), new FontSizeAction("font-size-14", 14), new FontSizeAction("font-size-16", 16), new FontSizeAction("font-size-18", 18), new FontSizeAction("font-size-24", 24), new FontSizeAction("font-size-36", 36), new FontSizeAction("font-size-48", 48), new FontFamilyAction("font-family-Serif", "Serif"), new FontFamilyAction("font-family-Monospaced", "Monospaced"), new FontFamilyAction("font-family-SansSerif", "SansSerif"), new AlignmentAction("left-justify", 0), new AlignmentAction("center-justify", 1), new AlignmentAction("right-justify", 2), new BoldAction(), new ItalicAction(), new UnderlineAction()};
        return TextAction.augmentList(actionArray, actionArray2);
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public Element getCharacterAttributeRun() {
        return this.currentRun;
    }

    public Document createDefaultDocument() {
        return new DefaultStyledDocument();
    }

    public void install(JEditorPane jEditorPane) {
        CaretTracker caretTracker = new CaretTracker();
        jEditorPane.addCaretListener(caretTracker);
    }

    public void deinstall(JEditorPane jEditorPane) {
        CaretTracker caretTracker = this.caretTracker;
        if (caretTracker != null) {
            jEditorPane.removeCaretListener(caretTracker);
        }
        this.caretTracker = null;
    }

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new StyledViewFactory();
        }
        return this.viewFactory;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
    }

    public static class FontSizeAction
    extends StyledTextAction {
        private int size;

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontSize(simpleAttributeSet, this.size);
            this.setCharacterAttributes(this.getEditor(actionEvent), simpleAttributeSet, false);
        }

        public FontSizeAction(String string, int n) {
            super(string);
            this.size = n;
        }
    }

    public static class FontFamilyAction
    extends StyledTextAction {
        private String family;

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(simpleAttributeSet, this.family);
            this.setCharacterAttributes(this.getEditor(actionEvent), simpleAttributeSet, false);
        }

        public FontFamilyAction(String string, String string2) {
            super(string);
            this.family = string2;
        }
    }

    public static class AlignmentAction
    extends StyledTextAction {
        private int a;

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, this.a);
            this.setParagraphAttributes(this.getEditor(actionEvent), simpleAttributeSet, false);
        }

        public AlignmentAction(String string, int n) {
            super(string);
            this.a = n;
        }
    }

    public static class BoldAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
            Element element = styledDocument.getCharacterElement(jEditorPane.getSelectionStart());
            boolean bl = StyleConstants.isBold(element.getAttributes());
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setItalic(simpleAttributeSet, bl ^ true);
            this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
        }

        public BoldAction() {
            super("font-bold");
        }
    }

    public static class ItalicAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
            Element element = styledDocument.getCharacterElement(jEditorPane.getSelectionStart());
            boolean bl = StyleConstants.isItalic(element.getAttributes());
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setItalic(simpleAttributeSet, bl ^ true);
            this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
        }

        public ItalicAction() {
            super("font-italic");
        }
    }

    public static class UnderlineAction
    extends StyledTextAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
            Element element = styledDocument.getCharacterElement(jEditorPane.getSelectionStart());
            boolean bl = StyleConstants.isUnderline(element.getAttributes());
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setUnderline(simpleAttributeSet, bl ^ true);
            this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
        }

        public UnderlineAction() {
            super("font-underline");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CaretTracker
    implements CaretListener {
        public void caretUpdate(CaretEvent caretEvent) {
            Object object = caretEvent.getSource();
            if (!(object instanceof JTextComponent)) {
                throw new AssertionError((Object)"CaretEvents are expected to come from aJTextComponent.");
            }
            JTextComponent jTextComponent = (JTextComponent)object;
            Document document = jTextComponent.getDocument();
            if (!(document instanceof StyledDocument)) {
                throw new AssertionError((Object)"The Document used by StyledEditorKits isexpected to be a StyledDocument");
            }
            StyledDocument styledDocument = (StyledDocument)document;
            StyledEditorKit.this.currentRun = styledDocument.getCharacterElement(caretEvent.getDot());
            StyledEditorKit.this.createInputAttributes(StyledEditorKit.this.currentRun, StyledEditorKit.this.inputAttributes);
        }

        CaretTracker() {
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        public View create(Element element) {
            String string = element.getName();
            View view = null;
            if (string.equals("content")) {
                view = new LabelView(element);
            } else if (string.equals("paragraph")) {
                view = new ParagraphView(element);
            } else if (string.equals("section")) {
                view = new BoxView(element, 1);
            } else if (string.equals("component")) {
                view = new ComponentView(element);
            } else if (string.equals("icon")) {
                view = new IconView(element);
            } else {
                throw new AssertionError((Object)("Unknown Element type: " + element.getClass().getName() + " : " + string));
            }
            return view;
        }

        StyledViewFactory() {
        }
    }

    public static abstract class StyledTextAction
    extends TextAction {
        protected final JEditorPane getEditor(ActionEvent actionEvent) {
            return (JEditorPane)this.getTextComponent(actionEvent);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
            Document document = jEditorPane.getDocument();
            if (!(document instanceof StyledDocument)) throw new AssertionError((Object)"The Document for StyledTextActions is expected to be a StyledDocument.");
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof StyledEditorKit) throw new AssertionError((Object)"The EditorKit for StyledTextActions is expected to be a StyledEditorKit");
            StyledEditorKit styledEditorKit = (StyledEditorKit)editorKit;
            int n = jEditorPane.getSelectionStart();
            int n2 = jEditorPane.getSelectionEnd();
            int n3 = jEditorPane.getCaret().getDot();
            if (n == n3 && n2 == n3) {
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                mutableAttributeSet.addAttributes(attributeSet);
                return;
            } else {
                styledDocument.setCharacterAttributes(n, n2, attributeSet, bl);
            }
        }

        protected final StyledDocument getStyledDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (!(document instanceof StyledDocument)) {
                throw new AssertionError((Object)"The Document for StyledEditorKits is expected to be a StyledDocument.");
            }
            return (StyledDocument)document;
        }

        protected final StyledEditorKit getStyledEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (!(editorKit instanceof StyledEditorKit)) {
                throw new AssertionError((Object)"The EditorKit for StyledDocuments is expected to be a StyledEditorKit.");
            }
            return (StyledEditorKit)editorKit;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void setParagraphAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
            Document document = jEditorPane.getDocument();
            if (!(document instanceof StyledDocument)) throw new AssertionError((Object)"The Document for StyledTextActions is expected to be a StyledDocument.");
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof StyledEditorKit) throw new AssertionError((Object)"The EditorKit for StyledTextActions is expected to be a StyledEditorKit");
            StyledEditorKit styledEditorKit = (StyledEditorKit)editorKit;
            int n = jEditorPane.getSelectionStart();
            int n2 = jEditorPane.getSelectionEnd();
            int n3 = jEditorPane.getCaret().getDot();
            if (n == n3 && n2 == n3) {
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                mutableAttributeSet.addAttributes(attributeSet);
                return;
            } else {
                styledDocument.setParagraphAttributes(n, n2, attributeSet, bl);
            }
        }

        public StyledTextAction(String string) {
            super(string);
        }
    }

    public static class ForegroundAction
    extends StyledTextAction {
        private Color fg;

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, this.fg);
            this.setCharacterAttributes(this.getEditor(actionEvent), simpleAttributeSet, false);
        }

        public ForegroundAction(String string, Color color) {
            super(string);
            this.fg = color;
        }
    }
}

