/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import sun.net.httpserver.ExchangeImpl;

public class AuthFilter
extends Filter {
    private Authenticator authenticator;

    public AuthFilter(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public String description() {
        return "Authentication filter";
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void doFilter(HttpExchange httpExchange, Filter.Chain chain) throws IOException {
        if (this.authenticator != null) {
            Authenticator.Result result = this.authenticator.authenticate(httpExchange);
            if (result instanceof Authenticator.Success) {
                Authenticator.Success success = (Authenticator.Success)result;
                ExchangeImpl exchangeImpl = ExchangeImpl.get(httpExchange);
                exchangeImpl.setPrincipal(success.getPrincipal());
                chain.doFilter(httpExchange);
            } else if (result instanceof Authenticator.Retry) {
                Authenticator.Retry retry = (Authenticator.Retry)result;
                httpExchange.sendResponseHeaders(retry.getResponseCode(), -1);
            } else if (result instanceof Authenticator.Failure) {
                Authenticator.Failure failure = (Authenticator.Failure)result;
                httpExchange.sendResponseHeaders(failure.getResponseCode(), -1);
            }
        } else {
            chain.doFilter(httpExchange);
        }
    }
}

