/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DefaultPlatformImpl
extends J2SEPlatformImpl {
    public static final String DEFAULT_PLATFORM_ANT_NAME = "default_platform";
    private ClassPath standardLibs;

    static JavaPlatform create(Map properties, List sources, List javadoc) {
        if (properties == null) {
            properties = new HashMap();
        }
        File javaHome = FileUtil.normalizeFile((File)new File(System.getProperty("jdk.home")));
        ArrayList<URL> installFolders = new ArrayList<URL>();
        try {
            installFolders.add(javaHome.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            ErrorManager.getDefault().notify((Throwable)mue);
        }
        if (sources == null) {
            sources = DefaultPlatformImpl.getSources(javaHome);
        }
        if (javadoc == null) {
            javadoc = DefaultPlatformImpl.getJavadoc(javaHome);
        }
        return new DefaultPlatformImpl(installFolders, properties, new HashMap<Object, Object>(System.getProperties()), sources, javadoc);
    }

    private DefaultPlatformImpl(List installFolders, Map platformProperties, Map systemProperties, List sources, List javadoc) {
        super(null, DEFAULT_PLATFORM_ANT_NAME, installFolders, platformProperties, systemProperties, sources, javadoc);
    }

    public void setAntName(String antName) {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        String displayName = super.getDisplayName();
        if (displayName == null) {
            displayName = NbBundle.getMessage((Class)DefaultPlatformImpl.class, (String)"TXT_DefaultPlatform", (Object)this.getSpecification().getVersion().toString());
            this.internalSetDisplayName(displayName);
        }
        return displayName;
    }

    public void setDisplayName(String name) {
        throw new UnsupportedOperationException();
    }

    public ClassPath getStandardLibraries() {
        if (this.standardLibs != null) {
            return this.standardLibs;
        }
        String s = System.getProperty("java.class.path");
        if (s == null) {
            s = "";
        }
        this.standardLibs = Util.createClassPath(s);
        return this.standardLibs;
    }

    static List getSources(File javaHome) {
        if (javaHome != null) {
            try {
                File f;
                if (Utilities.getOperatingSystem() == 16384) {
                    String srcHome = System.getProperty("netbeans.openvms.j2seplatform.default.srcdir");
                    f = srcHome != null ? new File(srcHome, "src.zip") : new File(javaHome, "src.zip");
                } else {
                    f = new File(javaHome, "src.zip");
                    if (!f.exists()) {
                        f = new File(javaHome, "src.jar");
                    }
                }
                if (f.exists() && f.canRead()) {
                    URL url = FileUtil.getArchiveRoot((URL)f.toURI().toURL());
                    FileObject fo = URLMapper.findFileObject((URL)url);
                    if (fo != null && (fo = fo.getFileObject("src")) != null) {
                        url = fo.getURL();
                    }
                    return Collections.singletonList(url);
                }
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    static List getJavadoc(File javaHome) {
        File f;
        if (javaHome != null && (f = new File(javaHome, "docs")).isDirectory() && f.canRead()) {
            try {
                return Collections.singletonList(f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
        }
        return null;
    }
}

