/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.JmiException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.schema2beans.QName;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.dev.dd.gen.Configuration;
import org.netbeans.modules.websvc.dev.dd.gen.InterfaceType;
import org.netbeans.modules.websvc.dev.dd.gen.ServiceType;
import org.netbeans.modules.websvc.dev.dd.gen.WsdlType;
import org.netbeans.modules.websvc.dev.dd.gen.wscreation.Bean;
import org.netbeans.modules.websvc.dev.wizard.NoWSPortDefinedException;
import org.netbeans.modules.websvc.dev.wizard.WSGenerationUtil;
import org.netbeans.modules.websvc.wsdl.PortInformationHandler;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebServiceGenerator {
    private WSGenerationUtil wsgenUtil = new WSGenerationUtil();
    private static final String WEBSERVICE_TEMPLATE = "/org/netbeans/modules/websvc/dev/wizard/xsl/WSImplBean.xml";
    private static final String WEBSERVICEJAVAEE5_TEMPLATE = "/org/netbeans/modules/websvc/dev/wizard/xsl/WSImplBeanJavaEE5.xml";
    private static final String INTERFACE_TEMPLATE = "/org/netbeans/modules/websvc/dev/wizard/xsl/WSInterface.xml";
    private static final String HANDLER_TEMPLATE = "/org/netbeans/modules/websvc/dev/wizard/xsl/MessageHandler.xml";
    public static final String WSDL_TEMPLATE = "/org/netbeans/modules/websvc/dev/wizard/xsl/WSDL.xml";
    private String implBeanClass = "";
    private String intfClass = "";
    private String targetNS = null;
    private String soapBinding = "";
    private String portTypeName = null;
    public static final String WEBSERVICES_DD = "webservices";
    private WebServicesSupport wsSupport;
    private String wsName;
    private FileObject pkg;
    private Project project;
    private List importedSchemaList;
    private boolean changeWsName;
    private String[] wscompileFeatures;
    public static final String WSCOMPILE_CLASSPATH = "wscompile.classpath";

    public WebServiceGenerator(WebServicesSupport wsSupport, String wsName, FileObject pkg, Project project) {
        this.wsSupport = wsSupport;
        this.wsName = wsName;
        this.pkg = pkg;
        this.project = project;
    }

    public WebServiceGenerator(FileObject pkg, Project project) {
        this.pkg = pkg;
        this.project = project;
    }

    public void generateWebService() throws IOException {
        this.generateWebService(null);
    }

    public FileObject generateWSDL(String template, String wsName, String soapBinding, String portTypeName, FileObject folder, FileObject originalFolder, String wsdlName, StreamSource source) throws IOException {
        return this.wsgenUtil.generateWSDL(template, wsName, soapBinding, portTypeName, folder, originalFolder, wsdlName, source);
    }

    public FileObject generateWSDL(String template, String wsName, String soapBinding, String portTypeName, FileObject folder, String wsdlName, StreamSource source) throws IOException {
        return this.wsgenUtil.generateWSDL(template, wsName, soapBinding, portTypeName, folder, wsdlName, source);
    }

    public String parseWSDL(InputStream wsdlInputStream) throws IOException, NoWSPortDefinedException {
        String changedWsName = null;
        PortInformationHandler handler = new PortInformationHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(wsdlInputStream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            String mes = NbBundle.getMessage(WebServiceGenerator.class, (String)"ERR_WsdlParseFailure");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return changedWsName;
        }
        catch (SAXException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            String mes = NbBundle.getMessage(WebServiceGenerator.class, (String)"ERR_WsdlParseFailure");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return changedWsName;
        }
        List entirePortList = handler.getEntirePortList();
        if (entirePortList.isEmpty()) {
            throw new NoWSPortDefinedException();
        }
        Iterator iterator = entirePortList.iterator();
        String firstPortType = null;
        while (iterator.hasNext()) {
            PortInformationHandler.PortInfo portInfo = (PortInformationHandler.PortInfo)iterator.next();
            if (firstPortType == null) {
                firstPortType = portInfo.getPortType();
            }
            if (portInfo.getBindingType() == null || !portInfo.getBindingType().equals("http://schemas.xmlsoap.org/wsdl/soap")) continue;
            this.portTypeName = portInfo.getPortType();
            this.soapBinding = portInfo.getBinding();
            break;
        }
        if (this.portTypeName == null) {
            this.portTypeName = firstPortType;
        }
        if (this.portTypeName == null) {
            throw new NoWSPortDefinedException();
        }
        this.intfClass = WSGenerationUtil.getSelectedPackageName(this.pkg, this.project) + "." + this.normalizePortTypeName(this.portTypeName);
        this.implBeanClass = this.intfClass + "_Impl";
        this.targetNS = handler.getTargetNamespace();
        this.importedSchemaList = handler.getImportedSchemas();
        if (this.changeWsName) {
            changedWsName = this.wsName + "_Service";
        }
        Set features = handler.getWscompileFeatures();
        this.wscompileFeatures = new String[features.size()];
        features.toArray(this.wscompileFeatures);
        return changedWsName;
    }

    private String normalizePortTypeName(String portTypeName) {
        if (portTypeName == null) {
            return "unknown";
        }
        String first = portTypeName.substring(0, 1);
        String result = first.toUpperCase() + (portTypeName.length() > 1 ? portTypeName.substring(1) : "");
        if (result.equals(this.wsName)) {
            this.changeWsName = true;
        }
        return result;
    }

    public void generateMessageHandler(String handlerName) throws IOException {
        String pkgName = WSGenerationUtil.getSelectedPackageName(this.pkg, this.project);
        Bean b = this.wsgenUtil.getDefaultBean();
        b.setCommentDataWsName(handlerName);
        b.setClassname(true);
        b.setClassnameName(handlerName);
        if (pkgName != null) {
            b.setClassnamePackage(pkgName);
        }
        String handlerClass = this.wsgenUtil.getFullClassName(pkgName, this.wsgenUtil.generateClass(HANDLER_TEMPLATE, b, this.pkg, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateWebService(Node[] nodes) throws IOException {
        String pkgName = WSGenerationUtil.getSelectedPackageName(this.pkg, this.project);
        Bean b = this.wsgenUtil.getDefaultBean();
        b.setCommentDataWsName(this.wsName);
        b.setClassname(true);
        b.setDelegateData("");
        b.setClassnameName(this.wsgenUtil.getBeanClassName(this.wsName));
        if (pkgName != null) {
            b.setClassnamePackage(pkgName);
        }
        if (this.project.getLookup().lookup(WebModuleImplementation.class) != null) {
            this.implBeanClass = this.wsgenUtil.getFullClassName(pkgName, this.wsgenUtil.generateClass(WEBSERVICE_TEMPLATE, b, this.pkg, true));
            b.setClassnameName(this.wsgenUtil.getSEIName(this.wsName));
            this.intfClass = this.wsgenUtil.getFullClassName(pkgName, this.wsgenUtil.generateClass(INTERFACE_TEMPLATE, b, this.pkg, false));
            if (this.implBeanClass != null) {
                boolean rollback = true;
                JMIUtils.beginJmiTransaction((boolean)true);
                try {
                    JavaClass jc = JMIUtils.findClass((String)this.implBeanClass, (FileObject)this.pkg);
                    if (jc != null && jc.isValid()) {
                        this.addDelegateMethod(nodes, jc);
                    }
                    rollback = false;
                }
                catch (Exception ex) {
                }
                finally {
                    JMIUtils.endJmiTransaction((boolean)rollback);
                }
            }
        } else {
            try {
                this.implBeanClass = this.wsSupport.generateImplementationBean(this.wsName, this.pkg, this.project, null);
                b.setClassnameName(this.wsgenUtil.getSEIName(this.wsName));
                this.intfClass = this.wsgenUtil.getFullClassName(pkgName, this.wsgenUtil.generateClass(INTERFACE_TEMPLATE, b, this.pkg, false));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (this.implBeanClass != null) {
                boolean rollback = true;
                JMIUtils.beginJmiTransaction((boolean)true);
                try {
                    JavaClass jc = JMIUtils.findClass((String)this.implBeanClass, (FileObject)this.pkg);
                    if (jc != null) {
                        this.addDelegateMethod(nodes, jc);
                    }
                    rollback = false;
                }
                catch (Exception ex) {
                }
                finally {
                    JMIUtils.endJmiTransaction((boolean)rollback);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateWebServiceJavaEE5(Node[] nodes) throws IOException {
        String pkgName = WSGenerationUtil.getSelectedPackageName(this.pkg, this.project);
        Bean b = this.wsgenUtil.getDefaultBean();
        b.setCommentDataWsName(this.wsName);
        b.setClassname(true);
        b.setDelegateData("");
        b.setClassnameName(this.wsgenUtil.getBeanClassName(this.wsName));
        if (pkgName != null) {
            b.setClassnamePackage(pkgName);
        }
        if (this.project.getLookup().lookup(WebModuleImplementation.class) != null) {
            this.implBeanClass = this.wsgenUtil.getFullClassName(pkgName, this.wsgenUtil.generateClass(WEBSERVICEJAVAEE5_TEMPLATE, b, this.pkg, true));
            b.setClassnameName(this.wsgenUtil.getSEIName(this.wsName));
            if (this.implBeanClass != null) {
                boolean rollback = true;
                JMIUtils.beginJmiTransaction((boolean)true);
                try {
                    JavaClass jc = JMIUtils.findClass((String)this.implBeanClass, (FileObject)this.pkg);
                    Annotation wsAnnotation = JMIGenerationUtil.createAnnotation((Element)jc, (String)"javax.jws.WebService", (List)Collections.EMPTY_LIST);
                    jc.getAnnotations().add(wsAnnotation);
                    if (jc != null && jc.isValid()) {
                        this.addDelegateMethod(nodes, jc);
                    }
                    rollback = false;
                }
                catch (Exception ex) {
                }
                finally {
                    JMIUtils.endJmiTransaction((boolean)rollback);
                }
            }
        } else {
            try {
                this.implBeanClass = this.wsSupport.generateImplementationBean(this.wsName, this.pkg, this.project, null);
                b.setClassnameName(this.wsgenUtil.getSEIName(this.wsName));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (this.implBeanClass != null) {
                boolean rollback = true;
                JMIUtils.beginJmiTransaction((boolean)true);
                try {
                    JavaClass jc = JMIUtils.findClass((String)this.implBeanClass, (FileObject)this.pkg);
                    Annotation statelessAnnotation = JMIGenerationUtil.createAnnotation((Element)jc, (String)"javax.ejb.Stateless", (List)Collections.EMPTY_LIST);
                    jc.getAnnotations().add(statelessAnnotation);
                    Annotation wsAnnotation = JMIGenerationUtil.createAnnotation((Element)jc, (String)"javax.jws.WebService", (List)Collections.EMPTY_LIST);
                    jc.getAnnotations().add(wsAnnotation);
                    if (jc != null) {
                        this.addDelegateMethod(nodes, jc);
                    }
                    rollback = false;
                }
                catch (Exception ex) {
                }
                finally {
                    JMIUtils.endJmiTransaction((boolean)rollback);
                }
            }
        }
    }

    public void addReferences(String beanClassName, Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            EjbReference ref = (EjbReference)node.getCookie(EjbReference.class);
            if (ref != null) {
                EjbLocalRef ejbLocalRef;
                EjbRef ejbRef;
                EnterpriseReferenceContainer erc = (EnterpriseReferenceContainer)this.project.getLookup().lookup(EnterpriseReferenceContainer.class);
                if (ref.supportsRemoteInvocation() && (ejbRef = ref.createRef()).getEjbRefType().equals("Session")) {
                    try {
                        erc.addEjbReferernce(ejbRef, beanClassName, ref.getClientJarTarget());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
                if (ref.supportsRemoteInvocation() || !ref.supportsLocalInvocation() || !(ejbLocalRef = ref.createLocalRef()).getEjbRefType().equals("Session")) continue;
                try {
                    erc.addEjbLocalReference(ejbLocalRef, beanClassName, ref.getClientJarTarget());
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            JavaClass classElement = JMIUtils.getJavaClassFromNode((Node)node);
            assert (classElement != null);
            FileObject srcFile = JavaMetamodel.getManager().getDataObject(classElement.getResource()).getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)srcFile);
            if (p == null || this.project.equals(p)) continue;
            AntArtifact target = AntArtifactQuery.findArtifactsByType((Project)p, (String)this.getAntArtifactType(p))[0];
            ReferenceHelper helper = this.wsSupport.getReferenceHelper();
            if (helper.addReference(target)) {
                AntProjectHelper antHelper = this.wsSupport.getAntProjectHelper();
                EditableProperties ep = antHelper.getProperties("nbproject/project.properties");
                String s = ep.getProperty("javac.classpath");
                s = s + File.pathSeparatorChar + helper.createForeignFileReference(target);
                ep.setProperty("javac.classpath", s);
                antHelper.putProperties("nbproject/project.properties", ep);
            }
            try {
                ProjectManager.getDefault().saveProject(this.project);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void addDelegateMethod(Node[] nodes, JavaClass jc) {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            EjbReference ref = (EjbReference)node.getCookie(EjbReference.class);
            if (ref != null) {
                EjbLocalRef ejbLocalRef;
                Method method;
                Feature f;
                EjbRef ejbRef;
                if (ref.supportsRemoteInvocation() && (ejbRef = ref.createRef()).getEjbRefType().equals("Session")) {
                    try {
                        f = ref.generateReferenceCode(jc, ejbRef, false);
                        if (f instanceof Method) {
                            method = (Method)f;
                            if (method.getType().getName().equals(ejbRef.getHome())) {
                                this.addMethodJavaDocForHome(method, ejbRef.getHome(), ejbRef.getRemote());
                            }
                            method.setJavadocText(NbBundle.getMessage(WebServiceGenerator.class, (String)"MSG_JAVADOC_LOOKUP_REMOTE"));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
                if (ref.supportsRemoteInvocation() || !ref.supportsLocalInvocation() || !(ejbLocalRef = ref.createLocalRef()).getEjbRefType().equals("Session")) continue;
                try {
                    f = ref.generateReferenceCode(jc, ejbLocalRef, false);
                    if (!(f instanceof Method)) continue;
                    method = (Method)f;
                    if (method.getType().getName().equals(ejbLocalRef.getLocalHome())) {
                        this.addMethodJavaDocForHome(method, ejbLocalRef.getLocalHome(), ejbLocalRef.getLocal());
                    }
                    method.setJavadocText(NbBundle.getMessage(WebServiceGenerator.class, (String)"MSG_JAVADOC_LOOKUP_LOCAL"));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            JavaClass classElement = JMIUtils.getJavaClassFromNode((Node)node);
            assert (classElement != null);
            JavaModelPackage jmp = (JavaModelPackage)classElement.refImmediatePackage();
            Field field = jmp.getField().createField();
            field.setName(classElement.getName());
            String name = WebServiceGenerator.varFromName(classElement.getName());
        }
    }

    private Method createClone(JavaClass jc, Method method, String javadoc) {
        Method clonnedMethod = JMIUtils.createMethod((JavaClass)jc);
        clonnedMethod.setBodyText(method.getBodyText());
        clonnedMethod.setModifiers(method.getModifiers());
        clonnedMethod.setName(method.getName());
        clonnedMethod.setType(method.getType());
        clonnedMethod.setJavadocText(javadoc);
        return clonnedMethod;
    }

    private static String varFromName(String name) {
        if (name.length() > 0) {
            StringBuffer buf = new StringBuffer(name);
            if (Character.isUpperCase(buf.charAt(0))) {
                buf.setCharAt(0, Character.toLowerCase(buf.charAt(0)));
            } else {
                buf.insert(0, '_');
            }
            return buf.toString();
        }
        return "unknown";
    }

    private String getAntArtifactType(Project project) {
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        AntArtifact[] artifacts = antArtifactProvider.getBuildArtifacts();
        return artifacts[0].getType();
    }

    private void addMethodJavaDocForHome(Method method, String ejbHome, String ejbLocalOrRemote) throws JmiException {
        StringBuffer text = new StringBuffer("Use this method to instantiate the EJB: \n");
        String ejbHomeVar = WebServiceGenerator.varFromName(ejbHome.substring(ejbHome.lastIndexOf(46) + 1));
        text.append(ejbHome + " " + ejbHomeVar + "  = " + method.getName() + "(); \n");
        String ejbLocalOrRemoteVar = WebServiceGenerator.varFromName(ejbLocalOrRemote.substring(ejbLocalOrRemote.lastIndexOf(46) + 1));
        text.append(ejbLocalOrRemote + " " + ejbLocalOrRemoteVar + " = " + ejbHomeVar + ".create(<args>);");
        method.setJavadocText(text.toString());
    }

    public String getServantClassName() {
        return this.implBeanClass;
    }

    public String getSEIClassName() {
        return this.intfClass;
    }

    public String getSEIBaseName() {
        return this.wsgenUtil.getBaseName(this.intfClass);
    }

    public String getSoapBinding() {
        return this.soapBinding;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public List getImportedSchemas() {
        return this.importedSchemaList;
    }

    public String[] getWscompileFeatures() {
        return this.wscompileFeatures;
    }

    public void addWebServiceEntry(String seiClassName, String portTypeName, URI targetNS) throws IOException {
        DDProvider wsDDProvider;
        Webservices webServices;
        if (this.wsSupport.getWebservicesDD() == null) {
            try {
                final FileObject wsxmlTemplate = Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-websvc-dev/webservices.xml");
                final FileObject wsddFolder = this.wsSupport.getWsDDFolder();
                FileSystem fs = wsddFolder.getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileUtil.copyFile((FileObject)wsxmlTemplate, (FileObject)wsddFolder, (String)WebServiceGenerator.WEBSERVICES_DD);
                    }
                });
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
        }
        if ((webServices = (wsDDProvider = DDProvider.getDefault()).getDDRoot(this.wsSupport.getWebservicesDD())) != null) {
            try {
                WebserviceDescription wsDescription = (WebserviceDescription)webServices.createBean("WebserviceDescription");
                wsDescription.setWebserviceDescriptionName(this.wsName);
                ServiceImplBean serviceImplBean = (ServiceImplBean)webServices.createBean("ServiceImplBean");
                PortComponent portComponent = (PortComponent)webServices.createBean("PortComponent");
                portComponent.setPortComponentName(this.wsName);
                QName wsdlPortQName = new QName(targetNS.toString(), portTypeName == null ? this.wsgenUtil.getBaseName(seiClassName) + "Port" : portTypeName + "Port", "wsdl-port_ns");
                portComponent.setWsdlPort(wsdlPortQName);
                portComponent.setServiceEndpointInterface(seiClassName);
                this.wsSupport.addServiceImplLinkEntry(serviceImplBean, this.wsName);
                String wsDDFolder = this.wsSupport.getArchiveDDFolderName();
                wsDescription.setWsdlFile(wsDDFolder + "/wsdl/" + this.wsName + ".wsdl");
                wsDescription.setJaxrpcMappingFile(wsDDFolder + "/" + this.wsName + "-mapping.xml");
                portComponent.setServiceImplBean(serviceImplBean);
                wsDescription.addPortComponent(portComponent);
                webServices.addWebserviceDescription(wsDescription);
                webServices.write(this.wsSupport.getWebservicesDD());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public URI getTargetNS() throws URISyntaxException {
        if (this.targetNS != null) {
            return new URI(this.targetNS);
        }
        return this.getDefaultTargetNS(this.wsName);
    }

    public URI getDefaultTargetNS(String wsName) throws URISyntaxException {
        return new URI("urn:" + wsName + "/wsdl");
    }

    public URI getDefaultTypeNS(String wsName) throws URISyntaxException {
        return new URI("urn:" + wsName + "/types");
    }

    public FileObject generateConfigFile(URI wsdlLocation) throws IOException {
        FileObject configFile = this.pkg.createData(this.wsName + "-config", "xml");
        Configuration configuration = new Configuration();
        WsdlType wsdl = configuration.newWsdlType();
        wsdl.setLocation(wsdlLocation);
        wsdl.setPackageName(WSGenerationUtil.getSelectedPackageName(this.pkg, this.project));
        configuration.setWsdl(wsdl);
        FileLock lock = null;
        OutputStream out = null;
        try {
            lock = configFile.lock();
            out = configFile.getOutputStream(lock);
            configuration.write(out, "UTF-8");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
            if (out != null) {
                out.close();
            }
        }
        return configFile;
    }

    public FileObject generateConfigFile(String seiClassName, String servantClassName, URI targetNS, URI typeNS) throws IOException {
        FileObject configFile = this.pkg.createData(this.wsName + "-config", "xml");
        Configuration configuration = new Configuration();
        ServiceType service = new ServiceType();
        service.setName(this.wsName);
        service.setTargetNamespace(targetNS);
        service.setTypeNamespace(typeNS);
        service.setPackageName(WSGenerationUtil.getSelectedPackageName(this.pkg, this.project));
        InterfaceType interf = new InterfaceType();
        interf.setName(seiClassName);
        interf.setServantName(servantClassName);
        service.setInterface(new InterfaceType[]{interf});
        configuration.setService(service);
        FileLock lock = null;
        OutputStream out = null;
        try {
            lock = configFile.lock();
            out = configFile.getOutputStream(lock);
            configuration.write(out, "UTF-8");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
            if (out != null) {
                out.close();
            }
        }
        return configFile;
    }
}

