/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

class FindDialogPanel
extends JPanel
implements Runnable {
    static final long serialVersionUID = 5048678953767663114L;
    private static Reference panel = null;
    private JButton acceptButton;
    private static Vector history = new Vector();
    private JComboBox findWhat;
    private JLabel findWhatLabel;
    private static Reference dialogRef = null;

    FindDialogPanel() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)FindDialogPanel.class).getString("ACSN_Find"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FindDialogPanel.class).getString("ACSD_Find"));
        this.findWhat.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FindDialogPanel.class).getString("ACSD_Find_What"));
        this.findWhat.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    FindDialogPanel.this.findWhat.setPopupVisible(false);
                    ((Dialog)dialogRef.get()).setVisible(false);
                }
            }
        });
        this.findWhat.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(FindDialogPanel.this);
            }
        });
        this.acceptButton = new JButton(NbBundle.getBundle((Class)FindDialogPanel.class).getString("BTN_Find"));
        this.acceptButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FindDialogPanel.class).getString("ACSD_FindBTN"));
        this.findWhat.setModel(new DefaultComboBoxModel(history));
        this.findWhatLabel.setFocusable(false);
        JComponent[] order = new JComponent[]{this.findWhat, this.acceptButton};
    }

    public void run() {
        this.acceptButton.doClick();
    }

    public static FindDialogPanel getPanel() {
        FindDialogPanel result = null;
        if (panel != null) {
            result = (FindDialogPanel)panel.get();
        }
        if (result == null) {
            result = new FindDialogPanel();
            panel = new SoftReference<FindDialogPanel>(result);
        }
        return result;
    }

    void setFindText(String text) {
        Component comp;
        int end = text.indexOf("\n");
        String txt = text;
        if (end > -1) {
            txt = text.substring(0, end);
        }
        if (!txt.equals(this.findWhat.getSelectedItem())) {
            this.findWhat.insertItemAt(txt, 0);
            this.findWhat.setSelectedIndex(0);
        }
        if ((comp = this.findWhat.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)comp).setSelectionStart(0);
            ((JTextField)comp).setSelectionEnd(txt.length());
        }
    }

    private void initComponents() {
        this.findWhatLabel = new JLabel();
        this.findWhat = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.findWhatLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)FindDialogPanel.class).getString("LBL_Find_What_Mnemonic").charAt(0));
        this.findWhatLabel.setLabelFor(this.findWhat);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 5, 5);
        this.add((Component)this.findWhatLabel, gridBagConstraints);
        this.findWhat.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 12);
        this.add((Component)this.findWhat, gridBagConstraints);
    }

    static void showFindDialog(ActionListener al, String selection) {
        Dialog dialog = FindDialogPanel.getDialog();
        FindDialogPanel findPanel = FindDialogPanel.getPanel();
        findPanel.acceptButton.putClientProperty("panel", findPanel);
        if (selection != null) {
            findPanel.setFindText(selection);
        }
        if (!Arrays.asList(findPanel.acceptButton.getActionListeners()).contains(al)) {
            findPanel.acceptButton.addActionListener(al);
        }
        dialog.setVisible(true);
        dialog.addWindowListener(new DlgWindowListener(al, findPanel.acceptButton));
    }

    String getPattern() {
        FindDialogPanel findPanel = (FindDialogPanel)panel.get();
        return findPanel != null ? (String)findPanel.findWhat.getSelectedItem() : null;
    }

    private void updateHistory() {
        Object pattern = this.findWhat.getEditor().getItem();
        history.add(0, pattern);
        for (int i = history.size() - 1; i > 0; --i) {
            if (!history.get(i).equals(pattern)) continue;
            history.remove(i);
            break;
        }
    }

    private static Dialog createDialog() {
        final FindDialogPanel findPanel = FindDialogPanel.getPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)findPanel, NbBundle.getBundle((Class)FindDialogPanel.class).getString("LBL_Find_Title"), true, new Object[]{findPanel.acceptButton, DialogDescriptor.CANCEL_OPTION}, (Object)findPanel.acceptButton, 1, null, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == findPanel.acceptButton) {
                    FindDialogPanel.getPanel().updateHistory();
                } else {
                    FindDialogPanel.getDialog().setVisible(false);
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)FindDialogPanel.class, (String)"ACSN_Find"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FindDialogPanel.class, (String)"ACSD_Find"));
        return dialog;
    }

    private static Dialog getDialog() {
        Dialog result = null;
        if (dialogRef != null) {
            result = (Dialog)dialogRef.get();
        }
        if (result == null) {
            result = FindDialogPanel.createDialog();
            dialogRef = new WeakReference<Dialog>(result);
        }
        return result;
    }

    private static class DlgWindowListener
    extends WindowAdapter {
        private ActionListener al;
        private JButton acceptButton;

        DlgWindowListener(ActionListener al, JButton acceptButton) {
            this.al = al;
            this.acceptButton = acceptButton;
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.acceptButton.removeActionListener(this.al);
            ((Dialog)windowEvent.getSource()).removeWindowListener(this);
            ((Dialog)windowEvent.getSource()).dispose();
        }
    }
}

