/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.util.Arrays;

final class SparseIntList {
    private int[] keys;
    private int[] values;
    private int used = 0;
    private int lastAdded = Integer.MIN_VALUE;
    private int lastIndex = Integer.MIN_VALUE;
    private int lastGet = -1;
    private int lastResult;

    SparseIntList(int capacity) {
        this.allocArrays(capacity);
    }

    public synchronized void add(int value, int idx) {
        if (value <= this.lastAdded) {
            throw new IllegalArgumentException("Contents must be presorted - added value " + value + " is less than preceding " + "value " + this.lastAdded);
        }
        if (idx <= this.lastIndex) {
            throw new IllegalArgumentException("Contents must be presorted - added index " + idx + " is less than preceding " + "index " + this.lastIndex);
        }
        if (this.used >= this.keys.length) {
            this.growArrays();
        }
        this.values[this.used] = value;
        this.keys[this.used++] = idx;
        this.lastAdded = value;
        this.lastIndex = idx;
    }

    int lastAdded() {
        return this.lastAdded;
    }

    int lastIndex() {
        return this.lastIndex;
    }

    private void allocArrays(int size) {
        this.keys = new int[size];
        this.values = new int[size];
        Arrays.fill(this.keys, Integer.MAX_VALUE);
        Arrays.fill(this.values, -1);
    }

    public synchronized int get(int index) {
        int result;
        if (index < 0) {
            return 0;
        }
        if (this.used == 0 || this.used > 0 && index < this.keys[0]) {
            return index;
        }
        if (index == this.lastGet) {
            return this.lastResult;
        }
        this.lastGet = index;
        int idx = Arrays.binarySearch(this.keys, index);
        if (idx < 0) {
            int nearest = this.findInRange(index, 0, this.used);
            if (this.keys[nearest] > index) {
                --nearest;
            }
            result = nearest == -1 ? index : this.values[nearest] + (index - this.keys[nearest]);
        } else {
            result = idx == 0 ? index : this.values[idx - 1] + (index - this.keys[idx - 1]);
        }
        this.lastResult = result;
        return result;
    }

    private int findInRange(int val, int start, int end) {
        if (end - start <= 1) {
            return start;
        }
        int midPoint = start + (end - start >> 1);
        int idxAtMidpoint = this.keys[midPoint];
        if (idxAtMidpoint > val) {
            return this.findInRange(val, start, start + (end - start >> 1));
        }
        return this.findInRange(val, start + (end - start >> 1), end);
    }

    private void growArrays() {
        int[] oldkeys = this.keys;
        int[] oldvals = this.values;
        this.allocArrays(Math.round((float)this.keys.length * 1.5f));
        System.arraycopy(oldkeys, 0, this.keys, 0, oldkeys.length);
        System.arraycopy(oldvals, 0, this.values, 0, oldvals.length);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("SparseIntList [");
        result.append("used=");
        result.append(this.used);
        result.append(" capacity=");
        result.append(this.keys.length);
        result.append(" keyValuePairs:");
        for (int i = 0; i < this.used; ++i) {
            result.append(this.keys[i]);
            result.append(':');
            result.append(this.values[i]);
            if (i == this.used - 1) continue;
            result.append(',');
        }
        result.append(']');
        return result.toString();
    }
}

