/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TagValue;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeArgument;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.WildCard;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.HTMLJavadocParser;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbCompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJMIScrollJavaDocPane;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class NbJMICompletionJavaDoc
extends NbCompletionJavaDoc {
    private boolean goToSourceEnabled = false;
    private String lastBase = "";
    private JavaDocPane pane;
    private JMIUtils jmiUtils;
    private NbJavaJMISyntaxSupport jmiSup;
    private Comparator contentComparator;
    private Map membersCache = new HashMap();
    private static String ARRAY_LENGTH_FIELD_JAVADOC = NbBundle.getBundle((Class)NbJMICompletionJavaDoc.class).getString("array_length_field_javadoc");
    private static String CLASS_CONSTANT_JAVADOC = NbBundle.getBundle((Class)NbJMICompletionJavaDoc.class).getString("class_constant_javadoc");

    NbJMICompletionJavaDoc(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    private JMIUtils getJMIUtils() {
        if (this.jmiUtils == null) {
            this.jmiUtils = JMIUtils.get(this.extEditorUI.getDocument());
        }
        return this.jmiUtils;
    }

    protected NbJavaJMISyntaxSupport getJMISyntaxSupport() {
        if (this.jmiSup == null) {
            SyntaxSupport sup = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
            this.jmiSup = (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class);
        }
        return this.jmiSup;
    }

    protected Object getCurrentContent() {
        return this.convert(super.getCurrentContent());
    }

    protected Comparator getContentComparator() {
        if (this.contentComparator == null) {
            this.contentComparator = new ContentComparator();
        }
        return this.contentComparator;
    }

    protected String findProperClass(String name, String pkgName) {
        JavaClass jc = this.getJMIUtils().getExactClass(name, pkgName);
        return jc != null ? jc.getName() : null;
    }

    protected NbCompletionJavaDoc.ParsingThread setInRequestProcessorThread(Object content) {
        JMIParsingThread pt = new JMIParsingThread(content);
        RequestProcessor.getDefault().post((Runnable)pt);
        return pt;
    }

    public boolean isExternalJavaDocMounted() {
        URL[] urls;
        Object currentContent = this.getCurrentContent();
        if (currentContent instanceof URL || currentContent instanceof String) {
            try {
                if (this.lastBase == null || this.lastBase.length() == 0) {
                    return false;
                }
                FileObject fo = URLMapper.findFileObject((URL)new URL(this.lastBase));
                if (fo != null) {
                    return true;
                }
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                return false;
            }
        }
        return (urls = this.getJMISyntaxSupport().getJavaDocURLs(currentContent)) != null && urls.length >= 1;
    }

    public void goToSource() {
        Object currentContent = this.getCurrentContent();
        if (this.getJMISyntaxSupport().openSource(currentContent, true) == null) {
            this.extEditorUI.getCompletion().setPaneVisible(false);
        }
    }

    public JavaDocPane getJavaDocPane() {
        JavaDocPane jdp;
        Completion completion = this.extEditorUI.getCompletion();
        if (completion != null && (jdp = completion.getJDCPopupPanel().getJavaDocPane()) instanceof NbJMIScrollJavaDocPane) {
            return jdp;
        }
        if (this.pane == null) {
            this.pane = new NbJMIScrollJavaDocPane(this.extEditorUI);
        }
        return this.pane;
    }

    private CompletionJavaDoc.JavaDocTagItem[] getJavaDocTags(List jdt) {
        CompletionJavaDoc.JavaDocTagItem[] ret = new CompletionJavaDoc.JavaDocTagItem[jdt.size()];
        int i = 0;
        Iterator it = jdt.iterator();
        while (it.hasNext()) {
            TagValue tv = (TagValue)it.next();
            ret[i] = new NbCompletionJavaDoc.JavaDocTagItemImpl(tv.getDefinition().getName(), tv.getValue());
            ++i;
        }
        return ret;
    }

    protected boolean isGoToSourceEnabled() {
        return this.goToSourceEnabled;
    }

    public void openInExternalBrowser() {
        URL url;
        Object currentContent = this.getCurrentContent();
        if (currentContent instanceof URL) {
            HtmlBrowser.URLDisplayer.getDefault().showURL((URL)currentContent);
        } else if (currentContent instanceof String && (url = this.mergeRelLink(this.lastBase, (String)currentContent)) != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        URL[] urls = this.getJMISyntaxSupport().getJavaDocURLs(currentContent);
        if (urls != null && urls.length > 0) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(urls[0]);
        }
    }

    private List parseMethodTypes(String parameters, ClassDefinition cls) {
        ArrayList<JavaClass> ret = new ArrayList<JavaClass>();
        if (parameters == null) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(parameters, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            param = (param = param.trim()).indexOf(" ") > 0 ? param.substring(0, param.indexOf(" ")) : param;
            int arrDepth = 0;
            JavaClass typ = null;
            if (param.indexOf("[") > 0) {
                int idx = param.indexOf("[");
                param = param.substring(0, idx);
                while (idx >= 0) {
                    ++arrDepth;
                    idx = param.indexOf("[", idx);
                }
            }
            if (param.indexOf(".") < 0) {
                typ = this.getJMISyntaxSupport().getTypeFromName(param, true, cls instanceof JavaClass ? (JavaClass)cls : null, true);
            } else {
                typ = this.getJMIUtils().getExactClass(param);
                if (typ == null) {
                    typ = this.getJMIUtils().getExactClass(param, this.getJMIUtils().getPackageName(cls));
                }
            }
            if (typ != null) {
                while (arrDepth > 0) {
                    typ = this.getJMIUtils().resolveArray((Type)typ);
                    --arrDepth;
                }
            }
            if (typ == null) {
                return null;
            }
            ret.add(typ);
        }
        return ret;
    }

    public Object parseLink(String link, String clsFQN, String pkgName) {
        return this.parseLink(link, (ClassDefinition)this.getJMIUtils().getExactClass(clsFQN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseLink(String link, ClassDefinition cls) {
        link = link.trim();
        ClassDefinition linkClass = null;
        this.getJMIUtils().beginTrans(false);
        try {
            ClassDefinition classDefinition;
            String refCls;
            if (cls != null && !cls.isValid()) {
                cls = null;
            }
            if (link.indexOf("#") > -1) {
                String memberName;
                if (link.startsWith("#")) {
                    if (cls == null) {
                        Object var4_4 = null;
                        return var4_4;
                    }
                    linkClass = cls;
                } else {
                    Type typ;
                    String refCls2 = link.substring(0, link.indexOf("#"));
                    if (refCls2.indexOf(".") < 0) {
                        typ = this.getJMISyntaxSupport().getTypeFromName(refCls2, true, cls instanceof JavaClass ? (JavaClass)cls : null, true);
                        if (typ instanceof ClassDefinition) {
                            linkClass = (ClassDefinition)typ;
                        }
                    } else {
                        if (refCls2.endsWith(".html")) {
                            refCls2 = NbJMICompletionJavaDoc.urlToFqn(refCls2);
                        }
                        if ((linkClass = this.getJMIUtils().getExactClass(refCls2)) == null) {
                            linkClass = this.getJMIUtils().getExactClass(refCls2, this.getJMIUtils().getPackageName(cls));
                        }
                    }
                    if (linkClass == null) {
                        typ = null;
                        return typ;
                    }
                }
                linkClass = JMIUtils.getSourceElementIfExists(linkClass);
                String memberLink = link.substring(link.indexOf("#") + 1);
                if (link.indexOf("(") > 0) {
                    List params;
                    memberName = memberLink.substring(0, memberLink.indexOf("("));
                    String memberParams = null;
                    if (link.indexOf(")") > 0) {
                        memberParams = link.substring(link.indexOf("(") + 1, link.indexOf(")"));
                    }
                    if ((params = this.parseMethodTypes(memberParams, cls)) == null) {
                        Object var8_12 = null;
                        return var8_12;
                    }
                    if (memberName.equals(linkClass instanceof JavaClass ? ((JavaClass)linkClass).getSimpleName() : linkClass.getName())) {
                        Constructor constructor = linkClass.getConstructor(params, true);
                        return constructor;
                    }
                    Method method = linkClass.getMethod(memberName, params, true);
                    return method;
                }
                memberName = memberLink.indexOf(" ") > 0 ? memberLink.substring(0, memberLink.indexOf(" ")) : memberLink;
                Object object = this.findMember(linkClass, memberName, cls);
                return object;
            }
            String string = refCls = link.indexOf(" ") > 0 ? link.substring(0, link.indexOf(" ")) : link;
            if (refCls.indexOf(".") < 0) {
                Type typ = this.getJMISyntaxSupport().getTypeFromName(refCls, true, cls instanceof JavaClass ? (JavaClass)cls : null, true);
                if (typ instanceof ClassDefinition) {
                    linkClass = (ClassDefinition)typ;
                }
            } else {
                if (refCls.endsWith(".html")) {
                    refCls = NbJMICompletionJavaDoc.urlToFqn(refCls);
                }
                if ((linkClass = this.getJMIUtils().getExactClass(refCls)) == null) {
                    linkClass = this.getJMIUtils().getExactClass(refCls, this.getJMIUtils().getPackageName(cls));
                }
            }
            if (linkClass != null) {
                classDefinition = JMIUtils.getSourceElementIfExists(linkClass);
                return classDefinition;
            }
            classDefinition = this.getJMIUtils().getExactPackage(refCls);
            return classDefinition;
        }
        finally {
            this.getJMIUtils().endTrans(false);
        }
    }

    private static String urlToFqn(String url) {
        url = url.replaceAll("(\\.\\./)*", "");
        url = url.substring(0, url.indexOf(".html"));
        url = url.replace('/', '.');
        return url;
    }

    private Object findMember(ClassDefinition linkClass, String memberName, ClassDefinition cls) {
        if (!this.membersCache.containsKey(linkClass)) {
            Iterator it = this.getJMIUtils().findFeatures((Type)linkClass, memberName, true, false, cls instanceof JavaClass ? (JavaClass)cls : null, false, false, null, false, false, false, false).iterator();
            return it.hasNext() ? it.next() : null;
        }
        List ret = (List)this.membersCache.get(linkClass);
        if (ret == null) {
            ret = this.getJMIUtils().findFeatures((Type)linkClass, "", false, false, cls instanceof JavaClass ? (JavaClass)cls : null, false, false, null, false, false, false, false);
            this.membersCache.put(linkClass, ret);
        }
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (!memberName.equals(f instanceof JavaClass ? ((JavaClass)f).getSimpleName() : f.getName())) continue;
            return f;
        }
        return null;
    }

    public String prepareJavaDocContent(ClassDefinition cls, String member, String content, CompletionJavaDoc.JavaDocTagItem[] tags) {
        JMIUtils jmiUtils = this.getJMIUtils();
        String pkgName = jmiUtils.getPackageName(cls);
        return this.prepareJavaDocContent(cls.getName(), pkgName, member, content, tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convert(Object content) {
        Object obj;
        if (content instanceof NbJMIResultItem && (obj = ((NbJMIResultItem)content).getAssociatedObject()) != null) {
            content = obj;
        }
        this.getJMIUtils().beginTrans(false);
        try {
            Object object;
            if (content instanceof Element && !((Element)content).isValid()) {
                object = null;
                return object;
            }
            if (content instanceof Feature) {
                content = JMIUtils.getDefintion((Feature)content);
            }
            if (content instanceof ClassDefinition) {
                content = JMIUtils.getSourceElementIfExists((ClassDefinition)content);
            }
            object = content;
            return object;
        }
        finally {
            this.getJMIUtils().endTrans(false);
        }
    }

    class JMIParsingThread
    extends NbCompletionJavaDoc.ParsingThread {
        static final /* synthetic */ boolean $assertionsDisabled;

        public JMIParsingThread(Object content) {
            super(content);
        }

        private String wrapClass(JavaClass clazz) {
            if (clazz == null || clazz.getName().length() == 0) {
                return "";
            }
            URL[] urls = NbJMICompletionJavaDoc.this.getJMISyntaxSupport().getJavaDocURLs(clazz);
            if (urls.length > 0 && urls[0] != null) {
                return "<font size='+0'><b><A href='" + urls[0].toString() + "'>" + clazz.getName() + "</A></b></font>";
            }
            return "";
        }

        private String wrapClass(String url) {
            StringBuffer sb;
            int htmlIndex;
            if (url == null) {
                return "";
            }
            String parent = url;
            int hashIndex = parent.lastIndexOf("#");
            if (hashIndex > 0) {
                parent = parent.substring(0, hashIndex);
            }
            if ((htmlIndex = (sb = new StringBuffer(url)).indexOf(".html")) > 0) {
                sb.delete(htmlIndex, sb.length());
            }
            for (int i = 0; i < sb.length() - 1; ++i) {
                if (sb.charAt(i) != '/') continue;
                String subStr = sb.substring(i + 1);
                subStr = subStr.replace('/', '.');
                if (NbJMICompletionJavaDoc.this.getJMIUtils().getExactClass(subStr) == null) continue;
                return "<font size='+0'><b><A href='" + parent + "'>" + subStr + "</A></b></font>";
            }
            return "";
        }

        private boolean tryMountedJavaDoc(URL url) {
            String textFromURL;
            String clazzInfo;
            if (url == null) {
                URL[] urls = NbJMICompletionJavaDoc.this.getJMISyntaxSupport().getJavaDocURLs(this.content);
                if (urls.length > 0 && urls[0] != null) {
                    url = urls[0];
                } else {
                    return false;
                }
            }
            String urlStr = url.toString();
            JavaClass clazz = null;
            String header = null;
            if (this.content instanceof JavaClass) {
                clazz = (JavaClass)this.content;
                header = this.getClassHeader((JavaClass)this.content);
            } else if (this.content instanceof CallableFeature || this.content instanceof Field) {
                clazz = ((Feature)this.content).getDeclaringClass();
            }
            String string = clazzInfo = clazz instanceof JavaClass ? this.wrapClass(clazz) : this.wrapClass(urlStr);
            if (header != null) {
                clazzInfo = clazzInfo + "<PRE>" + header + "</PRE>";
            }
            if ((textFromURL = HTMLJavadocParser.getJavadocText(url, this.content instanceof JavaPackage)) != null && textFromURL.length() > 0) {
                if (!textFromURL.toUpperCase().startsWith("<DL>") && !textFromURL.toUpperCase().startsWith("<PRE>")) {
                    textFromURL = "<BLOCKQUOTE>" + textFromURL + "</BLOCKQUOTE>";
                }
                String retrievedText = clazzInfo + textFromURL;
                NbJMICompletionJavaDoc.this.lastBase = this.getLastBase(urlStr);
                NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                this.showJavaDoc(retrievedText);
                return true;
            }
            return false;
        }

        private void setClass(JavaClass cls) {
            if (cls == null) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                this.javaDocNotFound();
                return;
            }
            if (this.isFromLibrary((Element)cls) && this.tryMountedJavaDoc(null)) {
                return;
            }
            JavaDoc jd = cls.getJavadoc();
            boolean notFound = jd == null || jd.getText().length() == 0 && jd.getTags().size() == 0;
            String preparedText = NbJMICompletionJavaDoc.this.prepareJavaDocContent((ClassDefinition)cls, this.getClassHeader(cls), notFound ? NbCompletionJavaDoc.CONTENT_NOT_FOUND : jd.getText(), notFound ? null : NbJMICompletionJavaDoc.this.getJavaDocTags(jd.getTags()));
            if (notFound && this.tryMountedJavaDoc(null)) {
                return;
            }
            this.showJavaDoc(preparedText);
        }

        private boolean isFromLibrary(Element el) {
            if (!$assertionsDisabled && el == null) {
                throw new AssertionError();
            }
            JavaModelPackage jmp = (JavaModelPackage)el.refImmediatePackage();
            if (jmp == null) {
                return false;
            }
            CodebaseClass cbClass = jmp.getCodebase();
            Iterator it = cbClass.refAllOfClass().iterator();
            if (it.hasNext()) {
                Codebase cb = (Codebase)it.next();
                return cb.isLibrary();
            }
            return false;
        }

        private void setFeature(Feature feature, String displayText) {
            if (feature == null) {
                if (this.tryMountedJavaDoc(null)) {
                    return;
                }
                NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                this.javaDocNotFound();
                return;
            }
            if (this.isFromLibrary((Element)feature) && this.tryMountedJavaDoc(null)) {
                return;
            }
            if (feature.getDeclaringClass() instanceof Array && "length".equals(feature.getName())) {
                this.showJavaDoc(ARRAY_LENGTH_FIELD_JAVADOC);
                return;
            }
            JavaDoc jd = feature.getJavadoc();
            String jdText = "";
            List jdTags = new ArrayList();
            if (jd != null) {
                jdTags = jd.getTags();
                jdText = jd.getText();
            }
            if (feature instanceof Method && (jdTags.size() == 0 && jdText.length() == 0 || jdText.indexOf("{@inheritDoc}") > -1)) {
                DataObject dObj = NbEditorUtilities.getDataObject((Document)NbJMICompletionJavaDoc.this.extEditorUI.getDocument());
                FileObject fo = dObj != null ? dObj.getPrimaryFile() : null;
                JavaMetamodel.getManager().setClassPath(fo, true);
                Iterator parentIt = JavaModelUtil.getOverriddenMethods((Method)((Method)feature)).iterator();
                while ((jdTags.size() == 0 && jdText.length() == 0 || jdText.indexOf("{@inheritDoc}") > -1) && parentIt.hasNext()) {
                    JavaDoc parentJD = ((Method)parentIt.next()).getJavadoc();
                    if (parentJD == null) continue;
                    jdText = jdText.length() == 0 ? parentJD.getText() : jdText.replaceAll("\\{@inheritDoc\\}", parentJD.getText());
                    if (jdTags.size() != 0) continue;
                    jdTags = parentJD.getTags();
                }
            }
            boolean notFound = jdText.length() == 0 && jdTags.size() == 0;
            String preparedText = NbJMICompletionJavaDoc.this.prepareJavaDocContent(feature.getDeclaringClass(), displayText, notFound ? NbCompletionJavaDoc.CONTENT_NOT_FOUND : jdText, notFound ? null : NbJMICompletionJavaDoc.this.getJavaDocTags(jdTags));
            if (notFound && this.tryMountedJavaDoc(null)) {
                return;
            }
            this.showJavaDoc(preparedText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHyperlinkedTypeName(Type typ) {
            TypeReference tRef = null;
            try {
                tRef = JavaModelUtil.createTypeReferenceFromType((Type)typ);
                String string = this.getHyperlinkedTypeName(tRef);
                return string;
            }
            finally {
                if (tRef != null) {
                    tRef.refDelete();
                }
            }
        }

        private String getHyperlinkedTypeName(TypeReference typ) {
            StringBuffer sb = new StringBuffer();
            if (typ instanceof ArrayReference) {
                sb.append(this.getHyperlinkedTypeName((TypeReference)typ.getParent()));
                for (int i = 0; i < ((ArrayReference)typ).getDimCount(); ++i) {
                    sb.append("[]");
                }
            } else if (typ instanceof MultipartId) {
                NamedElement el = typ.getElement();
                if (el instanceof JavaClass && !(el instanceof TypeParameter)) {
                    sb.append(NbJMICompletionJavaDoc.this.createAnchor(((JavaClass)el).getSimpleName(), el.getName(), NbJMICompletionJavaDoc.this.jmiUtils.getPackageName((ClassDefinition)((JavaClass)el))));
                } else {
                    sb.append(el.getName());
                }
                Iterator args = ((MultipartId)typ).getTypeArguments().iterator();
                if (args.hasNext()) {
                    sb.append("&lt;");
                    while (args.hasNext()) {
                        TypeArgument arg = (TypeArgument)args.next();
                        if (arg instanceof WildCard) {
                            sb.append('?');
                            TypeReference bound = ((WildCard)arg).getBoundName();
                            if (bound != null) {
                                sb.append(((WildCard)arg).isLower() ? " extends " : " super ");
                                sb.append(this.getHyperlinkedTypeName(bound));
                            }
                        } else if (arg instanceof TypeReference) {
                            sb.append(this.getHyperlinkedTypeName((TypeReference)arg));
                        }
                        if (!args.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("&gt;");
                }
            } else if (typ != null) {
                sb.append(typ.getName());
            }
            return sb.toString();
        }

        private String getTypeName(JavaClass jc) {
            StringBuffer sb = new StringBuffer();
            if (jc instanceof TypeParameter) {
                sb.append(jc.getSimpleName());
                boolean hasExtends = false;
                JavaClass sup = ((TypeParameter)jc).getSuperClass();
                if (sup != null && !"java.lang.Object".equals(sup.getName())) {
                    sb.append(" extends ");
                    sb.append(this.getHyperlinkedTypeName((Type)sup));
                    hasExtends = true;
                }
                Iterator it = ((TypeParameter)jc).getInterfaces().iterator();
                while (it.hasNext()) {
                    if (!hasExtends) {
                        sb.append(" extends ");
                        hasExtends = true;
                    } else {
                        sb.append(" & ");
                    }
                    sb.append(this.getHyperlinkedTypeName((Type)((JavaClass)it.next())));
                }
            } else {
                sb.append("<b>");
                sb.append(jc.getSimpleName());
                sb.append("</b>");
                Iterator params = jc.getTypeParameters().iterator();
                if (params.hasNext()) {
                    sb.append("&lt;");
                    while (params.hasNext()) {
                        sb.append(this.getTypeName((JavaClass)((TypeParameter)params.next())));
                        if (!params.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("&gt;");
                }
            }
            return sb.toString();
        }

        private String getDocumentedAnnotations(AnnotableElement element) {
            StringBuffer sb = new StringBuffer();
            Iterator it = element.getAnnotations().iterator();
            while (it.hasNext()) {
                Annotation ann = (Annotation)it.next();
                AnnotationType type = ann.getType();
                if (type == null) continue;
                Iterator itt = type.getAnnotations().iterator();
                while (itt.hasNext()) {
                    AnnotationType meta = ((Annotation)itt.next()).getType();
                    if (meta == null || !"java.lang.annotation.Documented".equals(meta.getName())) continue;
                    sb.append('@');
                    sb.append(this.getHyperlinkedTypeName((Type)type));
                    List values = ann.getAttributeValues();
                    if (!values.isEmpty()) {
                        try {
                            StringBuffer vsb = new StringBuffer();
                            Iterator ittt = values.iterator();
                            while (ittt.hasNext()) {
                                AttributeValue av = (AttributeValue)ittt.next();
                                vsb.append(av.getDefinition().getName());
                                vsb.append('=');
                                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((Element)av.getValue());
                                if (bounds == null) {
                                    vsb = null;
                                    break;
                                }
                                vsb.append(bounds.getText());
                                if (!ittt.hasNext()) continue;
                                vsb.append(", ");
                            }
                            if (vsb != null) {
                                sb.append('(');
                                sb.append(vsb);
                                sb.append(')');
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    sb.append("<br>");
                }
            }
            return sb.toString();
        }

        private String getClassHeader(JavaClass jc) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDocumentedAnnotations((AnnotableElement)jc));
            sb.append(Modifier.toString(jc.getModifiers()));
            if (jc instanceof AnnotationType) {
                sb.append(" @interface ");
            } else if (jc.isInterface()) {
                sb.append(" ");
            } else {
                sb.append(" class ");
            }
            sb.append(this.getTypeName(jc));
            JavaClass sup = jc.getSuperClass();
            if (sup != null && (!jc.isInterface() || sup.isInterface())) {
                sb.append("\nextends ");
                sb.append(this.getHyperlinkedTypeName((Type)sup));
            }
            if (!(jc instanceof AnnotationType)) {
                Iterator it = jc.getInterfaces().iterator();
                if (it.hasNext()) {
                    sb.append("\nimplements ");
                }
                while (it.hasNext()) {
                    JavaClass iface = (JavaClass)it.next();
                    sb.append(this.getHyperlinkedTypeName((Type)iface));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
            return sb.toString();
        }

        private String getFieldHeader(Field f) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDocumentedAnnotations((AnnotableElement)f));
            sb.append(Modifier.toString(f.getModifiers()));
            sb.append(" ");
            sb.append(this.getHyperlinkedTypeName(f.getType()));
            sb.append(" <b>");
            sb.append(f.getName());
            sb.append("</b>");
            return sb.toString();
        }

        private String getAttributeHeader(Attribute attr) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDocumentedAnnotations((AnnotableElement)attr));
            sb.append(Modifier.toString(attr.getModifiers()));
            sb.append(" ");
            sb.append(this.getHyperlinkedTypeName(attr.getType()));
            sb.append(" <b>");
            sb.append(attr.getName());
            sb.append("</b>");
            return sb.toString();
        }

        private String getCallableFeatureHeader(CallableFeature cf) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDocumentedAnnotations((AnnotableElement)cf));
            int len = sb.length();
            sb.append(Modifier.toString(cf.getModifiers()));
            sb.append(" ");
            Iterator tp = cf.getTypeParameters().iterator();
            if (tp.hasNext()) {
                sb.append("&lt;");
                while (tp.hasNext()) {
                    sb.append(this.getTypeName((JavaClass)((TypeParameter)tp.next())));
                    if (!tp.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append("&gt; ");
            }
            if (cf instanceof Method) {
                sb.append(this.getHyperlinkedTypeName(cf.getType()));
                sb.append(" <b>");
                sb.append(cf.getName());
            } else {
                sb.append("<b>");
                sb.append(((JavaClass)cf.getType()).getSimpleName());
            }
            sb.append("</b>(");
            len = this.getHtmlTextLength(sb.substring(len));
            List params = cf.getParameters();
            Iterator it = params.iterator();
            while (it.hasNext()) {
                String paramName;
                Parameter param = (Parameter)it.next();
                sb.append(this.getHyperlinkedTypeName(param.getType()));
                if (param.isVarArg()) {
                    sb.append("...");
                }
                if ((paramName = param.getName()) != null && paramName.length() > 0) {
                    sb.append(" ");
                }
                sb.append(paramName);
                if (!it.hasNext()) continue;
                sb.append(",\n");
                for (int i = 0; i < len; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(")");
            Iterator excs = cf.getExceptions().iterator();
            if (excs.hasNext()) {
                sb.append("\n\t\tthrows ");
            }
            while (excs.hasNext()) {
                sb.append(this.getHyperlinkedTypeName((Type)((JavaClass)excs.next())));
                if (!excs.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        private int getHtmlTextLength(String text) {
            int len = 0;
            boolean insideTag = false;
            boolean insideAmp = false;
            block6: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case '<': {
                        insideTag = true;
                        continue block6;
                    }
                    case '&': {
                        insideAmp = true;
                        continue block6;
                    }
                    case '>': {
                        insideTag = false;
                        continue block6;
                    }
                    case ';': {
                        insideAmp = false;
                    }
                    default: {
                        if (insideTag || insideAmp) continue block6;
                        ++len;
                    }
                }
            }
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NbJMICompletionJavaDoc.this.getJMIUtils().beginTrans(false);
            try {
                if (this.content instanceof Element && !((Element)this.content).isValid()) {
                    NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                    if (!this.tryMountedJavaDoc(null)) {
                        this.javaDocNotFound();
                    }
                    return;
                }
                NbJMICompletionJavaDoc.this.goToSourceEnabled = true;
                if (this.content instanceof JavaClass) {
                    NbJMICompletionJavaDoc.this.membersCache.put(this.content, null);
                    this.setClass((JavaClass)this.content);
                    NbJMICompletionJavaDoc.this.membersCache.clear();
                } else if (this.content instanceof Field) {
                    NbJMICompletionJavaDoc.this.membersCache.put(((Field)this.content).getDeclaringClass(), null);
                    this.setFeature((Feature)((Field)this.content), this.getFieldHeader((Field)this.content));
                    NbJMICompletionJavaDoc.this.membersCache.clear();
                } else if (this.content instanceof CallableFeature) {
                    NbJMICompletionJavaDoc.this.membersCache.put(((CallableFeature)this.content).getDeclaringClass(), null);
                    this.setFeature((Feature)((CallableFeature)this.content), this.getCallableFeatureHeader((CallableFeature)this.content));
                    NbJMICompletionJavaDoc.this.membersCache.clear();
                } else if (this.content instanceof Attribute) {
                    NbJMICompletionJavaDoc.this.membersCache.put(((Attribute)this.content).getDeclaringClass(), null);
                    this.setFeature((Feature)this.content, this.getAttributeHeader((Attribute)this.content));
                    NbJMICompletionJavaDoc.this.membersCache.clear();
                } else if (this.content instanceof URL) {
                    URL u = (URL)this.content;
                    if ("http".equals(u.getProtocol())) {
                        return;
                    }
                    if (!this.tryMountedJavaDoc((URL)this.content)) {
                        NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                        this.javaDocNotFound();
                    }
                    if (NbJMICompletionJavaDoc.this.addToHistory) {
                        NbJMICompletionJavaDoc.this.addToHistory(this.content);
                    }
                } else if (this.content instanceof String) {
                    NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                    String strCon = (String)this.content;
                    URL url = NbJMICompletionJavaDoc.this.mergeRelLink(NbJMICompletionJavaDoc.this.lastBase, strCon);
                    if (url == null) {
                        return;
                    }
                    if ("http".equals(url.getProtocol())) {
                        return;
                    }
                    if (NbJMICompletionJavaDoc.this.addToHistory) {
                        NbJMICompletionJavaDoc.this.addToHistory(url);
                    }
                    if (!this.tryMountedJavaDoc(url)) {
                        this.javaDocNotFound();
                    }
                } else if (this.content instanceof NbJMIResultItem.VarResultItem) {
                    NbJMIResultItem.VarResultItem varItem = (NbJMIResultItem.VarResultItem)this.content;
                    String itemText = varItem.getItemText();
                    Type varType = varItem.getType();
                    if ("class".equals(itemText) && varType != null && "java.lang.Class".equals(varType.getName())) {
                        this.showJavaDoc(CLASS_CONSTANT_JAVADOC);
                        return;
                    }
                    this.javaDocNotFound();
                } else {
                    NbJMICompletionJavaDoc.this.goToSourceEnabled = false;
                    if (!this.tryMountedJavaDoc(null)) {
                        this.javaDocNotFound();
                    }
                }
            }
            finally {
                NbJMICompletionJavaDoc.this.getJMIUtils().endTrans(false);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$java$NbJMICompletionJavaDoc == null ? (class$org$netbeans$modules$editor$java$NbJMICompletionJavaDoc = NbJMICompletionJavaDoc.class$("org.netbeans.modules.editor.java.NbJMICompletionJavaDoc")) : class$org$netbeans$modules$editor$java$NbJMICompletionJavaDoc).desiredAssertionStatus();
        }
    }

    private class ContentComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Object obj1 = NbJMICompletionJavaDoc.this.convert(o1);
            Object obj2 = NbJMICompletionJavaDoc.this.convert(o2);
            return obj1 != null && obj1.equals(obj2) ? 0 : 1;
        }
    }
}

