/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbfreeform.ui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.ejbfreeform.ui.EJBLocationsPanel;
import org.netbeans.modules.j2ee.ejbfreeform.ui.NewEJBFreeformProjectWizardIterator;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EJBLocationsWizardPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private EJBLocationsPanel component;
    private WizardDescriptor wizardDescriptor;
    private File baseFolder;
    private final Set listeners = new HashSet(1);

    public EJBLocationsWizardPanel() {
        this.getComponent().setName(NbBundle.getMessage((Class)NewEJBFreeformProjectWizardIterator.class, (String)"TXT_NewEJBFreeformProjectWizardIterator_EJBSources"));
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new EJBLocationsPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(EJBLocationsWizardPanel.class);
    }

    public boolean isValid() {
        this.getComponent();
        return this.component.valid(this.wizardDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        String srcPackages;
        String configFiles;
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.wizardDescriptor.putProperty("NewProjectWizard_Title", this.component.getClientProperty("NewProjectWizard_Title"));
        File baseFolder = (File)this.wizardDescriptor.getProperty("projectLocation");
        File nbProjectFolder = (File)this.wizardDescriptor.getProperty("projectFolder");
        if (baseFolder.equals(this.baseFolder)) {
            configFiles = this.component.getConfigFilesLocation().getAbsolutePath();
            srcPackages = this.component.getSrcPackagesLocation().getAbsolutePath();
        } else {
            this.baseFolder = baseFolder;
            FileObject fo = FileUtil.toFileObject((File)baseFolder);
            if (fo != null) {
                configFiles = this.guessConfigFiles(fo);
                srcPackages = this.guessJavaRoot(fo);
            } else {
                configFiles = "";
                srcPackages = "";
            }
        }
        this.component.setFolders(baseFolder, nbProjectFolder);
        this.component.setConfigFilesField(configFiles);
        this.component.setSrcPackages(srcPackages);
    }

    public void storeSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.wizardDescriptor.putProperty("ejbModules", (Object)this.component.getEJBModules());
        List l = this.component.getJavaSrcFolder();
        this.wizardDescriptor.putProperty("sourceFolders", (Object)l);
        this.wizardDescriptor.putProperty("ejbSourceFolders", (Object)this.component.getEJBSrcFolder());
        this.wizardDescriptor.putProperty("ejbResourceFolders", (Object)this.component.getResourcesFolder());
        this.wizardDescriptor.putProperty("serverID", (Object)this.component.getSelectedServerID());
        this.wizardDescriptor.putProperty("j2eeLevel", (Object)this.component.getSelectedJ2eeSpec());
        this.wizardDescriptor.putProperty("NewProjectWizard_Title", null);
    }

    private String guessConfigFiles(FileObject dir) {
        Enumeration ch = dir.getChildren(true);
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.getNameExt().equals("ejb-jar.xml")) continue;
            return FileUtil.toFile((FileObject)f.getParent()).getAbsolutePath();
        }
        return "";
    }

    private String guessJavaRoot(FileObject dir) {
        Enumeration ch = dir.getChildren(true);
        try {
            while (ch.hasMoreElements()) {
                FileObject f = (FileObject)ch.nextElement();
                if (!f.getExt().equals("java") || f.isFolder()) continue;
                String pckg = this.guessPackageName(f);
                String pkgPath = f.getParent().getPath();
                if (pckg == null || !pkgPath.endsWith(pckg.replace('.', '/'))) continue;
                String rootName = pkgPath.substring(0, pkgPath.length() - pckg.length());
                return FileUtil.toFile((FileObject)f.getFileSystem().findResource(rootName)).getAbsolutePath();
            }
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify(1, (Throwable)fsie);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessPackageName(FileObject f) {
        Reader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(f.getInputStream(), "utf-8"));
            boolean noPackage = false;
            while (true) {
                int idx;
                String line;
                if ((line = ((BufferedReader)r).readLine()) == null) {
                    if (noPackage) {
                        String string = "";
                        return string;
                    }
                    break;
                }
                if ((line = line.trim()).trim().startsWith("package") && (idx = line.indexOf(";")) >= 0) {
                    String string = line.substring("package".length(), idx).trim();
                    return string;
                }
                if (line.indexOf("class") == -1) continue;
                noPackage = true;
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }
}

