/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.ui.actions.AddBreakpointPanel;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class AddBreakpointAction
extends AbstractAction {
    private static AddBreakpointDialogManager abdm;

    public AddBreakpointAction() {
        this.putValue("Name", NbBundle.getMessage((Class)AddBreakpointAction.class, (String)"CTL_AddBreakpoint"));
    }

    public void actionPerformed(ActionEvent e) {
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        if (dm.lookup(null, BreakpointType.class).size() == 0) {
            return;
        }
        if (abdm == null) {
            abdm = new AddBreakpointDialogManager();
        }
        abdm.getDialog().setVisible(true);
    }

    static final class AddBreakpointDialogManager
    implements ActionListener,
    PropertyChangeListener {
        private boolean okPressed;
        private Dialog dialog;
        private AddBreakpointPanel panel;
        private DialogDescriptor descriptor;
        private Controller controller;
        private JButton bOk;
        private JButton bCancel;

        AddBreakpointDialogManager() {
        }

        Dialog getDialog() {
            this.dialog = this.createDialog();
            this.okPressed = false;
            this.setValid();
            this.startListening();
            this.panel.addPropertyChangeListener(this);
            return this.dialog;
        }

        private Dialog createDialog() {
            ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$ui$actions$AddBreakpointAction == null ? (class$org$netbeans$modules$debugger$ui$actions$AddBreakpointAction = AddBreakpointAction.class$("org.netbeans.modules.debugger.ui.actions.AddBreakpointAction")) : class$org$netbeans$modules$debugger$ui$actions$AddBreakpointAction));
            this.panel = new AddBreakpointPanel();
            this.descriptor = new DialogDescriptor((Object)this.panel, bundle.getString("CTL_Breakpoint_Title"), true, (ActionListener)this);
            this.bOk = new JButton(bundle.getString("CTL_Ok"));
            this.descriptor.setOptions((Object[])new JButton[]{this.bOk, this.bCancel = new JButton(bundle.getString("CTL_Cancel"))});
            this.bOk.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Ok"));
            this.bCancel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Cancel"));
            this.descriptor.setClosingOptions(new Object[0]);
            Dialog d = DialogDisplayer.getDefault().createDialog(this.descriptor);
            d.pack();
            return d;
        }

        public void actionPerformed(ActionEvent evt) {
            this.okPressed = this.bOk.equals(evt.getSource());
            Controller controller = this.panel.getController();
            boolean close = false;
            close = this.okPressed ? controller.ok() : controller.cancel();
            if (!close) {
                return;
            }
            this.panel.removePropertyChangeListener(this);
            this.stopListening();
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "type") {
                this.stopListening();
                this.setValid();
                this.startListening();
            } else if (e.getPropertyName() == "valid") {
                this.setValid();
            }
        }

        void startListening() {
            this.controller = this.panel.getController();
            if (this.controller == null) {
                return;
            }
            this.controller.addPropertyChangeListener(this);
        }

        void stopListening() {
            if (this.controller == null) {
                return;
            }
            this.controller.removePropertyChangeListener(this);
            this.controller = null;
        }

        void setValid() {
            Controller controller = this.panel.getController();
            if (controller == null) {
                this.bOk.setEnabled(false);
                return;
            }
            this.bOk.setEnabled(controller.isValid());
        }

        public boolean getOKPressed() {
            return this.okPressed;
        }
    }
}

