/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.debugger.ui.Utils;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ViewActions
extends AbstractAction {
    private String viewName;

    private ViewActions(String viewName) {
        this.viewName = viewName;
    }

    public Object getValue(String key) {
        if (key == "Name") {
            return NbBundle.getMessage((Class)ViewActions.class, (String)((String)super.getValue(key)));
        }
        Object value = super.getValue(key);
        if (key == "SmallIcon" && value instanceof String) {
            value = Utils.getIcon((String)value);
        }
        return value;
    }

    public void actionPerformed(ActionEvent evt) {
        ViewActions.openComponent(this.viewName, true);
    }

    static void openComponent(String viewName, boolean activate) {
        TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
        if (view == null) {
            throw new IllegalArgumentException(viewName);
        }
        view.open();
        if (activate) {
            view.requestActive();
        }
    }

    public static Action createBreakpointsViewAction() {
        ViewActions action = new ViewActions("breakpointsView");
        action.putValue("Name", "CTL_BreakpointsAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint");
        return action;
    }

    public static Action createCallStackViewAction() {
        ViewActions action = new ViewActions("callstackView");
        action.putValue("Name", "CTL_CallStackAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame");
        return action;
    }

    public static Action createLocalsViewAction() {
        ViewActions action = new ViewActions("localsView");
        action.putValue("Name", "CTL_LocalVariablesAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/localsView/LocalVariable");
        return action;
    }

    public static Action createSessionsViewAction() {
        ViewActions action = new ViewActions("sessionsView");
        action.putValue("Name", "CTL_SessionsAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/sessionsView/Session");
        return action;
    }

    public static Action createThreadsViewAction() {
        ViewActions action = new ViewActions("threadsView");
        action.putValue("Name", "CTL_ThreadsAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup");
        return action;
    }

    public static Action createWatchesViewAction() {
        ViewActions action = new ViewActions("watchesView");
        action.putValue("Name", "CTL_WatchesAction");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/watchesView/Watch");
        return action;
    }
}

