/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.SearchUtil;
import org.openide.ErrorManager;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ExecSupport {
    private String lookFor;
    private OutputCopier[] copyMakers;

    public void setStringToLookFor(String lookFor) {
        this.lookFor = lookFor;
    }

    public boolean isStringFound() {
        if (this.copyMakers == null) {
            return false;
        }
        return this.copyMakers[0].stringFound() || this.copyMakers[1].stringFound() || this.copyMakers[2].stringFound();
    }

    public void displayProcessOutputs(final Process child, String displayName) throws IOException, InterruptedException {
        InputOutput io = IOProvider.getDefault().getIO(displayName, false);
        try {
            io.getOut().reset();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        io.select();
        this.copyMakers = new OutputCopier[3];
        this.copyMakers[0] = new OutputCopier(new InputStreamReader(child.getInputStream()), (Writer)io.getOut(), true, this.lookFor);
        this.copyMakers[0].start();
        this.copyMakers[1] = new OutputCopier(new InputStreamReader(child.getErrorStream()), (Writer)io.getErr(), true, this.lookFor);
        this.copyMakers[1].start();
        this.copyMakers[2] = new OutputCopier(io.getIn(), new OutputStreamWriter(child.getOutputStream()), true);
        this.copyMakers[2].start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int ret = child.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                }
                finally {
                    try {
                        ExecSupport.this.copyMakers[0].interrupt();
                        ExecSupport.this.copyMakers[1].interrupt();
                        ExecSupport.this.copyMakers[2].interrupt();
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForMessage(String progressMessage, int timeout) {
        int retryTime = 10;
        ProgressHandle ph = null;
        if (progressMessage != null) {
            ph = ProgressHandleFactory.createHandle((String)progressMessage);
            ph.start();
        }
        try {
            Connect connect = new Connect(retryTime);
            Thread t = new Thread(connect);
            t.start();
            try {
                t.join(timeout);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (t.isAlive()) {
                connect.finishLoop();
                t.interrupt();
            }
            boolean bl = connect.getStatus();
            return bl;
        }
        finally {
            if (ph != null) {
                ph.finish();
            }
        }
    }

    private class Connect
    implements Runnable {
        int retryTime;
        boolean status = false;
        boolean loop = true;

        public Connect(int retryTime) {
            this.retryTime = retryTime;
        }

        public void finishLoop() {
            this.loop = false;
        }

        public void run() {
            while (this.loop) {
                if (ExecSupport.this.isStringFound()) {
                    this.status = true;
                    break;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }

    public static class OutputCopier
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        private boolean done = false;
        private String stringToLookFor;
        private boolean stringFound = false;
        private static final int FOUND = -1;

        public OutputCopier(Reader is, Writer os, boolean b, String lookFor) {
            this.os = os;
            this.is = is;
            this.autoflush = b;
            this.stringToLookFor = lookFor;
        }

        public OutputCopier(Reader is, Writer os, boolean b) {
            this(is, os, b, null);
        }

        public boolean stringFound() {
            return this.stringFound;
        }

        public void run() {
            int stringFoundChars = 0;
            char[] buff = new char[256];
            try {
                int read;
                while ((read = this.read(this.is, buff, 0, 256)) > 0) {
                    if (this.stringToLookFor != null && (stringFoundChars = SearchUtil.checkForString(this.stringToLookFor, stringFoundChars, buff, read)) == -1) {
                        this.stringToLookFor = null;
                        this.stringFound = true;
                    }
                    if (this.os == null) continue;
                    this.os.write(buff, 0, read);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException ex) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            while (!is.ready() && !this.done) {
                OutputCopier.sleep(100L);
            }
            return is.read(buff, start, count);
        }
    }
}

