/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateDatabasePanel
extends JPanel {
    private File derbySystemHome;
    private DialogDescriptor descriptor;
    private Color nbErrorForeground;
    private Color nbWarningForeground;
    private DocumentListener docListener = new DocumentListener(){

        public void removeUpdate(DocumentEvent e) {
            CreateDatabasePanel.this.validateDatabaseName();
        }

        public void insertUpdate(DocumentEvent e) {
            CreateDatabasePanel.this.validateDatabaseName();
        }

        public void changedUpdate(DocumentEvent e) {
            CreateDatabasePanel.this.validateDatabaseName();
        }
    };
    public JLabel databaseLocationLabel;
    public JTextField databaseLocationTextField;
    public JLabel databaseNameLabel;
    public JTextField databaseNameTextField;
    public JScrollPane infoScrollPane;
    public JTextArea infoTextArea;
    public JLabel messageLabel;
    public JLabel passwordLabel;
    public JTextField passwordTextField;
    public JLabel userLabel;
    public JTextField userTextField;

    public CreateDatabasePanel(String derbySystemHome) {
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
        if (this.nbWarningForeground == null) {
            this.nbWarningForeground = new Color(51, 51, 51);
        }
        this.derbySystemHome = new File(derbySystemHome);
        this.initComponents();
        this.databaseNameTextField.getDocument().addDocumentListener(this.docListener);
        this.userTextField.getDocument().addDocumentListener(this.docListener);
        this.passwordTextField.getDocument().addDocumentListener(this.docListener);
        this.updateLocation();
    }

    public void setDialogDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.validateDatabaseName();
    }

    public String getDatabaseName() {
        return this.databaseNameTextField.getText().trim();
    }

    public String getUser() {
        String user = this.userTextField.getText().trim();
        return user.length() > 0 ? user : null;
    }

    public String getPassword() {
        String password = this.passwordTextField.getText().trim();
        return password.length() > 0 ? password : null;
    }

    private void validateDatabaseName() {
        if (this.descriptor == null) {
            return;
        }
        String error = null;
        String warning = null;
        String databaseName = this.getDatabaseName();
        int illegalChar = DerbyDatabases.getFirstIllegalCharacter(databaseName);
        int unsupportedChar = this.getFirstUnsupportedCharacter(databaseName);
        if (databaseName.length() <= 0) {
            error = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DatabaseNameEmpty");
        } else if (illegalChar >= 0) {
            error = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DatabaseNameIllegalChar", (Object)new Character((char)illegalChar));
        } else if (databaseName.length() > 0 && new File(this.derbySystemHome, databaseName).exists()) {
            error = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DatabaseDirectoryExists", (Object)databaseName);
        } else if (unsupportedChar >= 0) {
            warning = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_DatabaseNameUnsupportedChar", (Object)new Character((char)unsupportedChar));
        } else if (this.getUser() == null || this.getPassword() == null) {
            warning = NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ERR_UserNamePasswordRecommended");
        }
        if (error != null) {
            this.messageLabel.setForeground(this.nbErrorForeground);
            this.messageLabel.setText(error);
            this.messageLabel.setToolTipText(error);
            this.descriptor.setValid(false);
        } else if (warning != null) {
            this.messageLabel.setForeground(this.nbWarningForeground);
            this.messageLabel.setText(warning);
            this.messageLabel.setToolTipText(warning);
            this.descriptor.setValid(true);
        } else {
            this.messageLabel.setText(" ");
            this.descriptor.setValid(true);
        }
    }

    private void updateLocation() {
        this.databaseLocationTextField.setText(this.derbySystemHome.getAbsolutePath());
    }

    private int getFirstUnsupportedCharacter(String databaseName) {
        for (int i = 0; i < databaseName.length(); ++i) {
            char ch = databaseName.charAt(i);
            if (ch >= ' ' && ch <= '\u00ff') continue;
            return ch;
        }
        return -1;
    }

    private void initComponents() {
        this.databaseNameLabel = new JLabel();
        this.databaseNameTextField = new JTextField();
        this.infoScrollPane = new JScrollPane();
        this.infoTextArea = new JTextArea();
        this.databaseLocationLabel = new JLabel();
        this.databaseLocationTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JTextField();
        this.messageLabel = new JLabel();
        this.databaseNameLabel.setLabelFor(this.databaseNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.databaseNameLabel, (String)NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"LBL_DatabaseName"));
        this.databaseNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseNameTextField"));
        this.infoScrollPane.setBorder(null);
        this.infoScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoScrollPane.setVerticalScrollBarPolicy(21);
        this.infoTextArea.setColumns(20);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setRows(5);
        this.infoTextArea.setText(NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"LBL_DatabaseLocationInfo"));
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setFocusable(false);
        this.infoTextArea.setOpaque(false);
        this.infoScrollPane.setViewportView(this.infoTextArea);
        this.databaseLocationLabel.setLabelFor(this.databaseLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.databaseLocationLabel, (String)NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"LBL_DatabaseLocation"));
        this.databaseLocationTextField.setEditable(false);
        this.databaseLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseLocationTextField"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"LBL_UserName"));
        this.userTextField.setColumns(15);
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_userTextField"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"LBL_Password"));
        this.passwordTextField.setColumns(15);
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_passwordTextField"));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)" ");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.infoScrollPane, 0, 440, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.databaseNameLabel).add((Component)this.userLabel).add((Component)this.passwordLabel).add((Component)this.databaseLocationLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.passwordTextField, -2, -1, -2).add(1, (Component)this.userTextField, -2, -1, -2).add(1, (Component)this.databaseNameTextField, 0, 310, Short.MAX_VALUE).add((Component)this.databaseLocationTextField, 0, 310, Short.MAX_VALUE))).add(2, (Component)this.messageLabel, 0, 440, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.databaseNameLabel).add((Component)this.databaseNameTextField, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.userTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordTextField, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.databaseLocationTextField, -2, -1, -2).add((Component)this.databaseLocationLabel)).add(11, 11, 11).add((Component)this.infoScrollPane, 0, 66, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.messageLabel).addContainerGap()));
    }
}

