/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.view.ui.slides.ResizeGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.SlideBar;

final class SlideGestureRecognizer
implements ActionListener,
MouseListener,
MouseMotionListener {
    private SlideBar slideBar;
    private Component mouseInButton = null;
    private int curMouseLocX;
    private int curMouseLocY;
    private AutoSlideTrigger autoSlideTrigger = new AutoSlideTrigger();
    private ResizeGestureRecognizer resizer;
    private boolean pressingButton = false;

    SlideGestureRecognizer(SlideBar slideBar, ResizeGestureRecognizer resize) {
        this.slideBar = slideBar;
        this.resizer = resize;
    }

    public void attachButton(AbstractButton button) {
        button.addActionListener(this);
        button.addMouseListener(this);
        button.addMouseMotionListener(this);
    }

    public void detachButton(AbstractButton button) {
        button.removeActionListener(this);
        button.removeMouseListener(this);
        button.addMouseMotionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.slideBar.userClickedSlidingButton((Component)e.getSource());
    }

    public void mouseMoved(MouseEvent e) {
        if (this.autoSlideTrigger.isEnabled()) {
            this.curMouseLocX = e.getX();
            this.curMouseLocY = e.getY();
        }
        if (this.pressingButton && (e.getModifiersEx() & 0x400) == 0) {
            this.pressingButton = false;
            this.autoSlideTrigger.activateAutoSlideInGesture();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.slideBar.isHoveringAllowed()) {
            return;
        }
        this.mouseInButton = (Component)e.getSource();
        this.curMouseLocX = e.getX();
        this.curMouseLocY = e.getY();
        this.pressingButton = false;
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.pressingButton = true;
            return;
        }
        this.autoSlideTrigger.activateAutoSlideInGesture();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseInButton = null;
        this.pressingButton = false;
        this.autoSlideTrigger.deactivateAutoSlideInGesture();
    }

    public void mousePressed(MouseEvent e) {
        this.autoSlideTrigger.deactivateAutoSlideInGesture();
        this.handlePopupRequests(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.autoSlideTrigger.deactivateAutoSlideInGesture();
        this.handlePopupRequests(e);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    private void handlePopupRequests(MouseEvent e) {
        if (e.getSource().equals(this.slideBar)) {
            return;
        }
        if (e.isPopupTrigger()) {
            this.slideBar.userTriggeredPopup(e, (Component)e.getSource());
        }
    }

    private final class AutoSlideTrigger
    implements ActionListener,
    AWTEventListener {
        private Timer slideInTimer = new Timer(200, this);
        private int initialX;
        private int initialY;
        private boolean autoSlideActive = false;
        private Rectangle activeArea;

        AutoSlideTrigger() {
            this.slideInTimer.setRepeats(true);
            this.slideInTimer.setCoalesce(true);
        }

        public void activateAutoSlideInGesture() {
            this.initialX = SlideGestureRecognizer.this.curMouseLocX;
            this.initialY = SlideGestureRecognizer.this.curMouseLocY;
            this.slideInTimer.start();
        }

        public void deactivateAutoSlideInGesture() {
            this.slideInTimer.stop();
        }

        public boolean isEnabled() {
            return this.autoSlideActive || this.slideInTimer.isRunning();
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.isSlideInGesture()) {
                this.slideInTimer.stop();
                if (this.autoSlideActive) {
                    this.autoSlideOut();
                }
                this.autoSlideActive = true;
                if (SlideGestureRecognizer.this.slideBar.userTriggeredAutoSlideIn(SlideGestureRecognizer.this.mouseInButton)) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
                } else {
                    this.autoSlideActive = false;
                }
            } else {
                this.initialX = SlideGestureRecognizer.this.curMouseLocX;
                this.initialY = SlideGestureRecognizer.this.curMouseLocY;
            }
        }

        public void eventDispatched(AWTEvent event) {
            this.autoSlideOutIfNeeded((MouseEvent)event);
        }

        private void autoSlideOutIfNeeded(MouseEvent evt) {
            if (!this.autoSlideActive) {
                return;
            }
            if (SlideGestureRecognizer.this.slideBar.isActive()) {
                this.cleanup();
                return;
            }
            if (this.isSlideOutGesture(evt)) {
                this.cleanup();
                this.autoSlideOut();
            }
        }

        private void autoSlideOut() {
            SlideGestureRecognizer.this.slideBar.userTriggeredAutoSlideOut();
        }

        private void cleanup() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.autoSlideActive = false;
            this.activeArea = null;
        }

        private boolean isSlideInGesture() {
            if (SlideGestureRecognizer.this.mouseInButton == null) {
                return false;
            }
            int diffX = Math.abs(this.initialX - SlideGestureRecognizer.this.curMouseLocX);
            int diffY = Math.abs(this.initialY - SlideGestureRecognizer.this.curMouseLocY);
            return diffX <= 2 && diffY <= 2;
        }

        private boolean isSlideOutGesture(MouseEvent evt) {
            if (SlideGestureRecognizer.this.resizer.isDragging()) {
                this.activeArea = null;
                return false;
            }
            if (this.activeArea == null) {
                this.activeArea = this.computeActiveArea();
                if (this.activeArea == null) {
                    return false;
                }
            }
            Point mouseLoc = evt.getPoint();
            SwingUtilities.convertPointToScreen(mouseLoc, (Component)evt.getSource());
            return !this.activeArea.contains(mouseLoc);
        }

        private Rectangle computeActiveArea() {
            Component slidedComp = SlideGestureRecognizer.this.slideBar.getSlidedComp();
            if (slidedComp == null || !slidedComp.isShowing()) {
                return null;
            }
            Point slideBarLoc = SlideGestureRecognizer.this.slideBar.getLocationOnScreen();
            Rectangle actArea = new Rectangle(slideBarLoc.x - 1, slideBarLoc.y - 1, SlideGestureRecognizer.this.slideBar.getWidth() - 1, SlideGestureRecognizer.this.slideBar.getHeight() - 1);
            Point slidedCompLoc = slidedComp.getLocationOnScreen();
            int slidex = slidedCompLoc.x;
            int slidey = slidedCompLoc.y;
            int slideh = slidedComp.getHeight();
            int slidew = slidedComp.getWidth();
            int orientation = SlideGestureRecognizer.this.slideBar.getModel().getOrientation();
            if (orientation == 2) {
                slidew += 8;
            }
            if (orientation == 1) {
                slidew += 8;
                slidex -= 8;
            }
            if (orientation == 3) {
                slideh += 8;
                slidey -= 8;
            }
            actArea = SwingUtilities.computeUnion(slidex, slidey, slidew, slideh, actArea);
            return actArea;
        }
    }
}

