/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.jaxws;

import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class WebProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    WebProject project;

    public WebProjectJAXWSClientSupport(WebProject project) {
        super((Project)project);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject webInfFo;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (webInfFo = webModule.getWebInf()) != null) {
            FileObject wsdlFo = webInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return webInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    protected void addJaxWs20Library() throws Exception {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        if (wsimportFO == null) {
            ProjectClassPathExtender pce = (ProjectClassPathExtender)this.project.getLookup().lookup(ProjectClassPathExtender.class);
            Library jaxws20_ext = LibraryManager.getDefault().getLibrary("jaxws20");
            if (pce != null && jaxws20_ext != null) {
                try {
                    pce.addLibrary(jaxws20_ext);
                }
                catch (IOException e) {
                    throw new Exception("Unable to add JAXWS 2.0 library", e.getCause());
                }
            } else {
                throw new Exception("Unable to add JAXWS 2.0 Library. ProjectClassPathExtender or library not found");
            }
        }
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getWebModule().getConfDir();
    }

    public String addServiceClient(String clientName, String wsdlUrl, String packageName, boolean isJsr109) {
        FileObject fo = this.project.findJaxWsFileObject();
        if (fo == null) {
            try {
                this.project.createJaxWsFileObject();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        String finalClientName = super.addServiceClient(clientName, wsdlUrl, packageName, isJsr109);
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Client client = jaxWsModel.findClientByName(finalClientName);
        if (client != null && client.getWsdlUrl().startsWith("file:")) {
            try {
                FileObject wsdlFolder = this.getWsdlFolderForClient(finalClientName);
                FileObject xmlResorcesFo = this.getLocalWsdlFolderForClient(finalClientName, false);
                if (xmlResorcesFo != null) {
                    WSUtils.copyFiles((FileObject)xmlResorcesFo, (FileObject)wsdlFolder);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return finalClientName;
    }
}

