/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.jaxws;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.WebProjectWebServicesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.spi.ProjectJAXWSSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebProjectJAXWSSupport
extends ProjectJAXWSSupport {
    private WebProject project;
    private AntProjectHelper antProjectHelper;
    private final String servletClassName = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private final String servletListener = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";

    public WebProjectJAXWSSupport(WebProject project, AntProjectHelper antProjectHelper) {
        super((Project)project, antProjectHelper);
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject webInfFo;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (webInfFo = webModule.getWebInf()) != null) {
            FileObject wsdlFo = webInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return webInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    public String getWsdlLocation(String serviceName) {
        String localWsdlFile;
        Service service;
        String localWsdl = serviceName + ".wsdl";
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (service = jaxWsModel.findServiceByName(serviceName)) != null && (localWsdlFile = service.getLocalWsdlFile()) != null) {
            localWsdl = localWsdlFile;
        }
        String prefix = "WEB-INF/wsdl/";
        return prefix + serviceName + "/" + localWsdl;
    }

    private void addServiceEntriesToDD(String serviceName) {
        String servletName = serviceName;
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            Servlet servlet = null;
            Listener listener = null;
            try {
                servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{servletName, "com.sun.xml.ws.transport.http.servlet.WSServlet"}, "ServletName");
                servlet.setLoadOnStartup(new BigInteger("1"));
                ServletMapping servletMapping = (ServletMapping)webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{servletName, "/" + serviceName}, "ServletName");
                if (!this.webAppHasListener(webApp, "com.sun.xml.ws.transport.http.servlet.WSServletContextListener")) {
                    listener = (Listener)webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{"com.sun.xml.ws.transport.http.servlet.WSServletContextListener"}, "ListenerClass");
                }
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (Exception e) {
                ErrorManager.getDefault().log(1, e.getLocalizedMessage());
            }
        }
    }

    private void removeServiceEntriesFromDD(String serviceName) {
        boolean changed = false;
        WebApp webApp = this.getWebApp();
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            Servlet servlet = servlets[i];
            if (!servlet.getServletName().equals(serviceName)) continue;
            webApp.removeServlet(servlet);
            changed = true;
            break;
        }
        ServletMapping[] mappings = webApp.getServletMapping();
        for (int i = 0; i < mappings.length; ++i) {
            ServletMapping mapping = mappings[i];
            if (!mapping.getServletName().equals(serviceName)) continue;
            webApp.removeServletMapping(mapping);
            changed = true;
            break;
        }
        boolean hasMoreWebServices = false;
        Servlet[] remainingServlets = webApp.getServlet();
        for (int i = 0; i < remainingServlets.length; ++i) {
            if (!remainingServlets[i].getServletClass().equals("com.sun.xml.ws.transport.http.servlet.WSServlet")) continue;
            hasMoreWebServices = true;
            break;
        }
        if (!hasMoreWebServices) {
            Listener[] listeners = webApp.getListener();
            for (int i = 0; i < listeners.length; ++i) {
                Listener listener = listeners[i];
                if (!listener.getListenerClass().equals("com.sun.xml.ws.transport.http.servlet.WSServletContextListener")) continue;
                webApp.removeListener(listener);
                changed = true;
                break;
            }
        }
        if (changed) {
            try {
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private boolean webAppHasListener(WebApp webApp, String listenerClass) {
        Listener[] listeners = webApp.getListener();
        for (int i = 0; i < listeners.length; ++i) {
            Listener listener = listeners[i];
            if (!listenerClass.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    public FileObject getDeploymentDescriptorFolder() {
        return this.getWebInf();
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return null;
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    public FileObject getDeploymentDescriptor() {
        FileObject webInfFo = this.getWebInf();
        if (webInfFo == null) {
            if (this.isProjectOpened()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
            }
            return null;
        }
        return this.getWebInf().getFileObject("web.xml");
    }

    public FileObject getWebInf() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            return webModule.getWebInf();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJaxwsArtifacts(Project project, String wsName, String serviceImpl) throws Exception {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        if (wsimportFO == null) {
            ProjectClassPathExtender pce = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
            Library jaxws20_ext = LibraryManager.getDefault().getLibrary("jaxws20");
            if (pce != null && jaxws20_ext != null) {
                try {
                    pce.addLibrary(jaxws20_ext);
                }
                catch (IOException e) {
                    throw new Exception("Unable to add JAXWS 2.0 library");
                }
            } else {
                throw new Exception("Unable to add JAXWS 2.0 Library. ProjectClassPathExtender or library not found");
            }
        }
        this.addServiceEntriesToDD(wsName);
        FileObject ddFolder = this.getDeploymentDescriptorFolder();
        if (ddFolder != null) {
            FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
            if (sunjaxwsFile == null) {
                WSUtils.generateSunJaxwsFile((FileObject)ddFolder);
            }
            sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
            Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
            Endpoint endpoint = endpoints.newEndpoint();
            endpoint.setEndpointName(wsName);
            endpoint.setImplementation(serviceImpl);
            endpoint.setUrlPattern("/" + wsName);
            endpoints.addEnpoint(endpoint);
            FileLock lock = null;
            OutputStream os = null;
            try {
                lock = sunjaxwsFile.lock();
                os = sunjaxwsFile.getOutputStream(lock);
                endpoints.write(os);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (os != null) {
                    os.close();
                }
            }
        } else {
            String mes = NbBundle.getMessage(WebProjectJAXWSSupport.class, (String)"MSG_CannotFindWEB-INF");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getWebModule().getConfDir();
    }

    public void serviceFromJavaRemoved(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Boolean isJsr109 = jaxWsModel.getJsr109();
        if (isJsr109 != null && !isJsr109.booleanValue()) {
            try {
                this.removeNonJsr109Entries(serviceName);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNonJsr109Entries(String serviceName) throws IOException {
        this.removeServiceEntriesFromDD(serviceName);
        FileObject ddFolder = this.getDeploymentDescriptorFolder();
        if (ddFolder != null) {
            FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
            if (sunjaxwsFile != null) {
                FileLock lock = null;
                JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
                if (jaxWsModel.getServices().length == 0) {
                    try {
                        lock = sunjaxwsFile.lock();
                        sunjaxwsFile.delete(lock);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                } else {
                    Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
                    Endpoint endpoint = endpoints.findEndpointByName(serviceName);
                    if (endpoint != null) {
                        endpoints.removeEndpoint(endpoint);
                        OutputStream os = null;
                        try {
                            lock = sunjaxwsFile.lock();
                            os = sunjaxwsFile.getOutputStream(lock);
                            endpoints.write(os);
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                }
            }
        } else {
            String mes = NbBundle.getMessage(WebProjectJAXWSSupport.class, (String)"MSG_CannotFindDDDirectory");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109) {
        FileObject fo = this.project.findJaxWsFileObject();
        if (fo == null) {
            try {
                this.project.createJaxWsFileObject();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return super.addService(name, serviceImpl, wsdlUrl, serviceName, portName, packageName, isJsr109);
    }

    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        FileObject fo = this.project.findJaxWsFileObject();
        if (fo == null) {
            try {
                this.project.createJaxWsFileObject();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        super.addService(serviceName, serviceImpl, isJsr109);
    }
}

