/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.RemoveClassPathRootAction;
import org.netbeans.modules.web.project.ui.ShowJavadocAction;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class ProjectNode
extends AbstractNode {
    private static final String PROJECT_ICON = "org/netbeans/modules/web/project/ui/resources/projectDependencies.gif";
    private static final Component CONVERTOR_COMPONENT = new Panel();
    private final AntArtifact antArtifact;
    private final URI artifactLocation;
    private Image cachedIcon;

    ProjectNode(AntArtifact antArtifact, URI artifactLocation, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper, String classPathId, String entryId, String webModuleElementName) {
        super(Children.LEAF, ProjectNode.createLookup(antArtifact, artifactLocation, helper, eval, refHelper, classPathId, entryId, webModuleElementName));
        this.antArtifact = antArtifact;
        this.artifactLocation = artifactLocation;
    }

    public String getDisplayName() {
        ProjectInformation info = this.getProjectInformation();
        if (info != null) {
            return NbBundle.getMessage(ProjectNode.class, (String)"TXT_ProjectArtifactFormat", (Object[])new Object[]{info.getDisplayName(), this.artifactLocation.toString()});
        }
        return NbBundle.getMessage(ProjectNode.class, (String)"TXT_UnknownProjectName");
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int type) {
        if (this.cachedIcon == null) {
            ProjectInformation info = this.getProjectInformation();
            if (info != null) {
                Icon icon = info.getIcon();
                if (icon instanceof ImageIcon) {
                    this.cachedIcon = ((ImageIcon)icon).getImage();
                } else {
                    int height = icon.getIconHeight();
                    int width = icon.getIconWidth();
                    this.cachedIcon = new BufferedImage(width, height, 2);
                    icon.paintIcon(CONVERTOR_COMPONENT, this.cachedIcon.getGraphics(), 0, 0);
                }
            } else {
                this.cachedIcon = Utilities.loadImage((String)PROJECT_ICON);
            }
        }
        return this.cachedIcon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenProjectAction.class), SystemAction.get(ShowJavadocAction.class), SystemAction.get(RemoveClassPathRootAction.class)};
    }

    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    private ProjectInformation getProjectInformation() {
        Project p = this.antArtifact.getProject();
        if (p != null) {
            return ProjectUtils.getInformation((Project)p);
        }
        return null;
    }

    private static Lookup createLookup(AntArtifact antArtifact, URI artifactLocation, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper, String classPathId, String entryId, String webModuleElementName) {
        Object[] content;
        Project p = antArtifact.getProject();
        if (p == null) {
            content = new Object[1];
        } else {
            content = new Object[3];
            content[1] = new JavadocProvider(antArtifact, artifactLocation);
            content[2] = p;
        }
        content[0] = new Removable(helper, eval, refHelper, classPathId, entryId, webModuleElementName);
        Lookup lkp = Lookups.fixed((Object[])content);
        return lkp;
    }

    private static class Removable
    implements RemoveClassPathRootAction.Removable {
        private final UpdateHelper helper;
        private final PropertyEvaluator eval;
        private final ReferenceHelper refHelper;
        private final String classPathId;
        private final String entryId;
        private final String webModuleElementName;
        private final ClassPathSupport cs;

        Removable(UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper, String classPathId, String entryId, String webModuleElementName) {
            this.helper = helper;
            this.eval = eval;
            this.refHelper = refHelper;
            this.classPathId = classPathId;
            this.entryId = entryId;
            this.webModuleElementName = webModuleElementName;
            this.cs = new ClassPathSupport(eval, refHelper, helper.getAntProjectHelper(), WebProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
        }

        public boolean canRemove() {
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            return props.getProperty(this.classPathId) != null;
        }

        public Project remove() {
            boolean removed = false;
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            String raw = props.getProperty(this.classPathId);
            List resources = this.cs.itemsList(raw, this.webModuleElementName);
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)i.next();
                if (!this.entryId.equals(WebProjectProperties.getAntPropertyName(item.getReference()))) continue;
                i.remove();
                removed = true;
            }
            if (removed) {
                String[] itemRefs = this.cs.encodeToStrings(resources.iterator(), this.webModuleElementName);
                props = this.helper.getProperties("nbproject/project.properties");
                props.setProperty(this.classPathId, itemRefs);
                this.helper.putProperties("nbproject/project.properties", props);
                String ref = "${" + this.entryId + "}";
                if (!RemoveClassPathRootAction.isReferenced(new EditableProperties[]{props, this.helper.getProperties("nbproject/private/private.properties")}, ref)) {
                    this.refHelper.destroyReference(ref);
                }
                return FileOwnerQuery.getOwner((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
            }
            return null;
        }
    }

    private static class OpenProjectAction
    extends NodeAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            Project[] projects = new Project[activatedNodes.length];
            for (int i = 0; i < projects.length; ++i) {
                projects[i] = (Project)activatedNodes[i].getLookup().lookup(Project.class);
            }
            OpenProjects.getDefault().open(projects, false);
        }

        protected boolean enable(Node[] activatedNodes) {
            Project[] openProjs = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project proj = (Project)activatedNodes[i].getLookup().lookup(Project.class);
                if (proj == null) {
                    return false;
                }
                boolean opened = false;
                for (int j = 0; j < openProjs.length; ++j) {
                    if (proj != openProjs[j]) continue;
                    opened = true;
                    break;
                }
                if (opened) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return NbBundle.getMessage(ProjectNode.class, (String)"CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(OpenProjectAction.class);
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final AntArtifact antArtifact;
        private final URI artifactLocation;

        JavadocProvider(AntArtifact antArtifact, URI artifactLocation) {
            this.antArtifact = antArtifact;
            this.artifactLocation = artifactLocation;
        }

        public boolean hasJavadoc() {
            return this.findJavadoc().size() > 0;
        }

        public void showJavadoc() {
            Set us = this.findJavadoc();
            URL[] urls = us.toArray(new URL[us.size()]);
            URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
            if (pageURL == null) {
                pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
            }
            ProjectInformation info = null;
            Project p = this.antArtifact.getProject();
            if (p != null) {
                info = ProjectUtils.getInformation((Project)p);
            }
            ShowJavadocAction.showJavaDoc(pageURL, info == null ? NbBundle.getMessage(ProjectNode.class, (String)"TXT_UnknownProjectName") : info.getDisplayName());
        }

        private Set findJavadoc() {
            File scriptLocation = this.antArtifact.getScriptLocation();
            HashSet<URL> urls = new HashSet<URL>();
            try {
                URL artifactURL = scriptLocation.toURI().resolve(this.artifactLocation).normalize().toURL();
                if (FileUtil.isArchiveFile((URL)artifactURL)) {
                    artifactURL = FileUtil.getArchiveRoot((URL)artifactURL);
                }
                urls.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)artifactURL).getRoots()));
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
            return urls;
        }
    }
}

