/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.customizer.AntArtifactChooser;
import org.openide.util.NbBundle;

public class ClassPathUiSupport {
    private ClassPathSupport cps;

    public static DefaultListModel createListModel(Iterator it) {
        DefaultListModel model = new DefaultListModel();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    public static ClassPathTableModel createTableModel(Iterator it) {
        return new ClassPathTableModel(ClassPathUiSupport.createListModel(it));
    }

    public static Iterator getIterator(DefaultListModel model) {
        return ClassPathUiSupport.getList(model).iterator();
    }

    public static List getList(DefaultListModel model) {
        return Collections.list(model.elements());
    }

    public static int[] moveUp(DefaultListModel listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveUp button should be disabled";
        for (i = 0; i < indices.length; ++i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] - 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] - 1;
        }
        return indices;
    }

    public static boolean canMoveUp(ListSelectionModel selectionModel) {
        return selectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveDown button should be disabled";
        for (i = indices.length - 1; i >= 0; --i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] + 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + 1;
        }
        return indices;
    }

    public static boolean canMoveDown(ListSelectionModel selectionModel, int modelSize) {
        int iMax = selectionModel.getMaxSelectionIndex();
        return iMax != -1 && iMax < modelSize - 1;
    }

    public static int[] remove(DefaultListModel listModel, int[] indices) {
        if (indices == null || indices.length == 0) assert (false) : "Remove button should be disabled";
        for (int i = indices.length - 1; i >= 0; --i) {
            listModel.remove(indices[i]);
        }
        if (!listModel.isEmpty()) {
            int selectedIndex = indices[indices.length - 1] - indices.length + 1;
            if (selectedIndex > listModel.size() - 1) {
                selectedIndex = listModel.size() - 1;
            }
            return new int[]{selectedIndex};
        }
        return new int[0];
    }

    public static int[] addLibraries(DefaultListModel listModel, int[] indices, Library[] libraries, Set alreadyIncludedLibs) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int j = 1;
        for (int i = 0; i < libraries.length; ++i) {
            if (alreadyIncludedLibs.contains(libraries[i])) continue;
            listModel.add(lastIndex + j++, ClassPathSupport.Item.create(libraries[i], null, "WEB-INF/lib"));
        }
        HashSet<Library> addedLibs = new HashSet<Library>(Arrays.asList(libraries));
        int[] indexes = new int[libraries.length];
        int j2 = 0;
        for (int i = 0; i < listModel.getSize(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)listModel.get(i);
            if (item.getType() != 1 || item.isBroken() || !addedLibs.contains(item.getLibrary())) continue;
            indexes[j2++] = i;
        }
        return indexes;
    }

    public static int[] addJarFiles(DefaultListModel listModel, int[] indices, File[] files) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[files.length];
        int i = 0;
        int delta = 0;
        while (i + delta < files.length) {
            File f;
            int current = lastIndex + 1 + i;
            String pathInWar = (f = files[i + delta]).isDirectory() ? "WEB-INF/classes" : "WEB-INF/lib";
            ClassPathSupport.Item item = ClassPathSupport.Item.create(f, null, pathInWar);
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[delta + i] = current;
                ++i;
                continue;
            }
            indexes[i + delta] = listModel.indexOf(item);
            ++delta;
        }
        return indexes;
    }

    public static int[] addArtifacts(DefaultListModel listModel, int[] indices, AntArtifactChooser.ArtifactItem[] artifactItems) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[artifactItems.length];
        for (int i = 0; i < artifactItems.length; ++i) {
            int current = lastIndex + 1 + i;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI(), null, "WEB-INF/lib");
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[i] = current;
                continue;
            }
            indexes[i] = listModel.indexOf(item);
        }
        return indexes;
    }

    public static final class ClassPathTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private DefaultListModel model;

        public ClassPathTableModel(DefaultListModel model) {
            this.model = model;
            model.addListDataListener(this);
        }

        public DefaultListModel getDefaultListModel() {
            return this.model;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.model.getSize();
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return NbBundle.getMessage(ClassPathUiSupport.class, (String)"LBL_CustomizeCompile_TableHeader_Name");
            }
            return NbBundle.getMessage(ClassPathUiSupport.class, (String)"LBL_CustomizeCompile_TableHeader_Deploy");
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return ClassPathSupport.Item.class;
            }
            return Boolean.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.getItem(row);
            }
            String pathInWar = this.getItem(row).getPathInWAR();
            return "WEB-INF/lib".equals(pathInWar) || "WEB-INF/classes".equals(pathInWar) ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setValueAt(Object value, int row, int column) {
            if (column != 1 || !(value instanceof Boolean)) {
                return;
            }
            if (value == Boolean.TRUE) {
                ClassPathSupport.Item item = this.getItem(row);
                String pathInWar = item.getType() == 0 && item.getFile().isDirectory() ? "WEB-INF/classes" : "WEB-INF/lib";
                item.setPathInWAR(pathInWar);
            } else {
                this.getItem(row).setPathInWAR(ClassPathSupport.Item.PATH_IN_WAR_NONE);
            }
            this.fireTableCellUpdated(row, column);
        }

        public void contentsChanged(ListDataEvent e) {
            this.fireTableRowsUpdated(e.getIndex0(), e.getIndex1());
        }

        public void intervalAdded(ListDataEvent e) {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        private ClassPathSupport.Item getItem(int index) {
            return (ClassPathSupport.Item)this.model.get(index);
        }

        private void setItem(ClassPathSupport.Item item, int index) {
            this.model.set(index, item);
        }
    }
}

