/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.core;

import com.sun.jdo.api.persistence.mapping.core.AbstractState;
import com.sun.jdo.api.persistence.mapping.core.PairHolderState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.Model;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ReferenceKey;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class PairState
extends AbstractState
implements ReferenceKey,
Cloneable {
    private List _columns;
    private PairHolderState _holderState;

    public PairState(Model model, PairHolderState declaringHolder, List columns) {
        super(model);
        this._holderState = declaringHolder;
        if (this._holderState != null) {
            this.setMappingClassElement(this._holderState.getMappingClassElement());
        }
        this.setColumns(columns);
    }

    protected void setColumns(List columns) {
        this._columns = columns;
    }

    public Object clone() {
        PairState clonedState = (PairState)super.clone();
        clonedState._columns = new ArrayList(this._columns);
        return clonedState;
    }

    public String getDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        List myPairs = this.getCompletePairs();
        int count = myPairs != null ? myPairs.size() : 0;
        lDump.append("Pairs are : \n");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String[] nextPair = (String[])myPairs.get(i);
                lDump.append("\t\tColumn pair : " + nextPair[0] + ", " + nextPair[1] + "\n");
            }
        } else {
            lDump.append("\t\tNone\n");
        }
        return lDump.toString();
    }

    public TableState getTableState() {
        return this._holderState.getTableState();
    }

    public String getKeyName() {
        throw new UnsupportedOperationException();
    }

    public void setKeyName(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean hasCompleteRows() {
        Iterator iterator = this.getAllColumnPairs().iterator();
        while (iterator.hasNext()) {
            if (!PairState.isCompletePair((String[])iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompletePair(Object[] pair) {
        return pair[0] != null && pair[1] != null;
    }

    public List getCompletePairs() {
        Iterator iterator = this.getAllColumnPairs().iterator();
        ArrayList<Object[]> completePairs = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            Object[] nextPair = (String[])iterator.next();
            if (!PairState.isCompletePair(nextPair)) continue;
            completePairs.add(nextPair);
        }
        return completePairs;
    }

    public boolean hasInvalidPairs() {
        Iterator pairIterator = this.getAllColumnPairs().iterator();
        TableState tableState = this.getTableState();
        while (pairIterator.hasNext()) {
            Object[] nextPair = (String[])pairIterator.next();
            if (!PairState.isCompletePair(nextPair) || tableState.getColumn((String)nextPair[0]) != null && tableState.getColumn((String)nextPair[1]) != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasPairAt(int index) {
        List list = this.getAllColumnPairs();
        return list != null && list.size() >= index + 1 && list.get(index) != null;
    }

    private String getRelativeName(DBMemberElement member) {
        return member != null ? NameUtil.getRelativeMemberName((String)member.getName().getFullName()) : null;
    }

    protected void addColumnPair(String[] element) {
        this._columns.add(element);
    }

    protected void addColumnPair(ColumnElement[] element) {
        this.addColumnPair(new String[]{this.getRelativeName((DBMemberElement)element[0]), this.getRelativeName((DBMemberElement)element[1])});
    }

    public void addColumnPair(ColumnElement localColumn, ColumnElement foreignColumn) {
        this.addColumnPair(new ColumnElement[]{localColumn, foreignColumn});
    }

    protected void addColumnPairs(Collection pairs) {
        if (pairs != null) {
            Iterator iterator = pairs.iterator();
            while (iterator.hasNext()) {
                Object nextPair = iterator.next();
                if (nextPair instanceof ColumnElement[]) {
                    this.addColumnPair((ColumnElement[])nextPair);
                    continue;
                }
                if (nextPair instanceof String[]) {
                    this.addColumnPair((String[])nextPair);
                    continue;
                }
                if (!(nextPair instanceof String)) continue;
                String pairName = (String)nextPair;
                int index = pairName.indexOf(59);
                this.addColumnPair(new String[]{pairName.substring(0, index), pairName.substring(index + 1)});
            }
        }
    }

    public void editColumnPair(int index, ColumnElement localColumn, ColumnElement foreignColumn) {
        this._columns.set(index, new String[]{this.getRelativeName((DBMemberElement)localColumn), this.getRelativeName((DBMemberElement)foreignColumn)});
    }

    public void removeColumnPair(int index) {
        if (this._columns.size() > index) {
            this._columns.remove(index);
        }
    }

    private int getIndex(ColumnPairElement pair) {
        List pairs = this.getAllColumnPairs();
        int count = pairs != null ? pairs.size() : 0;
        String testName = this.getRelativeName((DBMemberElement)pair);
        for (int i = 0; i < count; ++i) {
            String[] nextPair = (String[])pairs.get(i);
            if (!testName.equals(nextPair[0] + ";" + nextPair[1])) continue;
            return i;
        }
        return -1;
    }

    public TableElement getDeclaringTable() {
        return this.getTable(0);
    }

    protected String getDeclaringTableName() {
        Iterator pairIterator = this.getAllColumnPairs().iterator();
        while (pairIterator.hasNext()) {
            String[] nextPair = (String[])pairIterator.next();
            if (nextPair[0] == null) continue;
            return NameUtil.getTableName((String)nextPair[0]);
        }
        return null;
    }

    public void setDeclaringTable(TableElement tableElement) {
        throw new UnsupportedOperationException();
    }

    public TableElement getReferencedTable() {
        return this.getTable(1);
    }

    private TableElement getTable(int index) {
        Iterator pairIterator = this.getAllColumnPairs().iterator();
        TableState tableState = this.getTableState();
        while (pairIterator.hasNext()) {
            TableElement table;
            String[] nextPair = (String[])pairIterator.next();
            if (nextPair[index] == null || (table = tableState.getTable(nextPair[index])) == null) continue;
            return table;
        }
        return null;
    }

    public ColumnElement[] getLocalColumns() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        int count = columnPairs != null ? columnPairs.length : 0;
        ColumnElement[] columns = new ColumnElement[count];
        for (int i = 0; i < count; ++i) {
            columns[i] = columnPairs[i].getLocalColumn();
        }
        return columns;
    }

    public ColumnElement[] getReferencedColumns() {
        ColumnPairElement[] columnPairs = this.getColumnPairs();
        int count = columnPairs != null ? columnPairs.length : 0;
        ColumnElement[] columns = new ColumnElement[count];
        for (int i = 0; i < count; ++i) {
            columns[i] = columnPairs[i].getReferencedColumn();
        }
        return columns;
    }

    public void addColumnPair(ColumnPairElement pair) {
        this.addColumnPairs(new ColumnPairElement[]{pair});
    }

    public void addColumnPairs(ColumnPairElement[] pairs) {
        int count = pairs != null ? pairs.length : 0;
        for (int i = 0; i < count; ++i) {
            ColumnPairElement pair = pairs[i];
            if (pair == null) continue;
            this.addColumnPair(pair.getLocalColumn(), pair.getReferencedColumn());
        }
    }

    public void removeColumnPair(ColumnPairElement pair) {
        this.removeColumnPairs(new ColumnPairElement[]{pair});
    }

    public void removeColumnPairs(ColumnPairElement[] pairs) {
        int count = pairs != null ? pairs.length : 0;
        for (int i = 0; i < count; ++i) {
            this.removeColumnPair(this.getIndex(pairs[i]));
        }
    }

    public void removeDuplicatePairs() {
        List currentPairs = this.getAllColumnPairs();
        if (currentPairs != null && currentPairs.size() > 0) {
            ArrayList<Object[]> uniquePairs = new ArrayList<Object[]>();
            HashSet<Object[]> duplicateChecker = new HashSet<Object[]>();
            Iterator iterator = currentPairs.iterator();
            while (iterator.hasNext()) {
                Object[] nextPair;
                Object pairToAdd = nextPair = (String[])iterator.next();
                if (PairState.isCompletePair(nextPair)) {
                    pairToAdd = (String)nextPair[0] + ";" + (String)nextPair[1];
                }
                if (!duplicateChecker.add((Object[])pairToAdd)) continue;
                uniquePairs.add((Object[])pairToAdd);
            }
            this.setColumnPairs(uniquePairs);
        }
    }

    public void setColumnPairs(ColumnPairElement[] pairs) {
        this._columns.clear();
        this.addColumnPairs(pairs);
    }

    private void setColumnPairs(Collection pairs) {
        this._columns.clear();
        this.addColumnPairs(pairs);
    }

    public ColumnPairElement[] getColumnPairs() {
        Iterator pairIterator = this.getAllColumnPairs().iterator();
        TableState tableState = this.getTableState();
        ArrayList<DBMemberElement> returnPairs = new ArrayList<DBMemberElement>();
        while (pairIterator.hasNext()) {
            Object localColumn;
            TableElement table;
            DBMemberElement pair;
            Object[] nextPair = (String[])pairIterator.next();
            if (!PairState.isCompletePair(nextPair) || (pair = (table = tableState.getTable((String)(localColumn = nextPair[0]))) != null ? table.getMember(DBIdentifier.create((String)NameUtil.getAbsoluteMemberName((String)tableState.getCurrentSchemaName(), (String)((String)localColumn + ';' + (String)nextPair[1])))) : null) == null) continue;
            returnPairs.add(pair);
        }
        return returnPairs.toArray(new ColumnPairElement[0]);
    }

    public ColumnPairElement getColumnPair(DBIdentifier name) {
        int count;
        ColumnPairElement[] myPairs = this.getColumnPairs();
        int n = count = myPairs != null ? myPairs.length : 0;
        if (count > 0) {
            ColumnPairElement searchPair = (ColumnPairElement)this.getDeclaringTable().getMember(name);
            for (int i = 0; i < count; ++i) {
                if (!myPairs[i].equals((Object)searchPair)) continue;
                return searchPair;
            }
        }
        return null;
    }

    public List getAllColumnPairs() {
        return Collections.unmodifiableList(this._columns);
    }
}

