/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.util;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class DBListElement {
    private List _elements;
    private boolean _useFullName;
    private String _blankString;

    public DBListElement(String emptyString) {
        this((Object)null, false, emptyString);
    }

    public DBListElement(DBElement element, String emptyString) {
        this(element, false, emptyString);
    }

    public DBListElement(DBElement element, boolean useFullName, String emptyString) {
        this((Object)element, useFullName, emptyString);
    }

    private DBListElement(Object element, boolean useFullName, String emptyString) {
        this(element != null ? Collections.singletonList(element) : null, useFullName, emptyString);
    }

    public DBListElement(List elements, boolean useFullName, String emptyString) {
        this._elements = elements;
        this._useFullName = useFullName;
        this._blankString = emptyString;
    }

    public Object getFirstElement() {
        List elements = this.getElements();
        return elements.size() > 0 ? elements.get(0) : null;
    }

    public List getElements() {
        if (this._elements == null || this._elements.size() == 0) {
            this._elements = Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this._elements);
    }

    public static DBListElement[] convertArray(List elements, String firstElement, boolean useFullName) {
        DBListElement[] lReturn = null;
        if (elements != null) {
            boolean addBlank = firstElement != null;
            int startIndex = addBlank ? 1 : 0;
            int count = elements.size();
            lReturn = new DBListElement[count + startIndex];
            if (addBlank) {
                lReturn[0] = new DBListElement(firstElement);
            }
            for (int i = 0; i < count; ++i) {
                lReturn[i + startIndex] = new DBListElement(elements.get(i), useFullName, null);
            }
        } else {
            lReturn = new DBListElement[]{};
        }
        return lReturn;
    }

    public String toString() {
        int count;
        int n = count = this._elements != null ? this._elements.size() : 0;
        if (count > 0 && this._elements.get(0) != null) {
            StringBuffer lReturn = new StringBuffer();
            boolean useFullName = this._useFullName;
            for (int i = 0; i < count; ++i) {
                Object lElement = this._elements.get(i);
                if (i > 0) {
                    lReturn.append(",");
                }
                if (lElement instanceof DBMemberElement) {
                    DBMemberElement lMember = (DBMemberElement)lElement;
                    if (useFullName) {
                        lReturn.append(NameUtil.getRelativeMemberName((String)lMember.getName().getFullName()));
                        continue;
                    }
                    lReturn.append(lMember.getName().getName());
                    continue;
                }
                if (lElement instanceof DBElement) {
                    DBIdentifier dbIdentifier = ((DBElement)lElement).getName();
                    lReturn.append(useFullName ? dbIdentifier.getFullName() : dbIdentifier.getName());
                    continue;
                }
                if (lElement == null) continue;
                lReturn.append(lElement.toString());
            }
            return lReturn.toString();
        }
        return this._blankString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBListElement) {
            return this.toString().equals(((DBListElement)obj).toString());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

