/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.ejb.ui.panels;

import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.FieldState;
import com.sun.jdo.api.persistence.mapping.core.MappingStrategy;
import com.sun.jdo.api.persistence.mapping.core.PairState;
import com.sun.jdo.api.persistence.mapping.core.RelationshipState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.mapping.ejb.EJBInfoHelper;
import com.sun.jdo.api.persistence.mapping.ejb.MappingGenerator;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.modules.persistence.mapping.core.ui.panels.FieldMappingPanel;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingWizard;
import com.sun.jdo.modules.persistence.mapping.core.util.DBListElement;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.modules.persistence.mapping.ejb.ui.panels.AdvancedSettingsPanel;
import com.sun.jdo.modules.persistence.mapping.ejb.ui.panels.ConsistencyLevelPanel;
import com.sun.jdo.modules.persistence.mapping.ejb.ui.panels.TypeColumnEditor;
import com.sun.jdo.modules.persistence.mapping.ejb.util.SunOneUtilsCMP;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.ui.ComboBoxTableCellEditor;
import com.sun.jdo.spi.persistence.utility.ui.CustomListCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.CustomTableCellRenderer;
import com.sun.jdo.spi.persistence.utility.ui.IconWrapper;
import com.sun.jdo.spi.persistence.utility.ui.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.netbeans.modules.dbschema.util.SQLTypeUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public class BeanMappingPanel
extends JPanel {
    private static final String BEAN_SUFFIX1 = "bean";
    private static final String BEAN_SUFFIX2 = "eb";
    public static int TABLE_GENERATION_MODE = 1;
    public static int TABLE_MAPPING_MODE = 2;
    private MappingContext mappingContext;
    private HashMap classStateTable;
    private List dbSchemaFiles = null;
    private String currentBeanName;
    private EJBInfoHelper infoHelper;
    private int mode = TABLE_MAPPING_MODE;
    private boolean applyChangesImmediately = false;
    final Color DisabledBackgroundColor = Color.lightGray;
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)BeanMappingPanel.class);
    private PropertyChangeListener fieldChangedListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            String propName = evt.getPropertyName();
            if (source instanceof MappingClassElement && "fields".equals(propName) || source instanceof PersistenceClassElement && "fields".equals(propName)) {
                BeanMappingPanel.this.showMappingForBean(BeanMappingPanel.this.currentBeanName);
            }
        }
    };
    private JButton advSettingButton;
    private JButton automapButton;
    private JComboBox databasePrimaryTableComboBox;
    private JPanel jPanel1;
    private JTable mappingTable;
    private JLabel mappingTableLabel;
    private JScrollPane pFieldMapScrollPane;
    private JLabel pTableLabel;
    private JButton unmapButton;
    private static final int COLUMN_FIELD_NAME = 0;
    private static final int COLUMN_MAPPING = 1;
    private String columnHeadField;
    private String columnHeadMappedColumns;
    private String columnHeadType;
    private String columnHeadFetch;
    private DefaultTableModel mappingTableModel;
    private TableState relatedTableState = null;
    private ClassState StateObject;
    private TableState tableStateObject;
    private boolean tableListenerDisabled = false;
    private String head_type;
    private String head_fetch;
    private boolean _listenersDisabled = true;

    public BeanMappingPanel(MappingContext context) {
        this.classStateTable = new HashMap();
        this.mappingContext = context;
        if (context != null) {
            HelpCtx.setHelpIDString((JComponent)this, (String)this.mappingContext.getHelpID(this));
        }
        this.initComponents();
        this.setStateObject(null, "");
    }

    private void initComponents() {
        this.pTableLabel = new JLabel();
        this.databasePrimaryTableComboBox = new JComboBox();
        this.advSettingButton = new JButton();
        this.mappingTableLabel = new JLabel();
        this.pFieldMapScrollPane = new JScrollPane();
        this.mappingTable = new JTable();
        this.jPanel1 = new JPanel();
        this.automapButton = new JButton();
        this.unmapButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 600));
        this.pTableLabel.setDisplayedMnemonic(bundle.getString("BMP_LBL_Mnemonic_primary_table").trim().charAt(0));
        this.pTableLabel.setLabelFor(this.databasePrimaryTableComboBox);
        this.pTableLabel.setText(bundle.getString("BMP_LBL_PRIME_TABLE"));
        this.pTableLabel.setToolTipText(bundle.getString("BMP_TT_primary_table"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.pTableLabel, gridBagConstraints);
        this.databasePrimaryTableComboBox.setModel(new DefaultComboBoxModel());
        this.databasePrimaryTableComboBox.setToolTipText(bundle.getString("BMP_TT_primary_table"));
        this.databasePrimaryTableComboBox.setRenderer(new CustomListCellRenderer());
        SwingUtils.makeLightWeight(this.databasePrimaryTableComboBox);
        this.databasePrimaryTableComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BeanMappingPanel.this.databasePrimaryTableComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.databasePrimaryTableComboBox, gridBagConstraints);
        this.advSettingButton.setMnemonic(bundle.getString("BMP_LBL_Mnemonic_advanced_settings").trim().charAt(0));
        this.advSettingButton.setText(bundle.getString("BMP_LBL_advanced_settings"));
        this.advSettingButton.setToolTipText(bundle.getString("BMP_TT_advanced_settings"));
        this.advSettingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanMappingPanel.this.advSettingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.advSettingButton, gridBagConstraints);
        this.mappingTableLabel.setDisplayedMnemonic(bundle.getString("BMP_LBL_Mnemonic_persistent").trim().charAt(0));
        this.mappingTableLabel.setLabelFor(this.mappingTable);
        this.mappingTableLabel.setText(bundle.getString("BMP_LBL_persistent"));
        this.mappingTableLabel.setToolTipText(bundle.getString("BMP_TT_persistent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.mappingTableLabel, gridBagConstraints);
        this.pFieldMapScrollPane.setMinimumSize(new Dimension(450, 200));
        this.mappingTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.mappingTable.setPreferredSize(new Dimension(400, 400));
        this.pFieldMapScrollPane.setViewportView(this.mappingTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.pFieldMapScrollPane, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.automapButton.setMnemonic(bundle.getString("BMP_LBL_Mnemonic_automap_all").trim().charAt(0));
        this.automapButton.setText(bundle.getString("BMP_LBL_automap_all"));
        this.automapButton.setToolTipText(bundle.getString("BMP_TT_persistent"));
        this.automapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanMappingPanel.this.automapButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.automapButton, gridBagConstraints);
        this.unmapButton.setMnemonic(bundle.getString("BMP_LBL_Mnemonic_unmap_all").trim().charAt(0));
        this.unmapButton.setText(bundle.getString("BMP_LBL_unmap_all"));
        this.unmapButton.setToolTipText(bundle.getString("BMP_TT_unmap_all"));
        this.unmapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanMappingPanel.this.unmapButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.unmapButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void databasePrimaryTableComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.areListenersDisabled() && 1 == evt.getStateChange()) {
            Object lSelectedObj = this.databasePrimaryTableComboBox.getModel().getSelectedItem();
            TableElement newTable = null;
            if (lSelectedObj == null) {
                return;
            }
            if (lSelectedObj != null && lSelectedObj instanceof DBListElement) {
                Object lElement = ((DBListElement)lSelectedObj).getFirstElement();
                newTable = (TableElement)lElement;
            }
            if (!this.setSelectedTable(newTable)) {
                this.loadPrimaryTableInfo();
            } else {
                boolean newTableIsNull = newTable == null;
                this.StateObject.getFieldHolderState().addDefaultMapping();
                if (newTableIsNull) {
                    this.updateInverseRelationshipMappings();
                }
                this.buildMappingTable();
                if (!newTableIsNull) {
                    this.updateInverseRelationshipMappings();
                }
            }
        }
    }

    private void unmapButtonActionPerformed(ActionEvent evt) {
        if (!Util.checkForWarning(bundle.getString("BMP_unmap_warning"))) {
            return;
        }
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        int n = this.mappingTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableRow tablerow = (TableRow)this.mappingTableModel.getValueAt(i, 0);
            boolean isRelationship = tablerow.isRelationship();
            FieldHolderState state = this.StateObject.getFieldHolderState();
            PersistenceFieldElement field = tablerow.getField();
            MappingContext context = this.mappingContext;
            state.clearFieldMapping(field);
            this.updateMapping(tablerow, new DBListElement(isRelationship ? context.getString("VALUE_unmapped_relationship") : context.getString("VALUE_unmapped_field")), i);
            if (isRelationship) {
                this.unmapInverseRelationship((RelationshipElement)field, tablerow);
            }
            this.repaint();
        }
        if (n > 0) {
            this.applyChanges();
        }
    }

    private void automapButtonActionPerformed(ActionEvent evt) {
        if (!Util.checkForWarning(bundle.getString("BMP_map_warning"))) {
            return;
        }
        MappingContext context = this.mappingContext;
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        int mapped = 0;
        int n = this.mappingTable.getRowCount();
        FieldHolderState state = this.StateObject.getFieldHolderState();
        for (int i = 0; i < n; ++i) {
            TableRow tablerow = (TableRow)this.mappingTableModel.getValueAt(i, 0);
            PersistenceFieldElement field = tablerow.getField();
            if (tablerow.isSimpleField()) {
                ColumnElement candidate = state.getDefaultMapping(field);
                if (candidate == null) continue;
                state.setCurrentMapping(field, candidate);
                this.updateMapping(tablerow, new DBListElement((DBElement)candidate, true, context.getString("VALUE_unmapped_field")), i);
                ++mapped;
                continue;
            }
            RelationshipElement rel = (RelationshipElement)field;
            boolean hasCandidate = state.setCurrentMapping(rel, RelationshipState.getDefaultStateForField(state, rel));
            if (!hasCandidate) continue;
            this.updateMapping(tablerow, this.createRelationshipMapping(rel, tablerow.getState()), i);
            this.updateInverseRelationshipMapping(rel, tablerow);
            ++mapped;
        }
        if (mapped > 0) {
            this.applyChanges();
        }
        this.repaint();
    }

    private void advSettingButtonActionPerformed(ActionEvent evt) {
        String title = MessageFormat.format(bundle.getString("ADV_title"), this.infoHelper.getEjbJarDisplayName(), this.currentBeanName);
        if (this.mode == TABLE_GENERATION_MODE) {
            ConsistencyLevelPanel cLevel = new ConsistencyLevelPanel(this.mappingContext);
            int val = this.tableStateObject.getConsistencyLevel();
            cLevel.setConsistencyLevel(val);
            if (cLevel.showAsDialog(title)) {
                int xx = cLevel.getConsistencyLevel();
                if (cLevel.getConsistencyLevel() != val) {
                    this.tableStateObject.setConsistencyLevel(cLevel.getConsistencyLevel());
                    this.applyChanges();
                }
            }
        } else {
            ClassState origStateObject = (ClassState)this.StateObject.clone();
            TableState origTableState = (TableState)this.StateObject.getTableState().clone();
            AdvancedSettingsPanel asp = new AdvancedSettingsPanel(this.mappingContext, this.infoHelper, this.StateObject);
            if (!asp.showAsDialog(title)) {
                origStateObject.setTableState(origTableState);
                this.classStateTable.put(this.currentBeanName, origStateObject);
                this.StateObject = origStateObject;
            } else {
                if (StringHelper.isEmpty(origTableState.getCurrentSchemaName()) && !StringHelper.isEmpty(this.StateObject.getTableState().getCurrentSchemaName())) {
                    this.setDefaultTableMapping(this.StateObject, this.StateObject.getTableState());
                    this.databasePrimaryTableComboBox.setEnabled(true);
                }
                this.applyChanges();
            }
            if (this.mappingTable.isEditing()) {
                this.mappingTable.editingStopped(new ChangeEvent(this));
            }
            this.buildMappingTable();
            this.tableStateObject = this.StateObject.getTableState();
            this.updateInverseRelationshipMappings();
            this.loadPrimaryTableInfo();
        }
    }

    private void setStateObject(ClassState state, String bname) {
        MappingClassElement oldMce;
        if (this.StateObject != null && (oldMce = this.StateObject.getMappingClassElement()) != null) {
            oldMce.removePropertyChangeListener(this.fieldChangedListener);
        }
        if (state == null) {
            this.StateObject = null;
            this.buildMappingTable();
            this.tableStateObject = null;
            this.loadPrimaryTableInfo();
            return;
        }
        MappingClassElement mce = state.getMappingClassElement();
        if (mce == null) {
            this.mappingContext.getLogger().fine("NO Mapping Class Element for ClassState");
            return;
        }
        mce.addPropertyChangeListener(this.fieldChangedListener);
        this.StateObject = state;
        this.tableStateObject = this.StateObject.getTableState();
        this.buildMappingTable();
        this.loadPrimaryTableInfo();
    }

    public void buildMappingTable() {
        MappingContext context = this.mappingContext;
        this.columnHeadField = bundle.getString("BMP_HD_Field");
        this.columnHeadMappedColumns = bundle.getString("BMP_HD_Mapped_Columns");
        this.columnHeadType = bundle.getString("BMP_HD_Type");
        this.columnHeadFetch = bundle.getString("BMP_HD_Fetch");
        Object[] columns = new String[]{this.columnHeadField, this.columnHeadMappedColumns, this.columnHeadType, this.columnHeadFetch};
        this.mappingTableModel = new DefaultTableModel(columns, 0){

            public boolean isCellEditable(int row, int col) {
                TableRow tablerow;
                FieldHolderState holderState;
                Object value;
                String colName = this.getColumnName(col);
                if (col == 0) {
                    return false;
                }
                if (colName.equals(BeanMappingPanel.this.columnHeadFetch) && (value = this.getValueAt(row, col)) instanceof TableRow && (holderState = (tablerow = (TableRow)value).getState()).getFetchGroup(tablerow.getField()) == null) {
                    return false;
                }
                if (BeanMappingPanel.this.mode == TABLE_GENERATION_MODE) {
                    TableRow tr;
                    return colName.equals(BeanMappingPanel.this.columnHeadType) ? BeanMappingPanel.this.isTypeEditable((tr = (TableRow)this.getValueAt(row, col)).getTypeName(false)) : colName.equals(BeanMappingPanel.this.columnHeadFetch);
                }
                return !colName.equals(BeanMappingPanel.this.columnHeadType);
            }
        };
        this.mappingTable.setModel(this.mappingTableModel);
        SwingUtils.autosizeTableColumnWidths(this.mappingTable);
        if (this.StateObject != null) {
            this.updateMappingTable();
            this.mappingTableModel.addTableModelListener(new TableModelListener(){

                public final void tableChanged(TableModelEvent evt) {
                    if (!BeanMappingPanel.this.isTableListenerDisabled()) {
                        BeanMappingPanel.this.eventMappingTableChanged(evt);
                    }
                }
            });
        }
        this.setButtonState();
        this.mappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent evt) {
                BeanMappingPanel.this.setButtonState();
            }
        });
        SwingUtils.autosizeTable(this.mappingTable);
        if (this.mappingTable.getRowCount() > 0) {
            SwingUtils.selectNearestRow(this.mappingTable, 0);
        }
    }

    private boolean isTypeEditable(String val) {
        if (val == null) {
            return false;
        }
        return !val.equals("") && !val.equals(bundle.getString("BMP_multi_column_type")) && !val.equals(bundle.getString("BMP_relations_type"));
    }

    public final void updateMappingTable() {
        if (this.StateObject != null) {
            TableState state = this.StateObject.getTableState();
            if (this.relatedTableState == state) {
                // empty if block
            }
            this.relatedTableState = state;
        }
        if (this.StateObject != null && this.StateObject.getTableState().getCurrentPrimaryTable() == null) {
            this.mappingTableModel.setRowCount(0);
            this.automapButton.setEnabled(false);
            this.unmapButton.setEnabled(false);
            return;
        }
        this.automapButton.setEnabled(true);
        this.unmapButton.setEnabled(true);
        this.createCellEditors();
        this.fillMappingTable();
    }

    private final void createCellEditors() {
        List columns = this.relatedTableState != null ? this.relatedTableState.getSortedAllColumns() : null;
        DBListElement[] elements = columns != null ? DBListElement.convertArray(columns, null, true) : new DBListElement[]{};
        MappingContext context = this.mappingContext;
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        TableColumn column = this.mappingTable.getColumn(this.columnHeadField);
        final Color DisabledBackgroundColor = Color.lightGray;
        column.setCellRenderer(new DefaultTableCellRenderer(){

            public final Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, ((TableRow)value).getField(), selected, focus, row, col);
                if (!BeanMappingPanel.this.mappingTableModel.isCellEditable(row, col)) {
                    comp.setBackground(DisabledBackgroundColor);
                }
                return comp;
            }
        });
        column = this.mappingTable.getColumn(this.columnHeadMappedColumns);
        column.setCellRenderer(new CustomTableCellRenderer(){

            public final Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                TableRow tableRow = (TableRow)value;
                DBListElement mapping = tableRow.getMapping();
                FieldState fieldState = tableRow.getState().getCurrentStateForField(tableRow.getField());
                DBListElement returnValue = fieldState != null && fieldState.hasInvalidMapping() ? new IconWrapper(mapping.toString(), Util.getIllegalIcon()) : mapping;
                Component component = super.getTableCellRendererComponent(table, returnValue, selected, focus, row, col);
                if (BeanMappingPanel.this.mode == TABLE_GENERATION_MODE) {
                    component.setBackground(DisabledBackgroundColor);
                }
                return component;
            }
        });
        column.setCellEditor(new MappingCellEditor(elements, new CustomListCellRenderer()));
        column = this.mappingTable.getColumn(this.columnHeadType);
        column.setCellRenderer(new DefaultTableCellRenderer(){

            public final Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, ((TableRow)value).getTypeName(true), selected, focus, row, col);
                if (BeanMappingPanel.this.mode != TABLE_GENERATION_MODE) {
                    comp.setBackground(DisabledBackgroundColor);
                }
                return comp;
            }
        });
        column.setCellEditor(new TypeCellEditor());
        column = this.mappingTable.getColumn(this.columnHeadFetch);
        column.setCellRenderer(new CustomTableCellRenderer(){

            public final Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                TableRow tableRow = (TableRow)value;
                Object returnValue = tableRow.getState().getFetchGroup(tableRow.getField());
                if (returnValue != null) {
                    returnValue = BeanMappingPanel.this.getFetchGroupName((Integer)returnValue);
                }
                return super.getTableCellRendererComponent(table, returnValue, selected, focus, row, col);
            }
        });
        column.setCellEditor(new FetchGroupCellEditor(this.getNames(this.getConstants(this.StateObject.getFieldHolderState())), new CustomListCellRenderer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillMappingTable() {
        this.setTableListenerDisabled(true);
        try {
            FieldHolderState holderState = this.StateObject.getFieldHolderState();
            Object[] fields = holderState.getPersistenceClassElement().getFields();
            MappingClassElement mce = holderState.getMappingClassElement();
            boolean hasFields = fields != null;
            int n = hasFields ? fields.length : 0;
            this.mappingTableModel.setRowCount(0);
            if (hasFields) {
                Arrays.sort(fields);
            }
            for (int i = 0; i < n; ++i) {
                Object field = fields[i];
                boolean isrel = field instanceof RelationshipElement;
                MappingFieldElement mfe = mce.getField(((PersistenceElement)field).getName());
                if (mfe != null && mfe.isVersion()) continue;
                DBListElement mapping = field instanceof RelationshipElement ? this.createRelationshipMapping((RelationshipElement)field, holderState) : new DBListElement(this.convertMapping(holderState.getCurrentMapping((PersistenceFieldElement)field)), true, this.mappingContext.getString("VALUE_unmapped_field"));
                TableRow row = new TableRow((PersistenceFieldElement)field, holderState, mapping);
                this.mappingTableModel.addRow(new Object[]{row, row, row, row, row});
            }
            this.setButtonState();
        }
        finally {
            this.setTableListenerDisabled(false);
        }
    }

    private List convertMapping(List currentMapping) {
        TableState tableState = this.StateObject.getFieldHolderState().getTableState();
        ArrayList returnList = new ArrayList();
        Iterator iterator = currentMapping.iterator();
        while (iterator.hasNext()) {
            Object next;
            Object objectToAdd = next = iterator.next();
            if (next instanceof String) {
                String columnName = (String)next;
                ColumnElement column = tableState.getColumn(columnName);
                objectToAdd = column != null ? column : new IconWrapper(columnName, Util.getIllegalIcon());
            }
            returnList.add(objectToAdd);
        }
        return returnList;
    }

    private final void eventMappingTableChanged(TableModelEvent evt) {
        if (evt.getType() == 0 && evt.getColumn() == 1) {
            for (int i = evt.getFirstRow(); i <= evt.getLastRow(); ++i) {
                TableRow row = (TableRow)this.mappingTableModel.getValueAt(i, 0);
                this.replaceHolderState(row.getState());
            }
        }
    }

    private final void setButtonState() {
    }

    private final void launchMappingDlg() {
        int row = this.mappingTable.getEditingRow();
        TableRow rowdata = (TableRow)this.mappingTableModel.getValueAt(row, 0);
        if (rowdata.isRelationship()) {
            this.launchRelationshipMappingDlg(rowdata, row);
        } else {
            this.launchFieldMappingDlg(rowdata, row);
        }
    }

    private final void launchRelationshipMappingDlg(TableRow tablerow, int rowidx) {
        RelationshipElement rel = (RelationshipElement)tablerow.getField();
        FieldHolderState oldState = tablerow.getState();
        if (!oldState.hasInvalidSchema(rel)) {
            String relatedClassName;
            RelationshipElement inverse = oldState.getCurrentRelatedField(rel);
            PersistenceClassElement relatedClass = inverse != null ? inverse.getDeclaringClass() : null;
            String string = relatedClassName = relatedClass != null ? relatedClass.getName() : null;
            if (!rel.getDeclaringClass().equals(relatedClass) && relatedClass != null) {
                TableState emptyState = oldState.getTableState(relatedClassName);
                TableState filledState = this.getRelatedFieldHolderState(relatedClass).getTableState();
                this.updateRelatedPrimaryTable(emptyState, filledState);
                this.updateRelatedSecondaryTables(emptyState, filledState);
            }
            try {
                FieldHolderState newState = RelationshipMappingWizard.launchWindow(oldState, rel, this.mappingContext);
                TableState newTableState = newState.getTableState(relatedClassName);
                if (!oldState.equals(newState)) {
                    tablerow.setState(newState);
                }
                this.updateMapping(tablerow, this.createRelationshipMapping(rel, tablerow.getState()), rowidx);
                TableState relatedClassTableState = oldState.getTableState(relatedClassName);
                if (relatedClassTableState != null && !relatedClassTableState.getCurrentPrimaryTableName().equals(newTableState.getCurrentPrimaryTableName())) {
                    FieldHolderState relFieldHolder = this.getRelatedFieldHolderState(relatedClass);
                    this.updateRelatedPrimaryTable(relFieldHolder.getTableState(), newTableState);
                    relFieldHolder.addDefaultMapping();
                }
                this.updateInverseRelationshipMapping(rel, tablerow);
                this.applyChanges();
            }
            catch (UserCancelException ex) {}
        } else {
            MessageFormat mf = new MessageFormat(this.mappingContext.getString("MSG_SchemaMismatch"));
            String relatedClass = oldState.getCurrentRelatedClass(rel);
            int index = relatedClass.lastIndexOf(46);
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mf.format(new Object[]{relatedClass.substring(index + 1)}), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    private final void launchFieldMappingDlg(TableRow tablerow, int rowidx) {
        try {
            PersistenceFieldElement fieldElement = tablerow.getField();
            MappingContext context = this.mappingContext;
            FieldHolderState oldState = tablerow.getState();
            FieldHolderState newState = FieldMappingPanel.launchWindow(oldState, fieldElement, context);
            if (!oldState.equals(newState)) {
                tablerow.setState(newState);
            }
            if (newState != null) {
                this.updateMapping(tablerow, new DBListElement(this.convertMapping(newState.getCurrentMapping(fieldElement)), true, context.getString("VALUE_unmapped_field")), rowidx);
                this.applyChanges();
            }
        }
        catch (UserCancelException userCancelException) {
            // empty catch block
        }
    }

    private final void updateSimpleFieldMapping(TableRow tablerow, DBListElement mapping) {
        ColumnElement column;
        PersistenceFieldElement field = tablerow.getField();
        FieldHolderState oldstate = tablerow.getState();
        FieldHolderState newstate = (FieldHolderState)oldstate.clone();
        Object mappingElement = mapping.getFirstElement();
        ColumnElement columnElement = column = mappingElement instanceof ColumnElement ? (ColumnElement)mappingElement : null;
        if (!(mappingElement instanceof IconWrapper)) {
            MappingStrategy strategy = new MappingStrategy(this.mappingContext.getBrandedBundle("com.sun.jdo.api.persistence.mapping.core.Bundle"));
            newstate.setCurrentMapping(field, column);
            if (Util.checkForWarning(strategy.prepareAttach(oldstate, newstate))) {
                oldstate.setCurrentMapping(field, column);
                tablerow.setMapping(mapping);
                this.applyChanges();
            }
        }
    }

    private final void updateRelationshipMapping(RelationshipElement relation) {
        int n = this.mappingTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableRow tablerow = (TableRow)this.mappingTableModel.getValueAt(i, 0);
            if (!relation.equals(tablerow.getField())) continue;
            DBListElement mapping = this.createRelationshipMapping(relation, tablerow.getState());
            this.updateMapping(tablerow, mapping, i);
            break;
        }
    }

    private final void updateInverseRelationshipMapping(RelationshipElement rel, TableRow row) {
        PersistenceClassElement relatedClass;
        FieldHolderState myState = row.getState();
        RelationshipElement inverse = myState.getCurrentRelatedField(rel);
        PersistenceClassElement persistenceClassElement = relatedClass = inverse != null ? inverse.getDeclaringClass() : null;
        if (rel.getDeclaringClass().equals(relatedClass)) {
            this.updateRelationshipMapping(inverse);
        } else if (relatedClass != null) {
            FieldHolderState relatedState = this.getRelatedFieldHolderState(relatedClass);
            RelationshipState thisState = myState.getCurrentStateForField(rel);
            this.updateInverseMapping(relatedState, inverse, thisState);
            this.updateInverseMapping(relatedState.getRelatedState(inverse), rel, relatedState.getCurrentStateForField(inverse));
            this.updateInverseMapping(myState.getRelatedState(rel), inverse, thisState);
        }
    }

    private final void updateInverseMapping(FieldHolderState aHolderState, RelationshipElement inverse, RelationshipState relState) {
        RelationshipState inverseState = RelationshipState.getInverseStateForState(aHolderState, relState);
        if (aHolderState != null && !aHolderState.setCurrentMapping(inverse, inverseState)) {
            aHolderState.clearFieldMapping(inverse);
        }
    }

    private final void updateInverseRelationshipMappings() {
        int n = this.mappingTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableRow tablerow = (TableRow)this.mappingTableModel.getValueAt(i, 0);
            if (!tablerow.isRelationship()) continue;
            this.updateInverseRelationshipMapping((RelationshipElement)tablerow.getField(), tablerow);
        }
    }

    private final FieldHolderState getRelatedFieldHolderState(PersistenceClassElement relClass) {
        ClassState relClassState = this.getClassState(SunOneUtilsCMP.getBeanName(this.infoHelper, relClass.getName()));
        return relClassState.getFieldHolderState();
    }

    private final void updateRelatedPrimaryTable(TableState oldState, TableState newState) {
        String realPrimaryTable = newState.getCurrentPrimaryTableName();
        if (realPrimaryTable != null && !realPrimaryTable.equals(oldState.getCurrentPrimaryTableName())) {
            TableElement realTable = null;
            if (!StringHelper.isEmpty(realPrimaryTable)) {
                realTable = TableElement.forName((String)NameUtil.getAbsoluteTableName((String)oldState.getCurrentSchemaName(), (String)realPrimaryTable));
            }
            oldState.setCurrentPrimaryTable(realTable);
        }
    }

    private final void updateRelatedSecondaryTables(TableState oldState, TableState newState) {
        List realSecondaryNames;
        List secondaryNames = oldState.getSortedSecondaryTables();
        if (!((Object)secondaryNames).equals(realSecondaryNames = newState.getSortedSecondaryTables())) {
            ArrayList removed = new ArrayList(secondaryNames);
            ArrayList added = new ArrayList(realSecondaryNames);
            String schemaName = oldState.getCurrentSchemaName();
            TableElement primaryTable = oldState.getCurrentPrimaryTable();
            Iterator iterator = null;
            removed.removeAll(realSecondaryNames);
            iterator = removed.iterator();
            while (iterator.hasNext()) {
                oldState.removeSecondaryTable((String)iterator.next());
            }
            added.removeAll(secondaryNames);
            iterator = added.iterator();
            while (iterator.hasNext()) {
                String tableName = (String)iterator.next();
                oldState.addSecondaryTable(TableElement.forName((String)NameUtil.getAbsoluteTableName((String)schemaName, (String)tableName)));
                PairState emptyState = oldState.editSecondaryTable(tableName).getPairState();
                emptyState.setColumnPairs(newState.getCurrentStateForTable(primaryTable, tableName).getPairState().getColumnPairs());
            }
        }
    }

    private final void unmapInverseRelationship(RelationshipElement rel, TableRow row) {
        this.updateInverseRelationshipMapping(rel, row);
    }

    private final void unmapRelationship(TableRow tablerow) {
        RelationshipElement relation = (RelationshipElement)tablerow.getField();
        FieldHolderState oldstate = tablerow.getState();
        FieldHolderState newstate = (FieldHolderState)oldstate.clone();
        MappingStrategy strategy = new MappingStrategy(this.mappingContext.getBrandedBundle("com.sun.jdo.api.persistence.mapping.core.Bundle"));
        newstate.clearFieldMapping(relation);
        if (Util.checkForWarning(strategy.prepareAttach(oldstate, newstate))) {
            oldstate.clearFieldMapping(relation);
            this.unmapInverseRelationship(relation, tablerow);
            tablerow.setMapping(new DBListElement(this.mappingContext.getString("VALUE_unmapped_relationship")));
            this.applyChanges();
        }
    }

    private final void replaceHolderState(FieldHolderState newState) {
        this.StateObject.setFieldHolderState(newState);
        int n = this.mappingTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableRow row = (TableRow)this.mappingTableModel.getValueAt(i, 0);
            FieldHolderState lOldState = row.getState();
            if (!(lOldState instanceof FieldHolderState) || !(newState instanceof FieldHolderState)) continue;
            row.setState(newState);
        }
    }

    private final DBListElement createRelationshipMapping(RelationshipElement relation, FieldHolderState state) {
        List columns = state.getCurrentMapping(relation);
        MappingContext context = this.mappingContext;
        int count = columns != null ? columns.size() : 0;
        return new DBListElement(count == 0 ? context.getString("VALUE_unmapped_relationship") : context.getString("VALUE_mapped_relationship"));
    }

    private final void updateMapping(TableRow tablerow, DBListElement mapping, int row) {
        tablerow.setMapping(mapping);
        this.mappingTableModel.setValueAt(tablerow, row, 1);
    }

    private final boolean isTableListenerDisabled() {
        return this.tableListenerDisabled;
    }

    private final void setTableListenerDisabled(boolean disable) {
        this.tableListenerDisabled = disable;
    }

    private final String getFetchGroupName(int constant) {
        int groupDefault = 1;
        MessageFormat levelPrefix = new MessageFormat(this.mappingContext.getString("VALUE_hierarchical"));
        MessageFormat independepentPrefix = new MessageFormat(this.mappingContext.getString("VALUE_independent"));
        if (constant == 0) {
            return this.mappingContext.getString("VALUE_none");
        }
        if (constant == groupDefault) {
            return this.mappingContext.getString("VALUE_default");
        }
        if (constant > groupDefault) {
            return levelPrefix.format(new Object[]{new Integer(constant - 1)});
        }
        if (constant <= -1) {
            return independepentPrefix.format(new Object[]{new Integer(-1 * constant)});
        }
        return null;
    }

    private final int[] getLargestGroups(FieldHolderState holderState) {
        PersistenceClassElement classElement = holderState.getPersistenceClassElement();
        int largestLevel = 1;
        int largestIndependent = 0;
        if (classElement != null) {
            PersistenceFieldElement[] fields = classElement.getFields();
            int count = fields != null ? fields.length : 0;
            for (int i = 0; i < count; ++i) {
                int testLevel;
                Integer fetchGroup = holderState.getFetchGroup(fields[i]);
                int n = testLevel = fetchGroup != null ? fetchGroup : 0;
                if (testLevel > largestLevel) {
                    largestLevel = testLevel;
                }
                if (testLevel >= largestIndependent) continue;
                largestIndependent = testLevel;
            }
        }
        return new int[]{largestLevel, largestIndependent};
    }

    private final int[] getConstants(FieldHolderState holderState) {
        int i;
        int[] largestGroups = this.getLargestGroups(holderState);
        int largestLevel = largestGroups[0] + 1;
        int largestIndependent = largestGroups[1] - 1;
        int[] constants = new int[largestLevel + -1 * largestIndependent + 1];
        constants[0] = 0;
        for (i = 1; i <= largestLevel; ++i) {
            constants[i] = i;
        }
        for (i = -1; i >= largestIndependent; --i) {
            constants[-1 * i + largestLevel] = i;
        }
        return constants;
    }

    private final String[] getNames(int[] constants) {
        int count = constants != null ? constants.length : 0;
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this.getFetchGroupName(constants[i]);
        }
        return names;
    }

    private boolean setSelectedTable(TableElement newTable) {
        this.tableStateObject = this.StateObject.getTableState();
        TableState lNewState = (TableState)this.tableStateObject.clone();
        MappingStrategy strategy = new MappingStrategy(this.mappingContext.getBrandedBundle("com.sun.jdo.api.persistence.mapping.core.Bundle"));
        lNewState.setCurrentPrimaryTable(newTable);
        if (Util.checkForWarning(strategy.prepareAttach(this.StateObject.getFieldHolderState(), lNewState))) {
            this.replaceTableState(lNewState);
            this.applyChanges();
            return true;
        }
        return false;
    }

    private void replaceTableState(TableState lNewState) {
        if (lNewState != null) {
            this.StateObject.setTableState(lNewState);
            this.tableStateObject = lNewState;
            this.loadPrimaryTableInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrimaryTableInfo() {
        if (this.tableStateObject == null) {
            this.databasePrimaryTableComboBox.removeAllItems();
            return;
        }
        SchemaElement selectedSchema = this.tableStateObject.getCurrentSchema();
        String schemaName = this.tableStateObject.getCurrentSchemaName();
        try {
            DBListElement[] dBListElementArray;
            TableElement selection = this.tableStateObject.getCurrentPrimaryTable();
            String tableName = this.tableStateObject.getCurrentPrimaryTableName();
            List tTableList = selectedSchema == null ? null : TableState.getSortedPrimaryTableCandidates(selectedSchema);
            String unmapped = this.mappingContext.getString("VALUE_unmapped");
            if (tTableList == null) {
                DBListElement[] dBListElementArray2 = new DBListElement[1];
                dBListElementArray = dBListElementArray2;
                dBListElementArray2[0] = new DBListElement(unmapped);
            } else {
                dBListElementArray = DBListElement.convertArray(tTableList, unmapped, false);
            }
            DBListElement[] lTableList = dBListElementArray;
            DefaultComboBoxModel lComboModel = (DefaultComboBoxModel)this.databasePrimaryTableComboBox.getModel();
            boolean invalid = selection == null && !StringHelper.isEmpty(tableName) || selection != null && selection.getPrimaryKey() == null;
            this.setListenersDisabled(true);
            SwingUtils.replaceItems(lComboModel, Arrays.asList(lTableList));
            if (invalid) {
                IconWrapper iconWrapper = new IconWrapper(tableName, Util.getIllegalIcon());
                lComboModel.insertElementAt(iconWrapper, 0);
                lComboModel.setSelectedItem(iconWrapper);
            } else {
                lComboModel.setSelectedItem(new DBListElement((DBElement)selection, unmapped));
            }
        }
        finally {
            this.setListenersDisabled(false);
        }
        if (this.databasePrimaryTableComboBox.isEnabled()) {
            this.databasePrimaryTableComboBox.setEnabled(selectedSchema != null);
        }
    }

    protected boolean hasPrimaryTable() {
        return this.tableStateObject.getCurrentPrimaryTable() != null;
    }

    private boolean areListenersDisabled() {
        return this._listenersDisabled;
    }

    private void setListenersDisabled(boolean flag) {
        this._listenersDisabled = flag;
    }

    private void setMode() {
        if (SunOneUtilsCMP.isJavaToDB(this.infoHelper)) {
            this.mode = TABLE_GENERATION_MODE;
            this.automapButton.setVisible(false);
            this.unmapButton.setVisible(false);
            this.databasePrimaryTableComboBox.setEnabled(false);
        } else {
            this.mode = TABLE_MAPPING_MODE;
            this.automapButton.setVisible(true);
            this.unmapButton.setVisible(true);
            this.databasePrimaryTableComboBox.setEnabled(true);
        }
        this.classStateTable = new HashMap();
    }

    public void setApplyChangesImmediately(boolean flag) {
        this.applyChangesImmediately = flag;
    }

    public boolean showMappingForBean(String beanName) {
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        this.databasePrimaryTableComboBox.setEnabled(this.mode == TABLE_MAPPING_MODE);
        this.advSettingButton.setEnabled(true);
        this.currentBeanName = beanName;
        ClassState classState = this.getClassState(beanName);
        this.setStateObject(classState, beanName);
        return true;
    }

    private ClassState getClassState(String beanName) {
        ClassState classState = (ClassState)this.classStateTable.get(beanName);
        if (classState == null) {
            TableState relatedClassTableState;
            classState = SunOneUtilsCMP.createClassState(this.mappingContext, this.infoHelper, beanName);
            this.classStateTable.put(beanName, classState);
            if (!beanName.equals(this.currentBeanName) && StringHelper.isEmpty((relatedClassTableState = classState.getTableState()).getCurrentSchemaName()) && !StringHelper.isEmpty(this.StateObject.getTableState().getCurrentSchemaName())) {
                relatedClassTableState.setCurrentSchema(this.StateObject.getTableState().getCurrentSchema());
                this.setDefaultTableMapping(classState, relatedClassTableState);
            }
        }
        return classState;
    }

    private void setDefaultTableMapping(ClassState classState, TableState tableState) {
        ArrayList<String> suffixList = new ArrayList<String>();
        suffixList.add(this.mappingContext.getBrandingSuffix());
        suffixList.add(BEAN_SUFFIX1);
        suffixList.add(BEAN_SUFFIX2);
        tableState.addDefaultTableMapping(classState.getMappingClassElement().getName(), suffixList);
        classState.getFieldHolderState().addDefaultMapping();
    }

    public void disableAll() {
        this.databasePrimaryTableComboBox.removeAllItems();
        this.databasePrimaryTableComboBox.setEnabled(false);
        this.advSettingButton.setEnabled(false);
        this.automapButton.setVisible(false);
        this.unmapButton.setVisible(false);
        this.setStateObject(null, "");
    }

    public void setMappingContext(MappingContext context, EJBInfoHelper ejbBundle) {
        this.mappingContext = context;
        if (context != null) {
            HelpCtx.setHelpIDString((JComponent)this, (String)this.mappingContext.getHelpID(this));
        }
        this.infoHelper = ejbBundle;
        this.setMode();
    }

    public void reset() {
        this.setMode();
        this.currentBeanName = null;
    }

    public Map getAllEditedClassState() {
        if (this.mappingTable.isEditing()) {
            this.mappingTable.editingStopped(new ChangeEvent(this));
        }
        return (Map)this.classStateTable.clone();
    }

    public void setSchemaFiles(List fileList) {
        this.dbSchemaFiles = fileList;
    }

    private void applyChanges() {
        if (this.applyChangesImmediately) {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    Map classStateMap = BeanMappingPanel.this.getAllEditedClassState();
                    Iterator iter = classStateMap.values().iterator();
                    try {
                        while (iter.hasNext()) {
                            ClassState classState = (ClassState)iter.next();
                            MappingStrategy.attach(classState);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    BeanMappingPanel.this.classStateTable = new HashMap();
                    BeanMappingPanel.this.setStateObject(BeanMappingPanel.this.getClassState(BeanMappingPanel.this.currentBeanName), BeanMappingPanel.this.currentBeanName);
                }
            });
        }
    }

    private final class TypeCellEditor
    extends DefaultCellEditor {
        Object currentSel;
        JButton editor;

        public TypeCellEditor() {
            super(new JTextField());
            this.currentSel = null;
            ActionListener typeListener = new ActionListener(){
                boolean typeLaunching = false;

                public final void actionPerformed(ActionEvent evt) {
                    String fieldName = "";
                    if (!this.typeLaunching) {
                        this.typeLaunching = true;
                        ColumnElement ce = ((TableRow)TypeCellEditor.this.currentSel).getColumnElement();
                        fieldName = ((TableRow)TypeCellEditor.this.currentSel).getField().toString();
                        TypeColumnEditor tce = new TypeColumnEditor(ce, BeanMappingPanel.this.infoHelper, BeanMappingPanel.this.currentBeanName, fieldName);
                        String title = MessageFormat.format(bundle.getString("TCE_Title"), BeanMappingPanel.this.infoHelper.getEjbJarDisplayName() + "." + BeanMappingPanel.this.currentBeanName + "." + fieldName);
                        tce.showAsDialog(title);
                        this.typeLaunching = false;
                    }
                }
            };
            this.editor = new JButton();
            this.editor.addActionListener(typeListener);
            this.editor.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent evt) {
                    TypeCellEditor.this.eventButtonActionPerformed();
                }
            });
            this.setClickCountToStart(1);
        }

        protected void eventButtonActionPerformed() {
            this.stopCellEditing();
        }

        public Object getCellEditorValue() {
            return this.currentSel;
        }

        public Object setCellEditorValue() {
            return this.currentSel;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            this.currentSel = value;
            String label = ((TableRow)value).getTypeName(false);
            this.editor.setText(label);
            return this.editor;
        }
    }

    private final class FetchGroupCellEditor
    extends ComboBoxTableCellEditor {
        private int[] constants;
        private String[] names;

        public FetchGroupCellEditor(String[] allNames, ListCellRenderer customRenderer) {
            super(allNames, customRenderer);
            this.names = allNames;
        }

        private String[] setupConstants(TableRow tableRow) {
            this.constants = this.getConstants(tableRow);
            this.names = BeanMappingPanel.this.getNames(this.constants);
            return this.names;
        }

        public Object getCellEditorValue() {
            Object fgValue = super.getCellEditorValue();
            TableRow tablerow = this.getCurrentTableRow();
            if (fgValue instanceof String && fgValue != null) {
                FieldHolderState holderState = tablerow.getState();
                PersistenceFieldElement field = tablerow.getField();
                this.setupConstants(tablerow);
                for (int i = 0; i < this.constants.length; ++i) {
                    if (!this.names[i].equals(fgValue)) continue;
                    tablerow.getState().setFetchGroup(field, this.constants[i]);
                }
                BeanMappingPanel.this.applyChanges();
            }
            return tablerow;
        }

        public Component getEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            JComboBox editor = this.getComboBox();
            editor.removeAllItems();
            TableRow tablerow = (TableRow)value;
            Integer fetchGroup = tablerow.getState().getFetchGroup(tablerow.getField());
            int testLevel = fetchGroup != null ? fetchGroup : 0;
            this.setupConstants(tablerow);
            for (int i = 0; i < this.constants.length; ++i) {
                editor.addItem(this.names[i]);
                if (this.constants[i] != testLevel) continue;
                value = this.names[i];
            }
            return super.getEditorComponent(table, value, selected, row, column);
        }

        private int[] getConstants(TableRow tablerow) {
            return BeanMappingPanel.this.getConstants(tablerow.getState());
        }

        private final TableRow getCurrentTableRow() {
            return (TableRow)this.getInitialValue();
        }
    }

    private final class MappingCellEditor
    extends ComboBoxTableCellEditor {
        private DBListElement[] elements;

        public MappingCellEditor(DBListElement[] list, ListCellRenderer customRenderer) {
            super(list, customRenderer);
            this.elements = list;
        }

        public Object getCellEditorValue() {
            Object mapping = super.getCellEditorValue();
            String stringValue = mapping.toString();
            TableRow tablerow = this.getCurrentTableRow();
            MappingContext context = BeanMappingPanel.this.mappingContext;
            if (stringValue.equals(context.getString("VALUE_current_mapping")) || mapping.equals(tablerow.getMapping())) {
                return this.getInitialValue();
            }
            if (stringValue.equals(context.getString("VALUE_map_to_multiple")) || stringValue.equals(context.getString("VALUE_map_to_relationship"))) {
                BeanMappingPanel.this.launchMappingDlg();
            } else if (tablerow.isSimpleField()) {
                if (mapping instanceof DBListElement) {
                    BeanMappingPanel.this.updateSimpleFieldMapping(this.getCurrentTableRow(), (DBListElement)mapping);
                }
            } else {
                BeanMappingPanel.this.unmapRelationship(tablerow);
            }
            return tablerow;
        }

        public Component getEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            JComboBox editor = this.getComboBox();
            Icon illegalIcon = Util.getIllegalIcon();
            editor.removeAllItems();
            TableRow tablerow = (TableRow)value;
            FieldHolderState holderState = tablerow.getState();
            PersistenceFieldElement field = tablerow.getField();
            FieldState fieldState = holderState.getCurrentStateForField(field);
            boolean illegal = fieldState != null && fieldState.hasInvalidMapping();
            List columns = holderState.getCurrentMapping(field);
            int count = columns != null ? columns.size() : 0;
            MappingContext context = BeanMappingPanel.this.mappingContext;
            if (tablerow.isRelationship()) {
                value = new DBListElement(context.getString("VALUE_unmapped_relationship"));
                editor.addItem(value);
                if (count > 0) {
                    String mappedRelationship = context.getString("VALUE_current_mapping");
                    value = illegal ? new IconWrapper(mappedRelationship, illegalIcon) : new DBListElement(mappedRelationship);
                    editor.addItem(value);
                }
                editor.addItem(context.getString("VALUE_map_to_relationship"));
            } else {
                value = new DBListElement(context.getString("VALUE_unmapped_field"));
                editor.addItem(value);
                if (count > 1) {
                    String multiValue = context.getString("VALUE_current_mapping");
                    value = illegal ? new IconWrapper(multiValue, illegalIcon) : new DBListElement(multiValue);
                    editor.insertItemAt(value, 1);
                } else if (count == 1 && illegal) {
                    value = new IconWrapper(columns.get(0).toString(), illegalIcon);
                    editor.insertItemAt(value, 0);
                }
                DBListElement mapping = tablerow.getMapping();
                for (int i = 0; i < this.elements.length; ++i) {
                    editor.addItem(this.elements[i]);
                    if (count != 1 || !this.elements[i].equals(mapping)) continue;
                    value = this.elements[i];
                }
                editor.addItem(context.getString("VALUE_map_to_multiple"));
            }
            return super.getEditorComponent(table, value, selected, row, column);
        }

        private final TableRow getCurrentTableRow() {
            return (TableRow)this.getInitialValue();
        }
    }

    private final class TableRow {
        private final PersistenceFieldElement field;
        private FieldHolderState state;
        private DBListElement mapping;
        private final boolean isRelationship;

        TableRow(PersistenceFieldElement aField, FieldHolderState aState, DBListElement mapping) {
            this.field = aField;
            this.state = aState;
            this.mapping = mapping;
            this.isRelationship = this.field instanceof RelationshipElement;
        }

        final DBListElement getMapping() {
            return this.mapping;
        }

        final void setMapping(DBListElement mapping) {
            this.mapping = mapping;
        }

        final PersistenceFieldElement getField() {
            return this.field;
        }

        final FieldHolderState getState() {
            return this.state;
        }

        final void setState(FieldHolderState newState) {
            this.state = newState;
        }

        final boolean isRelationship() {
            return this.isRelationship;
        }

        final boolean isSimpleField() {
            return !this.isRelationship();
        }

        public String toString() {
            PersistenceFieldElement field = this.getField();
            return field != null ? field.toString() : super.toString();
        }

        public ColumnElement getColumnElement() {
            ColumnElement ce = null;
            if (this.isSimpleField()) {
                PersistenceFieldElement field = this.getField();
                FieldHolderState holderState = this.getState();
                List columns = holderState.getCurrentMapping(field);
                if (columns == null || columns.size() == 0) {
                    ce = null;
                } else {
                    if (columns.size() == 1) {
                        String columnName = (String)columns.get(0);
                        TableState tableState = holderState.getTableState();
                        ce = tableState.getColumn(columnName);
                        return ce;
                    }
                    return null;
                }
            }
            return null;
        }

        public String getTypeName(boolean includeValue) {
            String typeName = "";
            if (this.isSimpleField()) {
                PersistenceFieldElement field = this.getField();
                FieldHolderState holderState = this.getState();
                List columns = holderState.getCurrentMapping(field);
                if (columns == null || columns.size() == 0) {
                    return typeName;
                }
                if (columns.size() == 1) {
                    String columnName = (String)columns.get(0);
                    TableState tableState = holderState.getTableState();
                    ColumnElement ce = tableState.getColumn(columnName);
                    if (ce != null) {
                        int type = ce.getType();
                        typeName = SQLTypeUtil.getSqlTypeString((int)type);
                        if (includeValue) {
                            if (MappingGenerator.SQLTypeUtil.hasLength(type)) {
                                Integer lengthInt = ce.getLength();
                                if (lengthInt != null) {
                                    typeName = typeName + "(" + lengthInt + ")";
                                }
                            } else {
                                Integer precisionInt = null;
                                Integer scaleInt = null;
                                if (MappingGenerator.SQLTypeUtil.hasPrecision(type)) {
                                    precisionInt = ce.getPrecision();
                                }
                                if (MappingGenerator.SQLTypeUtil.hasScale(type)) {
                                    scaleInt = ce.getScale();
                                }
                                if (precisionInt != null && scaleInt != null) {
                                    typeName = typeName + "(" + precisionInt + "," + scaleInt + ")";
                                } else if (precisionInt != null && scaleInt == null) {
                                    typeName = typeName + "(" + precisionInt + ")";
                                }
                            }
                        }
                        return typeName;
                    }
                } else {
                    return bundle.getString("BMP_multi_column_type");
                }
            }
            return bundle.getString("BMP_relations_type");
        }
    }
}

