/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

class SuggestionCache
implements DocumentListener,
PropertyChangeListener {
    private HashMap map = null;

    SuggestionCache() {
    }

    public void add(Document doc, DataObject dobj, List suggestions) {
        if (this.map == null) {
            this.map = new HashMap(60);
        }
        doc.removeDocumentListener(this);
        doc.addDocumentListener(this);
        EditorCookie.Observable observable = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class);
        if (observable != null) {
            observable.removePropertyChangeListener((PropertyChangeListener)this);
            observable.addPropertyChangeListener((PropertyChangeListener)this);
        }
        Entry entry = new Entry(doc, suggestions, observable);
        this.map.put(doc, entry);
    }

    public List lookup(Document doc) {
        if (this.map == null) {
            return null;
        }
        Entry entry = (Entry)this.map.get(doc);
        if (entry == null) {
            return null;
        }
        return entry.list;
    }

    public void flush() {
        if (this.map == null) {
            return;
        }
        this.map.clear();
    }

    public void remove(Document doc) {
        Entry entry = (Entry)this.map.remove(doc);
        if (entry != null) {
            doc.removeDocumentListener(this);
            if (entry.listener != null) {
                entry.listener.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String prop = ev.getPropertyName();
        if (prop.equals("document")) {
            try {
                EditorCookie ec = (EditorCookie)ev.getSource();
                StyledDocument doc = ec.getDocument();
                this.invalidate(doc);
            }
            catch (Exception e) {
                ErrorManager.getDefault().log("ev.getSource().getClass() = " + ev.getSource().getClass().getName());
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private void invalidate(Document doc) {
        this.remove(doc);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.invalidate(e.getDocument());
    }

    public void removeUpdate(DocumentEvent e) {
        this.invalidate(e.getDocument());
    }

    private static class Entry {
        List list;
        Document doc;
        EditorCookie.Observable listener;

        Entry(Document doc, List list, EditorCookie.Observable listener) {
            this.list = list;
            this.doc = doc;
            this.listener = listener;
        }
    }
}

