/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.wizard.HardStringWizardPanel;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TestStringWizardPanel
extends JPanel {
    private static final int COLUMN_INDEX_CHECK = 0;
    private static final int COLUMN_INDEX_HARDSTRING = 1;
    private static final int COLUMN_INDEX_KEY = 2;
    private static final int COLUMN_INDEX_VALUE = 3;
    private final Map sourceMap = Util.createWizardSourceMap();
    private final AbstractTableModel tableModel = new TestStringTableModel();
    private JComboBox sourceCombo;
    private JLabel testStringLabel;
    private JLabel sourceLabel;
    private JScrollPane scrollPane;
    private JTable testStringTable;
    static /* synthetic */ Class class$java$lang$Boolean;

    private TestStringWizardPanel() {
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.setComboModel(this.sourceMap);
    }

    private void setComboModel(Map sourceMap) {
        Object[] sources = sourceMap.keySet().toArray();
        ArrayList<Object> nonEmptySources = new ArrayList<Object>();
        for (int i = 0; i < sources.length; ++i) {
            if (((SourceData)sourceMap.get(sources[i])).getStringMap().isEmpty()) continue;
            nonEmptySources.add(sources[i]);
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(nonEmptySources.toArray()));
    }

    private void postInitComponents() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.sourceLabel.setDisplayedMnemonic(Util.getString("LBL_Source_Mnem").charAt(0));
        this.testStringLabel.setLabelFor(this.testStringTable);
        this.testStringLabel.setDisplayedMnemonic(Util.getString("LBL_missing_keys_mne").charAt(0));
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.setComboModel(sourceMap);
    }

    private Map getStringMap() {
        SourceData sourceData = (SourceData)this.sourceMap.get(this.sourceCombo.getSelectedItem());
        return sourceData == null ? null : sourceData.getStringMap();
    }

    private Set getRemovedStrings() {
        SourceData sourceData = (SourceData)this.sourceMap.get(this.sourceCombo.getSelectedItem());
        if (sourceData == null) {
            return null;
        }
        if (sourceData.getRemovedStrings() == null) {
            sourceData.setRemovedStrings(new HashSet());
        }
        return sourceData.getRemovedStrings();
    }

    private void initTable() {
        this.testStringTable.setDefaultRenderer(HardCodedString.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                HardCodedString hcString = (HardCodedString)value;
                if (hcString != null) {
                    label.setText(hcString.getText());
                } else {
                    label.setText("");
                }
                return label;
            }
        });
        this.testStringTable.setDefaultRenderer(I18nString.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                I18nString i18nString = (I18nString)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int modelColumn = TestStringWizardPanel.this.testStringTable.convertColumnIndexToModel(column);
                if (i18nString != null) {
                    if (modelColumn == 2) {
                        label.setText(i18nString.getKey());
                    } else {
                        label.setText(i18nString.getValue());
                    }
                } else {
                    label.setText("");
                }
                return label;
            }
        });
        this.testStringTable.setDefaultEditor(I18nString.class, new DefaultCellEditor(new JTextField()){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                I18nString i18nString = (I18nString)value;
                int modelColumn = TestStringWizardPanel.this.testStringTable.convertColumnIndexToModel(column);
                value = modelColumn == 2 ? (i18nString == null ? "" : i18nString.getKey()) : (modelColumn == 3 ? (i18nString == null ? "" : i18nString.getValue()) : "");
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        });
        this.testStringTable.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.testStringLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.testStringTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.sourceLabel.setText(NbBundle.getBundle((Class)HardStringWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestStringWizardPanel.this.sourceComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
        this.testStringLabel.setText(NbBundle.getBundle((Class)HardStringWizardPanel.class).getString("LBL_missing_keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.testStringLabel, gridBagConstraints);
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.testStringTable.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.testStringTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        if (((SourceData)this.sourceMap.get(this.sourceCombo.getSelectedItem())).getStringMap().isEmpty()) {
            JLabel label = new JLabel(NbBundle.getBundle((Class)TestStringWizardPanel.class).getString("TXT_AllI18nStringsSource"));
            label.setHorizontalAlignment(0);
            this.scrollPane.setViewportView(label);
        } else {
            this.scrollPane.setViewportView(this.testStringTable);
            this.tableModel.fireTableDataChanged();
        }
        this.tableModel.fireTableDataChanged();
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements WizardDescriptor.FinishablePanel,
    I18nWizardDescriptor.ProgressMonitor {
        private final JLabel emptyLabel = new JLabel(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel = TestStringWizardPanel.class$("org.netbeans.modules.i18n.wizard.TestStringWizardPanel")) : class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel)).getString("TXT_AllI18nStrings"));
        private transient TestStringWizardPanel testStringPanel;

        public Panel() {
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setVerticalAlignment(0);
        }

        protected Component createComponent() {
            JPanel panel = new JPanel();
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel = TestStringWizardPanel.class$("org.netbeans.modules.i18n.wizard.TestStringWizardPanel")) : class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel)).getString("ACS_TestStringWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
            panel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel = TestStringWizardPanel.class$("org.netbeans.modules.i18n.wizard.TestStringWizardPanel")) : class$org$netbeans$modules$i18n$wizard$TestStringWizardPanel)).getString("TXT_FoundMissingResource"));
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            panel.add((Component)this.getUI(), constraints);
            return panel;
        }

        public boolean isValid() {
            return true;
        }

        public boolean isFinishPanel() {
            return true;
        }

        public void readSettings(Object settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            JPanel panel = (JPanel)this.getComponent();
            if (Panel.foundStrings(this.getMap())) {
                if (panel.isAncestorOf(this.emptyLabel)) {
                    panel.remove(this.emptyLabel);
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.weightx = 1.0;
                    constraints.weighty = 1.0;
                    constraints.fill = 1;
                    panel.add((Component)this.getUI(), constraints);
                }
            } else if (panel.isAncestorOf(this.getUI())) {
                panel.remove(this.getUI());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                panel.add((Component)this.emptyLabel, constraints);
            }
        }

        public void storeSettings(Object settings) {
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        public void doLongTimeChanges() {
            if (Panel.foundStrings(this.getMap())) {
                ProgressWizardPanel progressPanel = new ProgressWizardPanel(true);
                progressPanel.setMainText(NbBundle.getBundle(this.getClass()).getString("LBL_Internationalizing"));
                progressPanel.setMainProgress(0);
                ((Container)this.getComponent()).remove(this.getUI());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                ((Container)this.getComponent()).add((Component)progressPanel, constraints);
                ((JComponent)this.getComponent()).revalidate();
                this.getComponent().repaint();
                Map sourceMap = this.getUI().getSourceMap();
                Iterator sourceIterator = sourceMap.keySet().iterator();
                int i = 0;
                while (sourceIterator.hasNext()) {
                    Object source = sourceIterator.next();
                    SourceData sourceData = (SourceData)sourceMap.get(source);
                    I18nSupport support = sourceData.getSupport();
                    Map stringMap = sourceData.getStringMap();
                    Set removed = sourceData.getRemovedStrings();
                    Iterator it = stringMap.keySet().iterator();
                    ClassPath cp = ClassPath.getClassPath((FileObject)((DataObject)source).getPrimaryFile(), (String)"classpath/source");
                    progressPanel.setSubText(Util.getString("LBL_Source") + " " + cp.getResourceName(((DataObject)source).getPrimaryFile(), '.', false));
                    int j = 0;
                    while (it.hasNext()) {
                        HardCodedString hcString = (HardCodedString)it.next();
                        I18nString i18nString = (I18nString)stringMap.get(hcString);
                        if (removed == null || !removed.contains(hcString)) {
                            String comment = i18nString.getComment();
                            if (source instanceof DataObject && (comment == null || "".equals(comment))) {
                                DataObject dobj = (DataObject)source;
                                cp = ClassPath.getClassPath((FileObject)dobj.getPrimaryFile(), (String)"classpath/source");
                                comment = cp.getResourceName(dobj.getPrimaryFile(), '.', false);
                            }
                            String key = i18nString.getKey();
                            String prev = support.getResourceHolder().getCommentForKey(key);
                            comment = comment + (prev == null ? "" : " " + prev);
                            support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), comment, false);
                            progressPanel.setSubProgress((int)((float)(j + 1) / (float)stringMap.size() * 100.0f));
                        }
                        ++j;
                    }
                    if (support.hasAdditionalCustomizer()) {
                        support.performAdditionalChanges();
                    }
                    progressPanel.setMainProgress((int)((float)(i + 1) / (float)sourceMap.size() * 100.0f));
                    ++i;
                }
            }
        }

        public void reset() {
        }

        private static boolean foundStrings(Map sourceMap) {
            Iterator it = sourceMap.keySet().iterator();
            while (it.hasNext()) {
                SourceData sourceData = (SourceData)sourceMap.get(it.next());
                if (sourceData.getStringMap().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.testing");
        }

        private synchronized TestStringWizardPanel getUI() {
            if (this.testStringPanel == null) {
                this.testStringPanel = new TestStringWizardPanel();
            }
            return this.testStringPanel;
        }
    }

    public static class CustomizeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private I18nString i18nString;
        private JButton editorComponent = new JButton("...");

        public CustomizeCellEditor() {
            this.editorComponent.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PropertyPanel panel = CustomizeCellEditor.this.i18nString.getSupport().getPropertyPanel();
                    panel.setI18nString(CustomizeCellEditor.this.i18nString);
                    DialogDescriptor dd = new DialogDescriptor((Object)panel, "Customize Property");
                    dd.setModal(true);
                    dd.setOptionType(-1);
                    dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
                    dd.setAdditionalOptions(new Object[0]);
                    dd.setButtonListener((ActionListener)CustomizeCellEditor.this);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                    dialog.setVisible(true);
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.i18nString = (I18nString)value;
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.i18nString;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 1;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void actionPerformed(ActionEvent evt) {
            this.stopCellEditing();
        }
    }

    private class TestStringTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            Map stringMap = TestStringWizardPanel.this.getStringMap();
            return stringMap == null ? 0 : stringMap.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Map stringMap = TestStringWizardPanel.this.getStringMap();
            if (stringMap == null) {
                return null;
            }
            if (columnIndex == 0) {
                return !TestStringWizardPanel.this.getRemovedStrings().contains(stringMap.keySet().toArray()[rowIndex]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (columnIndex == 1) {
                return stringMap.keySet().toArray()[rowIndex];
            }
            return stringMap.values().toArray()[rowIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 3;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Map stringMap = TestStringWizardPanel.this.getStringMap();
            if (stringMap == null) {
                return;
            }
            if (columnIndex == 0 && value instanceof Boolean) {
                Object hardString = stringMap.keySet().toArray()[rowIndex];
                Set removedStrings = TestStringWizardPanel.this.getRemovedStrings();
                if (((Boolean)value).booleanValue()) {
                    removedStrings.remove(hardString);
                } else {
                    removedStrings.add(hardString);
                }
            }
            if (columnIndex == 3) {
                I18nString i18nString = (I18nString)TestStringWizardPanel.this.getStringMap().values().toArray()[rowIndex];
                i18nString.setValue(value.toString());
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TestStringWizardPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (columnIndex == 1) {
                return class$org$netbeans$modules$i18n$HardCodedString == null ? (class$org$netbeans$modules$i18n$HardCodedString = TestStringWizardPanel.class$("org.netbeans.modules.i18n.HardCodedString")) : class$org$netbeans$modules$i18n$HardCodedString;
            }
            return class$org$netbeans$modules$i18n$I18nString == null ? (class$org$netbeans$modules$i18n$I18nString = TestStringWizardPanel.class$("org.netbeans.modules.i18n.I18nString")) : class$org$netbeans$modules$i18n$I18nString;
        }

        public String getColumnName(int column) {
            if (column == 1) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel = TestStringWizardPanel.class$("org.netbeans.modules.i18n.wizard.HardStringWizardPanel")) : class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel)).getString("LBL_HardString");
            }
            if (column == 2) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel = TestStringWizardPanel.class$("org.netbeans.modules.i18n.wizard.HardStringWizardPanel")) : class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel)).getString("LBL_Key");
            }
            if (column == 3) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel = TestStringWizardPanel.class$("org.netbeans.modules.i18n.wizard.HardStringWizardPanel")) : class$org$netbeans$modules$i18n$wizard$HardStringWizardPanel)).getString("LBL_Value");
            }
            return " ";
        }
    }
}

