/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.util;

import com.sun.j2ee.blueprints.ui.util.AbstractUIComponentTag;
import com.sun.j2ee.blueprints.ui.util.ConstantMethodBinding;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;

public abstract class AbstractActionSourceUIComponentTag
extends AbstractUIComponentTag {
    private static final Class[] ACTION_SIGNATURE = null;
    private static final Class[] ACTION_LISTENER_SIGNATURE = new Class[]{ActionEvent.class};
    private String action = null;
    private String actionListener = null;
    private String immediate = null;

    public void setAction(String action) {
        this.action = action;
    }

    public void setActionListener(String actionListener) {
        this.actionListener = actionListener;
    }

    public void setImmediate(String immediate) {
        this.immediate = immediate;
    }

    public void release() {
        super.release();
        this.action = null;
        this.actionListener = null;
        this.immediate = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        this.configureAction(component, "action", this.action);
        this.configureActionListener(component, "actionListener", this.actionListener);
        this.configureBoolean(component, "immediate", this.immediate);
    }

    protected void configureAction(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (AbstractActionSourceUIComponentTag.isValueReference((String)value)) {
            MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(value, ACTION_SIGNATURE);
            ((ActionSource)component).setAction(mb);
        } else {
            ((ActionSource)component).setAction((MethodBinding)new ConstantMethodBinding(value));
        }
    }

    protected void configureActionListener(UIComponent component, String name, String value) {
        if (value == null) {
            return;
        }
        if (!AbstractActionSourceUIComponentTag.isValueReference((String)value)) {
            throw new IllegalArgumentException(value);
        }
        MethodBinding mb = this.getFacesContext().getApplication().createMethodBinding(value, ACTION_LISTENER_SIGNATURE);
        ((ActionSource)component).setActionListener(mb);
    }
}

