/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ConstructorClass;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldClass;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.InitializerClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaClassClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.bridge.ClassElementImpl;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.ImportElement;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class FeaturesCollection {
    private static final Element[] NO_ELEMENTS = new Element[0];
    static final Type[] NO_TYPES = new Type[0];
    ElementImpl parentImpl;
    ClassElement parentClass;
    MDRepository repository;
    JavaClass javaClass;
    Resource resource;
    DefaultLangModel model;
    JavaClassClass classProxy;
    FieldClass fieldProxy;
    MethodClass methodProxy;
    ConstructorClass constructorProxy;
    InitializerClass initializerProxy;
    ParameterClass parameterProxy;
    ImportClass importProxy;
    private Feature currentElement = null;
    private boolean insertBefore;

    public FeaturesCollection(ElementImpl parentImpl) {
        this.parentImpl = parentImpl;
        this.repository = parentImpl.repository;
        if (parentImpl instanceof ClassElementImpl) {
            this.javaClass = (JavaClass)parentImpl.getJavaElement();
            this.resource = this.javaClass.getResource();
        }
        this.model = parentImpl.getModelImpl();
        if (parentImpl.javaModelPackage != null) {
            try {
                this.classProxy = parentImpl.javaModelPackage.getJavaClass();
                this.fieldProxy = parentImpl.javaModelPackage.getField();
                this.methodProxy = parentImpl.javaModelPackage.getMethod();
                this.constructorProxy = parentImpl.javaModelPackage.getConstructor();
                this.initializerProxy = parentImpl.javaModelPackage.getInitializer();
                this.parameterProxy = parentImpl.javaModelPackage.getParameter();
                this.importProxy = parentImpl.javaModelPackage.getImport();
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    }

    public ClassElement getParentClass() {
        if (this.parentClass == null) {
            this.parentClass = (ClassElement)this.parentImpl.getElement();
        }
        return this.parentClass;
    }

    public List typesToDescriptors(Type[] types) {
        LinkedList<org.netbeans.jmi.javamodel.Type> result = new LinkedList<org.netbeans.jmi.javamodel.Type>();
        for (int x = 0; x < types.length; ++x) {
            result.add(this.parentImpl.typeToDescr(types[x]));
        }
        return result;
    }

    public List convertParameters(MethodParameter[] params) {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        for (int x = 0; x < params.length; ++x) {
            Type type;
            Parameter par = this.parameterProxy.createParameter(params[x].getName(), null, params[x].isFinal(), null, 0, false);
            Type t = type = params[x].getType();
            while (t.isArray()) {
                t = t.getElementType();
            }
            if (t.isPrimitive()) {
                par.setType(this.parentImpl.typeToDescr(type));
            } else {
                par.setTypeName(this.parentImpl.typeToTypeReference(type));
            }
            result.add(par);
        }
        return result;
    }

    public List convertIdentifiers(Identifier[] ids) {
        LinkedList<org.netbeans.jmi.javamodel.Type> result = new LinkedList<org.netbeans.jmi.javamodel.Type>();
        for (int x = 0; x < ids.length; ++x) {
            result.add(this.parentImpl.typeToDescr(Type.createClass((Identifier)ids[x])));
        }
        return result;
    }

    public JavaClass createClass(ClassElement cls) {
        String parentFqn;
        int x;
        ArrayList<Object> features = new ArrayList<Object>();
        FieldElement[] fields = cls.getFields();
        for (x = 0; x < fields.length; ++x) {
            features.add(this.createField(fields[x]));
        }
        InitializerElement[] initializers = cls.getInitializers();
        for (x = 0; x < initializers.length; ++x) {
            features.add(this.createInitializer(initializers[x]));
        }
        ConstructorElement[] constrs = cls.getConstructors();
        for (x = 0; x < constrs.length; ++x) {
            features.add(this.createConstructor(constrs[x]));
        }
        MethodElement[] methods = cls.getMethods();
        for (x = 0; x < methods.length; ++x) {
            features.add(this.createMethod(methods[x]));
        }
        ClassElement[] classes = cls.getClasses();
        for (x = 0; x < classes.length; ++x) {
            features.add(this.createClass(classes[x]));
        }
        String simpleName = cls.getName().getName();
        Identifier parentName = null;
        if (this.parentImpl instanceof ClassElementImpl) {
            parentName = ((ClassElementImpl)this.parentImpl).getName();
        } else {
            SourceElementImpl sei = (SourceElementImpl)this.parentImpl;
            parentName = sei.getPackage();
        }
        String fullName = simpleName;
        if (parentName != null && (parentFqn = parentName.getFullName()).length() > 0) {
            fullName = parentName + "." + simpleName;
        }
        Identifier className = Identifier.create((String)fullName, (String)simpleName);
        Identifier superclass = cls.getSuperclass();
        int modifier = cls.getModifiers();
        if (!cls.isClassOrInterface()) {
            modifier |= 0x200;
        }
        JavaClass res = this.classProxy.createJavaClass(className.getFullName(), null, modifier, cls.getJavaDoc().getRawText(), null, features, null, null, null);
        if (superclass != null) {
            res.setSuperClass((JavaClass)this.parentImpl.javaModelPackage.getType().resolve(superclass.getFullName()));
        }
        Identifier[] interfaces = cls.getInterfaces();
        ArrayList<MultipartId> inters = new ArrayList<MultipartId>(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            inters.add(this.parentImpl.javaModelPackage.getMultipartId().createMultipartId(interfaces[i].getFullName(), null, null));
        }
        res.getInterfaceNames().addAll(inters);
        return res;
    }

    public Method createMethod(MethodElement method) {
        Type retType;
        Method res = this.methodProxy.createMethod(method.getName().getName(), null, method.getModifiers(), method.getJavaDoc().getRawText(), null, null, method.getBody(), null, this.convertParameters(method.getParameters()), null, null, 0);
        Type t = retType = method.getReturn();
        while (t.isArray()) {
            t = t.getElementType();
        }
        if (t.isPrimitive()) {
            res.setType(this.parentImpl.typeToDescr(retType));
        } else {
            res.setTypeName(this.parentImpl.typeToTypeReference(retType));
        }
        Identifier[] exs = method.getExceptions();
        ArrayList<MultipartId> list = new ArrayList<MultipartId>(exs.length);
        for (int x = 0; x < exs.length; ++x) {
            String excName = exs[x].getSourceName();
            if (excName == null) {
                excName = exs[x].getFullName();
            }
            list.add(this.parentImpl.javaModelPackage.getMultipartId().createMultipartId(excName, null, null));
        }
        res.getExceptionNames().addAll(list);
        return res;
    }

    public Constructor createConstructor(ConstructorElement constr) {
        Constructor res = this.constructorProxy.createConstructor(null, null, constr.getModifiers(), constr.getJavaDoc().getRawText(), null, null, constr.getBody(), null, this.convertParameters(constr.getParameters()), null);
        Identifier[] exs = constr.getExceptions();
        ArrayList<MultipartId> list = new ArrayList<MultipartId>(exs.length);
        for (int x = 0; x < exs.length; ++x) {
            list.add(this.parentImpl.javaModelPackage.getMultipartId().createMultipartId(exs[x].getFullName(), null, null));
        }
        res.getExceptionNames().addAll(list);
        return res;
    }

    public Field createField(FieldElement field) {
        String initValue = field.getInitValue();
        if (initValue != null && initValue.length() == 0) {
            initValue = null;
        }
        Field res = this.fieldProxy.createField(field.getName().getName(), null, field.getModifiers(), field.getJavaDoc().getRawText(), null, (field.getModifiers() & 0x10) > 0, null, 0, null, initValue);
        res.setType(this.parentImpl.typeToDescr(field.getType()));
        return res;
    }

    public Initializer createInitializer(InitializerElement initializer) {
        JavaDoc javaDoc = initializer.getJavaDoc();
        Initializer res = this.initializerProxy.createInitializer("<clinit>", null, initializer.isStatic() ? 8 : 0, javaDoc != null ? javaDoc.getRawText() : null, null, null, initializer.getBody());
        return res;
    }

    public Import createImport(ImportElement elem) {
        org.openide.src.Import imp = elem.getImport();
        String name = imp.getIdentifier().getFullName();
        Import res = this.importProxy.createImport(name, null, false, imp.isPackage());
        return res;
    }
}

