/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.openide.src.MultiPropertyChangeEvent;

public abstract class IndexedPropertyBase {
    public static final int SMALL_THRESHOLD = 500;
    private String propertyName;

    public IndexedPropertyBase(String propName) {
        this.propertyName = propName;
    }

    public Change computeChanges(Object[] olds, Object[] newValue) {
        return IndexedPropertyBase.computeChanges2(olds, newValue, this.pairItems(olds, newValue));
    }

    public static Change computeChanges2(Object[] olds, Object[] newValue, int[] mapping) {
        int removeCount;
        int[] perm = new int[olds.length];
        int matched = 0;
        int inserted = 0;
        boolean removed = false;
        int reordered = 0;
        int[] insertIndices = null;
        int[] offsets = null;
        boolean oldIndex = false;
        for (int i = 0; i < mapping.length; ++i) {
            if (offsets != null && i - inserted < olds.length) {
                offsets[i - inserted] = inserted;
            }
            if (mapping[i] == -1) {
                if (insertIndices == null) {
                    offsets = new int[olds.length];
                    insertIndices = new int[mapping.length];
                }
                insertIndices[inserted] = i;
                ++inserted;
                continue;
            }
            perm[mapping[i]] = i + 1;
            ++matched;
        }
        if (inserted > 0 && mapping.length < olds.length) {
            Arrays.fill(offsets, mapping.length, olds.length - 1, inserted);
        }
        removed = (removeCount = perm.length - matched) > 0;
        Change ch = new Change();
        int eventCount = 0;
        Object removeEvent = null;
        Object addEvent = null;
        Object reorderEvent = null;
        if (removed) {
            ArrayList<Object> rem = new ArrayList<Object>(perm.length - matched);
            int bias = 0;
            boolean reorderIndex = false;
            int removedSoFar = 0;
            int[] indices = new int[removeCount];
            int indicePos = 0;
            boolean diff = false;
            if (offsets == null) {
                offsets = new int[olds.length];
            }
            for (int i = 0; i < perm.length; ++i) {
                if (perm[i] == 0) {
                    --bias;
                    indices[indicePos++] = i;
                    rem.add(olds[i]);
                    ++removedSoFar;
                    offsets[i] = -i - 1;
                    continue;
                }
                int n = i;
                offsets[n] = offsets[n] + bias;
            }
            ch.removed = rem;
            ch.removeIndices = indices;
            ++eventCount;
        }
        boolean insertPos = true;
        int nextInsert = insertIndices == null ? -1 : insertIndices[0];
        boolean pos = false;
        reordered = 0;
        boolean j = false;
        for (int i = 0; i < perm.length; ++i) {
            if (perm[i] == 0) {
                perm[i] = -1;
                continue;
            }
            int newPlace = perm[i] - 1;
            int expectedPlace = i;
            if (offsets != null) {
                expectedPlace += offsets[i];
            }
            if (newPlace != expectedPlace) {
                ++reordered;
                perm[i] = newPlace;
                continue;
            }
            perm[i] = -1;
        }
        if (reordered > 0) {
            ch.reordered = perm;
            ++eventCount;
        }
        if (inserted > 0) {
            ArrayList<Object> col = new ArrayList<Object>(inserted);
            int[] indices = new int[inserted];
            System.arraycopy(insertIndices, 0, indices, 0, inserted);
            for (int i = 0; i < indices.length; ++i) {
                col.add(newValue[insertIndices[i]]);
            }
            ch.inserted = col;
            ch.insertIndices = indices;
            ++eventCount;
        }
        ch.offsets = offsets;
        ch.phaseCount = eventCount;
        ch.sizeDiff = inserted - removeCount;
        return ch;
    }

    public MultiPropertyChangeEvent createPropertyEvent(Change ch, Object source, Object oldV, Object newV) {
        if (ch.phaseCount == 0) {
            return null;
        }
        MultiPropertyChangeEvent evt = null;
        boolean compound = ch.phaseCount > 1;
        ArrayList<MultiPropertyChangeEvent> sub = null;
        newV = ((Object[])newV).clone();
        if (compound) {
            sub = new ArrayList<MultiPropertyChangeEvent>(ch.phaseCount);
        }
        if (ch.inserted != null) {
            evt = this.createInsertionEvent(source, oldV, newV, ch.inserted, ch.insertIndices);
            if (compound) {
                sub.add(evt);
            }
        }
        if (ch.removed != null) {
            evt = this.createRemovalEvent(source, oldV, newV, ch.removed, ch.removeIndices);
            if (compound) {
                sub.add(evt);
            }
        }
        if (ch.reordered != null) {
            evt = this.createReorderEvent(source, oldV, newV, ch.reordered);
            if (compound) {
                sub.add(evt);
            }
        }
        if (compound) {
            return this.createCompoundEvent(source, sub, ch.offsets, oldV, newV);
        }
        return evt;
    }

    public MultiPropertyChangeEvent createChangeEvent(Object source, Object[] olds, Object[] newValue) {
        Change ch = this.computeChanges(olds, newValue);
        return this.createPropertyEvent(ch, source, olds, newValue);
    }

    protected MultiPropertyChangeEvent createInsertionEvent(Object source, Object previous, Object now, Collection inserted, int[] indices) {
        MultiPropertyChangeEvent insertEvent = new MultiPropertyChangeEvent(source, this.getPropertyName(), previous, now);
        insertEvent.makeInsertion(inserted, indices);
        return insertEvent;
    }

    protected MultiPropertyChangeEvent createRemovalEvent(Object source, Object prev, Object now, Collection removed, int[] indices) {
        MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent(source, this.getPropertyName(), prev, now);
        evt.makeRemoval(removed, indices);
        return evt;
    }

    protected MultiPropertyChangeEvent createModifyEvent(Object source, Object prev, Object now, Collection origs, Collection replacements, int[] indices) {
        MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent(source, this.getPropertyName(), prev, now);
        evt.makeReplacement(origs, replacements, indices);
        return evt;
    }

    protected MultiPropertyChangeEvent createCompoundEvent(Object source, Collection subEvents, int[] offsets, Object old, Object newValue) {
        MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent(source, this.getPropertyName(), old, newValue);
        evt.makeCompound(subEvents, offsets);
        return evt;
    }

    protected MultiPropertyChangeEvent createReorderEvent(Object source, Object old, Object now, int[] perm) {
        MultiPropertyChangeEvent evt = new MultiPropertyChangeEvent(source, this.getPropertyName(), old, now);
        evt.makeReorder(perm);
        return evt;
    }

    public int[] pairItems(Object[] o, Object[] n) {
        int[] map = new int[n.length];
        boolean[] used = new boolean[o.length];
        for (int i = 0; i < n.length; ++i) {
            map[i] = -1;
            for (int j = 0; j < o.length; ++j) {
                if (used[j] || o[j] != n[i] && !this.compareValues(o[j], n[i])) continue;
                used[j] = true;
                map[i] = j;
            }
        }
        return map;
    }

    protected int[] createIdentityMap(Object[] els, Object[] olds) {
        int avgOps = els.length * olds.length;
        if (avgOps < 500) {
            return this.pairItems(olds, els);
        }
        HashMap<Object, Integer> indexM = new HashMap<Object, Integer>((int)((double)olds.length * 1.3));
        int[] mapping = new int[els.length];
        for (int idx = 0; idx < olds.length; ++idx) {
            indexM.put(olds[idx], new Integer(idx));
        }
        for (int i = 0; i < els.length; ++i) {
            Integer pos = (Integer)indexM.get(els[i]);
            mapping[i] = pos == null ? -1 : pos;
        }
        return mapping;
    }

    protected boolean compareValues(Object o1, Object o2) {
        return false;
    }

    protected Object getSource(ElementImpl key) {
        return key.getElement();
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    public static class Change {
        public Collection removed;
        public int[] removeIndices;
        public int[] reordered;
        public Collection inserted;
        public int[] insertIndices;
        public Collection replacements;
        public int[] replaceIndices;
        public int[] offsets;
        public int phaseCount;
        public int[] mapping;
        public int sizeDiff;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.removed != null) {
                sb.append("removed(" + this.removed.size() + ")");
            }
            if (this.reordered != null) {
                sb.append(" reordered ");
            }
            if (this.inserted != null) {
                sb.append("inserted(" + this.inserted.size() + ")");
            }
            if (this.replacements != null) {
                sb.append("replaced(" + this.replacements.size() + ")");
            }
            sb.append("sizedif=" + this.sizeDiff);
            return sb.toString();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

