/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class SuiteProjectGenerator {
    private static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuiteProjectGenerator() {
    }

    public static void createSuiteProject(final File projectDir, final String platformID) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject dirFO = SuiteProjectGenerator.createProjectDir(projectDir);
                    if (ProjectManager.getDefault().findProject(dirFO) != null) {
                        throw new IllegalArgumentException("Already a project in " + dirFO);
                    }
                    SuiteProjectGenerator.createSuiteProjectXML(dirFO);
                    SuiteProjectGenerator.createPlatformProperties(dirFO, platformID);
                    SuiteProjectGenerator.createProjectProperties(dirFO);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static void createSuiteProjectXML(FileObject projectDir) throws IOException {
        ProjectXMLManager.generateEmptySuiteTemplate(SuiteProjectGenerator.createFileObject(projectDir, "nbproject/project.xml"), projectDir.getNameExt());
    }

    private static void createPlatformProperties(FileObject projectDir, String platformID) throws IOException {
        FileObject plafPropsFO = SuiteProjectGenerator.createFileObject(projectDir, PLATFORM_PROPERTIES_PATH);
        EditableProperties props = new EditableProperties(true);
        props.setProperty("nbplatform.active", platformID);
        SuiteProjectGenerator.storeProperties(plafPropsFO, props);
    }

    private static void createProjectProperties(FileObject projectDir) throws IOException {
        FileObject propsFO = SuiteProjectGenerator.createFileObject(projectDir, PROJECT_PROPERTIES_PATH);
        EditableProperties props = new EditableProperties(true);
        props.setProperty("modules", "");
        SuiteProjectGenerator.storeProperties(propsFO, props);
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        FileObject dirFO;
        if (!dir.exists()) {
            SuiteProjectGenerator.refreshFolder(dir);
            if (!dir.mkdirs()) {
                throw new IOException("Can not create project folder \"" + dir.getAbsolutePath() + "\"");
            }
            SuiteProjectGenerator.refreshFileSystem(dir);
        }
        if ((dirFO = FileUtil.toFileObject((File)dir)) == null) {
            throw new IOException("No such dir on disk: " + dir);
        }
        if (!$assertionsDisabled && !dirFO.isFolder()) {
            throw new AssertionError((Object)("Not really a dir: " + dir));
        }
        return dirFO;
    }

    private static void refreshFolder(File dir) {
        while (!dir.exists()) {
            if ((dir = dir.getParentFile()) != null) continue;
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)dir);
        if (fo != null) {
            fo.refresh(false);
        }
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File root = dir;
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        FileObject rootFO = FileUtil.toFileObject((File)root);
        if (rootFO != null) {
            rootFO.getFileSystem().refresh(false);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("At least disk roots must be mounted! " + root));
            }
            ErrorManager.getDefault().log(16, "Cannot resolvefile object for " + root.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(FileObject bundleFO, EditableProperties props) throws IOException {
        FileLock lock = bundleFO.lock();
        try {
            OutputStream os = bundleFO.getOutputStream(lock);
            try {
                props.store(os);
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private static FileObject createFileObject(FileObject dir, String relToDir) throws IOException {
        FileObject createdFO = dir.getFileObject(relToDir);
        if (createdFO != null) {
            throw new IllegalArgumentException("File " + createdFO + " already exists.");
        }
        createdFO = FileUtil.createData((FileObject)dir, (String)relToDir);
        return createdFO;
    }

    static {
        $assertionsDisabled = !SuiteProjectGenerator.class.desiredAssertionStatus();
    }
}

