/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LocalePanel
extends JPanel {
    private Locale locale;
    public static final String PROP_CUSTOMIZED_LOCALE = "customized_locale";
    private static final Locale[] supportedLocales = new Locale[]{new Locale("ar", "AE", ""), new Locale("ar", "BH", ""), new Locale("ar", "DZ", ""), new Locale("ar", "EG", ""), new Locale("ar", "IQ", ""), new Locale("ar", "JO", ""), new Locale("ar", "KW", ""), new Locale("ar", "LB", ""), new Locale("ar", "LY", ""), new Locale("ar", "MA", ""), new Locale("ar", "OM", ""), new Locale("ar", "QA", ""), new Locale("ar", "SA", ""), new Locale("ar", "SD", ""), new Locale("ar", "SY", ""), new Locale("ar", "TN", ""), new Locale("ar", "YE", ""), new Locale("be", "BY", ""), new Locale("bg", "BG", ""), new Locale("ca", "ES", ""), new Locale("cs", "CZ", ""), new Locale("da", "DK", ""), new Locale("de", "AT", ""), new Locale("de", "AT", "EURO"), new Locale("de", "CH", ""), new Locale("de", "DE", ""), new Locale("de", "DE", "EURO"), new Locale("de", "LU", ""), new Locale("de", "LU", "EURO"), new Locale("el", "GR", ""), new Locale("en", "AU", ""), new Locale("en", "CA", ""), new Locale("en", "GB", ""), new Locale("en", "IE", ""), new Locale("en", "IE", "EURO"), new Locale("en", "NZ", ""), new Locale("en", "US", ""), new Locale("en", "ZA", ""), new Locale("es", "AR", ""), new Locale("es", "BO", ""), new Locale("es", "CL", ""), new Locale("es", "CO", ""), new Locale("es", "CR", ""), new Locale("es", "DO", ""), new Locale("es", "EC", ""), new Locale("es", "ES", ""), new Locale("es", "ES", "EURO"), new Locale("es", "GT", ""), new Locale("es", "HN", ""), new Locale("es", "MX", ""), new Locale("es", "NI", ""), new Locale("es", "PA", ""), new Locale("es", "PE", ""), new Locale("es", "PR", ""), new Locale("es", "PY", ""), new Locale("es", "SV", ""), new Locale("es", "UY", ""), new Locale("es", "VE", ""), new Locale("et", "EE", ""), new Locale("fi", "FI", ""), new Locale("fi", "FI", "EURO"), new Locale("fr", "BE", ""), new Locale("fr", "BE", "EURO"), new Locale("fr", "CA", ""), new Locale("fr", "CH", ""), new Locale("fr", "FR", ""), new Locale("fr", "FR", "EURO"), new Locale("fr", "LU", ""), new Locale("fr", "LU", "EURO"), new Locale("hr", "HR", ""), new Locale("hu", "HU", ""), new Locale("is", "IS", ""), new Locale("it", "CH", ""), new Locale("it", "IT", ""), new Locale("it", "IT", "EURO"), new Locale("iw", "IL", ""), new Locale("ja", "JP", ""), new Locale("ko", "KR", ""), new Locale("lt", "LT", ""), new Locale("lv", "LV", ""), new Locale("mk", "MK", ""), new Locale("nl", "BE", ""), new Locale("nl", "BE", "EURO"), new Locale("nl", "NL", ""), new Locale("nl", "NL", "EURO"), new Locale("no", "NO", ""), new Locale("no", "NO", "B"), new Locale("pl", "PL", ""), new Locale("pt", "BR", ""), new Locale("pt", "PT", ""), new Locale("pt", "PT", "EURO"), new Locale("ro", "RO", ""), new Locale("ru", "RU", ""), new Locale("sh", "YU", ""), new Locale("sk", "SK", ""), new Locale("sl", "SI", ""), new Locale("sq", "AL", ""), new Locale("sr", "YU", ""), new Locale("sv", "SE", ""), new Locale("th", "TH", ""), new Locale("tr", "TR", ""), new Locale("uk", "UA", ""), new Locale("vi", "VN", ""), new Locale("zh", "CN", ""), new Locale("zh", "HK", ""), new Locale("zh", "TW", "")};
    private JLabel variantLabel;
    private JTextField localeText;
    private JComboBox countryCombo;
    private JComboBox languageCombo;
    private JLabel countryLabel;
    private JLabel supportedLabel;
    private JList supportedList;
    private JLabel languageLabel;
    private JComboBox variantCombo;
    private JScrollPane jScrollPane1;
    private JLabel localeLabel;

    public LocalePanel() {
        this(new Locale("", "", ""));
    }

    public LocalePanel(Locale locale) {
        this.locale = locale;
        this.initComponents();
        this.initAccessibility();
        this.languageCombo.setSelectedItem(locale.getLanguage());
        this.countryCombo.setSelectedItem(locale.getCountry());
        this.variantCombo.setSelectedItem(locale.getVariant());
        this.localeText.setText(locale.toString());
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.addlocale");
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_LocalePanel"));
        this.localeText.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_CTL_LocaleText"));
        this.localeText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_CTL_LocaleText"));
        this.countryCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_CTL_CountryCombo"));
        this.languageCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_CTL_LanguageCombo"));
        this.supportedList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_CTL_SupportedList"));
        this.variantCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)LocalePanel.class).getString("ACS_CTL_VariantCombo"));
    }

    private void initComponents() {
        this.languageLabel = new JLabel();
        this.languageLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_LanguageCode_Mnem").charAt(0));
        this.languageCombo = new JComboBox<String>(Locale.getISOLanguages());
        this.countryLabel = new JLabel();
        this.countryLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_CountryCode_Mnem").charAt(0));
        this.countryCombo = new JComboBox<String>(Locale.getISOCountries());
        this.variantLabel = new JLabel();
        this.variantLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_Variant_Mnem").charAt(0));
        this.variantCombo = new JComboBox<String>(new String[]{"B", "EURO", "NY"});
        this.supportedLabel = new JLabel();
        this.supportedLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_SupportedLocales_Mnem").charAt(0));
        this.jScrollPane1 = new JScrollPane();
        this.supportedList = new JList<Locale>(supportedLocales);
        this.localeLabel = new JLabel();
        this.localeLabel.setDisplayedMnemonic(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_LocaleLabel_Mnem").charAt(0));
        this.localeText = new JTextField();
        this.setLayout(new GridBagLayout());
        this.languageLabel.setLabelFor(this.languageCombo);
        this.languageLabel.setText(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_LanguageCode"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.languageLabel, gridBagConstraints);
        this.languageCombo.setEditable(true);
        this.languageCombo.setRenderer(new BasicComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if ("".equals(value.toString())) {
                    label.setText("");
                } else {
                    label.setText(value.toString() + " - " + new Locale((String)value, "", "").getDisplayLanguage());
                }
                return label;
            }
        });
        this.languageCombo.insertItemAt("", 0);
        this.languageCombo.setSelectedIndex(0);
        this.languageCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalePanel.this.languageComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.languageCombo, gridBagConstraints);
        this.countryLabel.setLabelFor(this.countryCombo);
        this.countryLabel.setText(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_CountryCode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.countryLabel, gridBagConstraints);
        this.countryCombo.setEditable(true);
        this.countryCombo.setRenderer(new BasicComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if ("".equals(value.toString())) {
                    label.setText("");
                } else {
                    label.setText(value.toString() + " - " + new Locale("", (String)value, "").getDisplayCountry());
                }
                return label;
            }
        });
        this.countryCombo.insertItemAt("", 0);
        this.countryCombo.setSelectedIndex(0);
        this.countryCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalePanel.this.countryComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.countryCombo, gridBagConstraints);
        this.variantLabel.setLabelFor(this.variantCombo);
        this.variantLabel.setText(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_Variant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.variantLabel, gridBagConstraints);
        this.variantCombo.setEditable(true);
        this.variantCombo.setRenderer(new BasicComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if ("".equals(value.toString())) {
                    label.setText("");
                } else {
                    label.setText(value.toString() + " - " + new Locale("", "", (String)value).getDisplayVariant());
                }
                return label;
            }
        });
        this.variantCombo.insertItemAt("", 0);
        this.variantCombo.setSelectedIndex(0);
        this.variantCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocalePanel.this.variantComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.variantCombo, gridBagConstraints);
        this.supportedLabel.setLabelFor(this.supportedList);
        this.supportedLabel.setText(NbBundle.getBundle((Class)LocalePanel.class).getString("CTL_SupportedLocales"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 12, 0, 11);
        this.add((Component)this.supportedLabel, gridBagConstraints);
        this.supportedList.setSelectionMode(0);
        this.supportedList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Locale locale = (Locale)value;
                label.setText(locale.toString() + (locale.getLanguage().equals("") ? "" : " - " + locale.getDisplayLanguage()) + (locale.getCountry().equals("") ? "" : " / " + locale.getDisplayCountry()) + (locale.getVariant().equals("") ? "" : " / " + locale.getDisplayVariant()));
                return label;
            }
        });
        this.supportedList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LocalePanel.this.supportedListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.supportedList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 11, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.localeLabel.setLabelFor(this.localeText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.localeLabel, gridBagConstraints);
        this.localeText.setEditable(false);
        this.localeText.setText("jTextField1");
        this.localeText.selectAll();
        this.localeText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LocalePanel.this.localeTextFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.localeText, gridBagConstraints);
    }

    private void localeTextFocusGained(FocusEvent evt) {
        this.localeText.selectAll();
    }

    private void supportedListValueChanged(ListSelectionEvent evt) {
        Locale selectedLocale = (Locale)this.supportedList.getSelectedValue();
        if (selectedLocale != null) {
            this.languageCombo.setSelectedItem(selectedLocale.getLanguage());
            this.countryCombo.setSelectedItem(selectedLocale.getCountry());
            this.variantCombo.setSelectedItem(selectedLocale.getVariant());
        }
        this.supportedList.ensureIndexIsVisible(this.supportedList.getSelectedIndex());
    }

    private void variantComboActionPerformed(ActionEvent evt) {
        this.comboHandler(evt);
    }

    private void countryComboActionPerformed(ActionEvent evt) {
        this.comboHandler(evt);
    }

    private void languageComboActionPerformed(ActionEvent evt) {
        this.comboHandler(evt);
    }

    private void comboHandler(ActionEvent evt) {
        String str = (String)((JComboBox)evt.getSource()).getSelectedItem();
        Locale oldLocale = this.locale;
        Object source = evt.getSource();
        if (source.equals(this.languageCombo)) {
            if (str.equals(this.locale.getLanguage())) {
                return;
            }
            this.locale = new Locale(str, this.locale.getCountry(), this.locale.getVariant());
        } else if (source.equals(this.countryCombo)) {
            if (str.equals(this.locale.getCountry())) {
                return;
            }
            this.locale = new Locale(this.locale.getLanguage(), str, this.locale.getVariant());
        } else if (source.equals(this.variantCombo)) {
            if (str.equals(this.locale.getVariant())) {
                return;
            }
            this.locale = new Locale(this.locale.getLanguage(), this.locale.getCountry(), str);
        }
        this.localeText.setText(this.locale.toString());
        this.firePropertyChange(PROP_CUSTOMIZED_LOCALE, oldLocale, this.locale);
    }
}

