/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

class PropertiesParser {
    PropertiesFileEntry pfe;
    PropertiesEditorSupport editor;
    PropertiesReader propertiesReader;
    private boolean stop = false;

    public PropertiesParser(PropertiesFileEntry pfe) {
        this.pfe = pfe;
    }

    void initParser() throws IOException {
        this.editor = this.pfe.getPropertiesEditor();
        this.propertiesReader = this.createReader();
    }

    private PropertiesReader createReader() throws IOException {
        StyledDocument loadDoc = null;
        if (this.editor.isDocumentLoaded()) {
            loadDoc = this.editor.getDocument();
        }
        if (loadDoc == null) {
            loadDoc = this.editor.openDocument();
        }
        final StyledDocument document = loadDoc;
        final String[] str = new String[1];
        document.render(new Runnable(){

            public void run() {
                try {
                    str[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
        return new PropertiesReader(str[0]);
    }

    public PropertiesStructure parseFile() {
        try {
            PropertiesStructure propStructure = this.parseFileMain();
            return propStructure;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void stop() {
        this.stop = true;
        this.clean();
    }

    public void clean() {
        if (this.propertiesReader != null) {
            try {
                this.propertiesReader.close();
                this.propertiesReader = null;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
        }
    }

    private PropertiesStructure parseFileMain() throws IOException {
        HashMap<String, Element.ItemElem> items = new HashMap<String, Element.ItemElem>(25, 1.0f);
        PropertiesReader reader = null;
        while (true) {
            if (this.stop) {
                return null;
            }
            reader = this.propertiesReader;
            if (reader == null) {
                return null;
            }
            Element.ItemElem element = this.readNextElem(reader);
            if (element == null) break;
            items.put(element.getKey(), element);
        }
        return new PropertiesStructure(this.createBiasBounds(0L, reader.position), items);
    }

    private Element.ItemElem readNextElem(PropertiesReader in) throws IOException {
        Element.ValueElem valueE;
        Element.KeyElem keyE;
        int begPos;
        int keyPos = begPos = in.position;
        FlaggedLine fl = in.readLineExpectComment();
        StringBuffer comment = new StringBuffer();
        boolean firstNull = true;
        while (fl != null) {
            firstNull = false;
            if (!fl.flag) break;
            comment.append(this.trimComment(fl.line));
            comment.append(fl.lineSep);
            keyPos = in.position;
            fl = in.readLineExpectComment();
        }
        if (firstNull) {
            return null;
        }
        String comHelp = comment.toString();
        if (comment.length() > 0 && comment.charAt(comment.length() - 1) == '\n') {
            comHelp = comment.substring(0, comment.length() - 1);
        }
        Element.CommentElem commE = new Element.CommentElem(this.createBiasBounds(begPos, keyPos), UtilConvert.loadConvert(comHelp));
        if (fl == null) {
            keyE = null;
            valueE = null;
        } else {
            String value;
            int valueIndex;
            int separatorIndex;
            int keyStart;
            ArrayList<FlaggedLine> lines = new ArrayList<FlaggedLine>(2);
            fl.startPosition = keyPos;
            fl.stringValue = fl.line.toString();
            lines.add(fl);
            while (PropertiesParser.isPartialLine(fl.line)) {
                fl.stringValue = fl.stringValue.substring(0, fl.stringValue.length() - 1);
                int nowPos = in.position;
                fl = in.readLineNoFrills();
                if (fl == null) break;
                int startIndex = 0;
                for (startIndex = 0; startIndex < fl.line.length() && " \t\r\n\f".indexOf(fl.line.charAt(startIndex)) != -1; ++startIndex) {
                }
                fl.stringValue = fl.line.substring(startIndex, fl.line.length());
                fl.startPosition = nowPos + startIndex;
                lines.add(fl);
            }
            PositionMap positionMap = new PositionMap(lines);
            String line = positionMap.getString();
            int len = line.length();
            for (keyStart = 0; keyStart < len && " \t\r\n\f".indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if ("=: \t\r\n\f".indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && " \t\r\n\f".indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && "=:".indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && " \t\r\n\f".indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String string = value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            if (key == null) {
                // empty if block
            }
            int currentPos = in.position;
            int valuePosFile = 0;
            try {
                valuePosFile = positionMap.getFilePosition(valueIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                valuePosFile = currentPos;
            }
            keyE = new Element.KeyElem(this.createBiasBounds(keyPos, valuePosFile), UtilConvert.loadConvert(key));
            valueE = new Element.ValueElem(this.createBiasBounds(valuePosFile, currentPos), UtilConvert.loadConvert(value));
        }
        return new Element.ItemElem(this.createBiasBounds(begPos, in.position), keyE, valueE, commE);
    }

    private StringBuffer trimComment(StringBuffer line) {
        char lead;
        while (line.length() > 0 && ((lead = line.charAt(0)) == '#' || lead == '!')) {
            line.deleteCharAt(0);
        }
        return line;
    }

    private static int position(long p) {
        return (int)(p & 0xFFFFFFFFL);
    }

    private PositionBounds createBiasBounds(long begin, long end) {
        PositionRef posBegin = this.editor.createPositionRef(PropertiesParser.position(begin), Position.Bias.Forward);
        PositionRef posEnd = this.editor.createPositionRef(PropertiesParser.position(end), Position.Bias.Backward);
        return new PositionBounds(posBegin, posEnd);
    }

    private static boolean isPartialLine(StringBuffer line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private static class FlaggedLine {
        StringBuffer line = new StringBuffer();
        boolean flag = false;
        String lineSep = "\n";
        int startPosition = 0;
        String stringValue;

        FlaggedLine() {
        }
    }

    private static class PositionMap {
        private ArrayList list;

        PositionMap(ArrayList lines) {
            this.list = lines;
        }

        public String getString() {
            String allLines = ((FlaggedLine)this.list.get((int)0)).stringValue;
            for (int part = 1; part < this.list.size(); ++part) {
                allLines = allLines + ((FlaggedLine)this.list.get((int)part)).stringValue;
            }
            return allLines;
        }

        public int getFilePosition(int posString) throws ArrayIndexOutOfBoundsException {
            int part;
            int lengthSoFar = 0;
            int lastLengthSoFar = 0;
            for (part = 0; part < this.list.size(); ++part) {
                lastLengthSoFar = lengthSoFar;
                if (part == this.list.size() - 1 ? lengthSoFar >= posString : (lengthSoFar += ((FlaggedLine)this.list.get((int)part)).stringValue.length()) > posString) break;
            }
            if (posString > lengthSoFar) {
                throw new ArrayIndexOutOfBoundsException("not in scope");
            }
            return ((FlaggedLine)this.list.get((int)part)).startPosition + posString - lastLengthSoFar;
        }
    }

    private static class PropertiesReader
    extends BufferedReader {
        private static final String LINE_SEPARATOR = "line.separator";
        private int peekChar = -1;
        public int position = 0;

        private PropertiesReader(String buffer) {
            super(new StringReader(buffer));
        }

        private PropertiesReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int character = this.peek();
            this.peekChar = -1;
            if (character != -1) {
                ++this.position;
            }
            return character;
        }

        private int peek() throws IOException {
            if (this.peekChar == -1) {
                this.peekChar = super.read();
            }
            return this.peekChar;
        }

        public FlaggedLine readLineExpectComment() throws IOException {
            int charRead = this.read();
            if (charRead == -1) {
                return null;
            }
            boolean decided = false;
            FlaggedLine fl = new FlaggedLine();
            while (charRead != -1 && charRead != 10 && charRead != 13) {
                if (!decided && " \t\r\n\f".indexOf((char)charRead) == -1) {
                    fl.flag = (char)charRead == '!' || (char)charRead == '#';
                    decided = true;
                }
                fl.line.append((char)charRead);
                charRead = this.read();
            }
            if (!decided) {
                fl.flag = true;
            }
            if (charRead == 13) {
                if (this.peek() == 10) {
                    charRead = this.read();
                    fl.lineSep = "\r\n";
                } else {
                    fl.lineSep = "\r";
                }
            } else {
                fl.lineSep = charRead == 10 ? "\n" : System.getProperty(LINE_SEPARATOR);
            }
            return fl;
        }

        public FlaggedLine readLineNoFrills() throws IOException {
            int charRead = this.read();
            if (charRead == -1) {
                return null;
            }
            FlaggedLine fl = new FlaggedLine();
            while (charRead != -1 && charRead != 10 && charRead != 13) {
                fl.line.append((char)charRead);
                charRead = this.read();
            }
            if (charRead == 13) {
                if (this.peek() == 10) {
                    charRead = this.read();
                    fl.lineSep = "\r\n";
                } else {
                    fl.lineSep = "\r";
                }
            } else {
                fl.lineSep = charRead == 10 ? "\n" : System.getProperty(LINE_SEPARATOR);
            }
            return fl;
        }
    }
}

