/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;

public class GapList
extends AbstractList
implements RandomAccess,
Cloneable,
Serializable {
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private transient Object[] elementData;
    private int gapStart;
    private int gapLength;

    public GapList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
        this.gapLength = initialCapacity;
    }

    public GapList() {
        this.elementData = EMPTY_ELEMENT_ARRAY;
    }

    public GapList(Collection c) {
        int size = c.size();
        this.elementData = new Object[(int)Math.min((long)size * 110L / 100L, Integer.MAX_VALUE)];
        c.toArray(this.elementData);
        this.gapStart = size;
        this.gapLength = this.elementData.length - size;
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.gapLength > 0) {
            int newLength = this.elementData.length - this.gapLength;
            Object[] newElementData = new Object[newLength];
            this.copyAllData(newElementData);
            this.elementData = newElementData;
            this.gapLength = 0;
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int gapEnd = this.gapStart + this.gapLength;
            int afterGapLength = oldCapacity - gapEnd;
            int newGapEnd = newCapacity - afterGapLength;
            Object[] newElementData = new Object[newCapacity];
            System.arraycopy(this.elementData, 0, newElementData, 0, this.gapStart);
            System.arraycopy(this.elementData, gapEnd, newElementData, newGapEnd, afterGapLength);
            this.elementData = newElementData;
            this.gapLength = newGapEnd - this.gapStart;
        }
    }

    public int size() {
        return this.elementData.length - this.gapLength;
    }

    public boolean isEmpty() {
        return this.elementData.length == this.gapLength;
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            int i;
            for (i = 0; i < this.gapStart; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            i += this.gapLength;
            int elementDataLength = this.elementData.length;
            while (i < elementDataLength) {
                if (this.elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i;
            for (i = 0; i < this.gapStart; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
            i += this.gapLength;
            int elementDataLength = this.elementData.length;
            while (i < elementDataLength) {
                if (elem.equals(this.elementData[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        if (elem == null) {
            int i;
            int gapEnd = this.gapStart + this.gapLength;
            for (i = this.elementData.length - 1; i >= gapEnd; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            i -= this.gapLength;
            while (i >= 0) {
                if (this.elementData[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i;
            int gapEnd = this.gapStart + this.gapLength;
            for (i = this.elementData.length - 1; i >= gapEnd; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
            i -= this.gapLength;
            while (i >= 0) {
                if (elem.equals(this.elementData[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            GapList clonedList = (GapList)super.clone();
            int size = this.size();
            Object[] clonedElementData = new Object[size];
            this.copyAllData(clonedElementData);
            clonedList.elementData = clonedElementData;
            clonedList.gapStart = size;
            clonedList.resetModCount();
            return clonedList;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void copyItems(int srcStartIndex, int srcEndIndex, Object[] dest, int destIndex) {
        if (srcStartIndex < 0 || srcEndIndex < srcStartIndex || srcEndIndex > this.size()) {
            throw new IndexOutOfBoundsException("srcStartIndex=" + srcStartIndex + ", srcEndIndex=" + srcEndIndex + ", size()=" + this.size());
        }
        if (srcEndIndex < this.gapStart) {
            System.arraycopy(this.elementData, srcStartIndex, dest, destIndex, srcEndIndex - srcStartIndex);
        } else if (srcStartIndex >= this.gapStart) {
            System.arraycopy(this.elementData, srcStartIndex + this.gapLength, dest, destIndex, srcEndIndex - srcStartIndex);
        } else {
            int beforeGap = this.gapStart - srcStartIndex;
            System.arraycopy(this.elementData, srcStartIndex, dest, destIndex, beforeGap);
            System.arraycopy(this.elementData, this.gapStart + this.gapLength, dest, destIndex + beforeGap, srcEndIndex - srcStartIndex - beforeGap);
        }
    }

    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        this.copyAllData(result);
        return result;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        this.copyAllData(a);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public Object get(int index) {
        return this.elementData[index < this.gapStart ? index : index + this.gapLength];
    }

    public Object set(int index, Object element) {
        if (index >= this.gapStart) {
            index += this.gapLength;
        }
        Object oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public void add(int index, Object element) {
        int size = this.size();
        if (index > size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        this.ensureCapacity(size + 1);
        this.moveGap(index);
        this.elementData[this.gapStart++] = element;
        --this.gapLength;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(int index, Collection c) {
        return this.addArray(index, c.toArray());
    }

    public boolean addArray(int index, Object[] elements) {
        return this.addArray(index, elements, 0, elements.length);
    }

    public boolean addArray(int index, Object[] elements, int off, int len) {
        int size = this.size();
        if (index > size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        this.ensureCapacity(size + len);
        this.moveGap(index);
        System.arraycopy(elements, off, this.elementData, this.gapStart, len);
        this.gapStart += len;
        this.gapLength -= len;
        return len != 0;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public Object remove(int index) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new IndexOutOfBoundsException("remove(): Index: " + index + ", Size: " + size);
        }
        ++this.modCount;
        this.moveGap(index + 1);
        Object oldValue = this.elementData[index];
        this.removeUpdate(index, this.elementData, index, index + 1);
        this.elementData[index] = null;
        --this.gapStart;
        ++this.gapLength;
        return oldValue;
    }

    public void remove(int index, int count) {
        int toIndex = index + count;
        if (index < 0 || toIndex < index || toIndex > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", count=" + count + ", size()=" + this.size());
        }
        this.removeRange(index, toIndex);
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        if (fromIndex == toIndex) {
            return;
        }
        int removeCount = toIndex - fromIndex;
        if (fromIndex >= this.gapStart) {
            this.moveGap(fromIndex);
            this.removeUpdate((fromIndex += this.gapLength) - this.gapLength, this.elementData, fromIndex, toIndex += this.gapLength);
            while (fromIndex < toIndex) {
                this.elementData[fromIndex] = null;
                ++fromIndex;
            }
        } else {
            if (toIndex <= this.gapStart) {
                this.moveGap(toIndex);
                this.gapStart = fromIndex;
                this.removeUpdate(fromIndex, this.elementData, fromIndex, toIndex);
            } else {
                this.removeUpdate(fromIndex, this.elementData, fromIndex, this.gapStart);
                for (int clearIndex = fromIndex; clearIndex < this.gapStart; ++clearIndex) {
                    this.elementData[clearIndex] = null;
                }
                fromIndex = this.gapStart + this.gapLength;
                this.gapStart = toIndex - removeCount;
                this.removeUpdate(this.gapStart, this.elementData, fromIndex, toIndex += this.gapLength);
            }
            while (fromIndex < toIndex) {
                this.elementData[fromIndex++] = null;
            }
        }
        this.gapLength += removeCount;
    }

    protected void removeUpdate(int index, Object[] data, int startOff, int endOff) {
    }

    private void moveGap(int index) {
        if (index == this.gapStart) {
            return;
        }
        if (index < this.gapStart) {
            int moveSize = this.gapStart - index;
            System.arraycopy(this.elementData, index, this.elementData, this.gapStart + this.gapLength - moveSize, moveSize);
            this.clearEmpty(index, Math.min(moveSize, this.gapLength));
            this.gapStart = index;
        } else {
            int gapEnd = this.gapStart + this.gapLength;
            int moveSize = index - this.gapStart;
            System.arraycopy(this.elementData, gapEnd, this.elementData, this.gapStart, moveSize);
            if (index < gapEnd) {
                this.clearEmpty(gapEnd, moveSize);
            } else {
                this.clearEmpty(index, this.gapLength);
            }
            this.gapStart += moveSize;
        }
    }

    private void copyAllData(Object[] toArray) {
        if (this.gapLength != 0) {
            int gapEnd = this.gapStart + this.gapLength;
            System.arraycopy(this.elementData, 0, toArray, 0, this.gapStart);
            System.arraycopy(this.elementData, gapEnd, toArray, this.gapStart, this.elementData.length - gapEnd);
        } else {
            System.arraycopy(this.elementData, 0, toArray, 0, this.elementData.length);
        }
    }

    private void clearEmpty(int index, int length) {
        while (--length >= 0) {
            this.elementData[index++] = null;
        }
    }

    private void resetModCount() {
        this.modCount = 0;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i;
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (i = 0; i < this.gapStart; ++i) {
            s.writeObject(this.elementData[i]);
        }
        i += this.gapLength;
        int elementDataLength = this.elementData.length;
        while (i < elementDataLength) {
            s.writeObject(this.elementData[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int i;
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new Object[arrayLength];
        for (i = 0; i < this.gapStart; ++i) {
            this.elementData[i] = s.readObject();
        }
        i += this.gapLength;
        int elementDataLength = this.elementData.length;
        while (i < elementDataLength) {
            this.elementData[i] = s.readObject();
            ++i;
        }
    }

    void consistencyCheck() {
        if (this.gapStart < 0 || this.gapLength < 0 || this.gapStart + this.gapLength > this.elementData.length) {
            this.consistencyError("Inconsistent gap");
        }
        for (int i = this.gapStart + this.gapLength - 1; i >= this.gapStart; --i) {
            if (this.elementData[i] == null) continue;
            this.consistencyError("Non-null value at raw-index i");
        }
    }

    private void consistencyError(String s) {
        throw new IllegalStateException(s + ": " + this.toStringInternals());
    }

    String toStringInternals() {
        return "elementData.length=" + this.elementData.length + ", gapStart=" + this.gapStart + ", gapLength=" + this.gapLength;
    }
}

