/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileUtil;

class CvsLiteAdminHandler
implements AdminHandler {
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final String INVALID_METADATA_MARKER_PATH = "CVS/invalid-metadata";
    private StandardAdminHandler stdHandler = new StandardAdminHandler();

    private void checkForInvalidMetadata(File dir) {
        File marker = new File(dir, INVALID_METADATA_MARKER_PATH);
        if (marker.exists()) {
            Utils.deleteRecursively(marker.getParentFile());
        }
    }

    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry, GlobalOptions globalOptions) throws IOException {
        this.checkForInvalidMetadata(new File(localDirectory));
        this.stdHandler.updateAdminData(localDirectory, repositoryPath, entry, globalOptions);
    }

    public Entry getEntry(File file) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        File parent = file.getParentFile();
        CvsMetadata data = MetadataAttic.getMetadata(parent);
        if (new File(parent, "CVS").isDirectory() || data == null) {
            return this.stdHandler.getEntry(file);
        }
        String[] se = data.getEntries();
        for (int i = 0; i < se.length; ++i) {
            Entry entry = new Entry(se[i]);
            if (entry.getName() == null || !entry.getName().equals(file.getName())) continue;
            return entry;
        }
        return null;
    }

    public boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if ("CVS".equals(file.getName())) {
            file = file.getParentFile();
        }
        return MetadataAttic.getMetadata(file) != null;
    }

    public Iterator getEntries(File directory) throws IOException {
        this.checkForInvalidMetadata(directory);
        if (new File(directory, "CVS").isDirectory()) {
            return this.stdHandler.getEntries(directory);
        }
        CvsMetadata data = MetadataAttic.getMetadata(directory = FileUtil.normalizeFile((File)directory));
        if (data == null) {
            return this.stdHandler.getEntries(directory);
        }
        return new CvsMetadataIterator(data);
    }

    public Entry[] getEntriesAsArray(File directory) throws IOException {
        this.checkForInvalidMetadata(directory);
        ArrayList entries = new ArrayList();
        Iterator i = this.getEntries(directory);
        while (i.hasNext()) {
            entries.add(i.next());
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        File adminDir = new File(file.getParentFile(), "CVS");
        this.createAdminDirs(adminDir);
        this.stdHandler.setEntry(file, entry);
    }

    private void createAdminDirs(File adminDir) throws IOException {
        if (!adminDir.exists()) {
            CvsMetadata data;
            if (adminDir.getParentFile() != null && adminDir.getParentFile().getParentFile() != null) {
                this.createAdminDirs(new File(adminDir.getParentFile().getParentFile(), "CVS"));
            }
            if ((data = MetadataAttic.getMetadata(adminDir.getParentFile())) != null) {
                data.save(adminDir);
                MetadataAttic.setMetadata(adminDir.getParentFile(), null);
            }
        }
    }

    public String getRepositoryForDirectory(String directory, String repository) throws IOException {
        this.checkForInvalidMetadata(new File(directory));
        File dirFile = new File(directory);
        if (dirFile.exists()) {
            return this.stdHandler.getRepositoryForDirectory(directory, repository);
        }
        CvsMetadata data = MetadataAttic.getMetadata(dirFile);
        if (data == null) {
            return this.stdHandler.getRepositoryForDirectory(directory, repository);
        }
        String fileRepository = data.getRepository();
        if (fileRepository == null) {
            fileRepository = "";
        }
        if (fileRepository.startsWith("/")) {
            return fileRepository;
        }
        return repository + '/' + fileRepository;
    }

    public void removeEntry(File file) throws IOException {
        File parent = file.getParentFile();
        this.checkForInvalidMetadata(parent);
        CvsMetadata data = MetadataAttic.getMetadata(parent);
        if (data != null) {
            String[] entries = data.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                Entry entry = new Entry(entries[i]);
                if (!file.getName().equals(entry.getName())) continue;
                ArrayList<String> newEntries = new ArrayList<String>(Arrays.asList(entries));
                newEntries.remove(entries[i]);
                if (newEntries.size() == 0 || newEntries.size() == 1 && "D".equals(newEntries.get(0))) {
                    MetadataAttic.setMetadata(parent, null);
                } else {
                    CvsMetadata newData = new CvsMetadata(data.getRepository(), data.getRoot(), newEntries.toArray(new String[newEntries.size()]));
                    MetadataAttic.setMetadata(parent, newData);
                }
                return;
            }
        }
        this.stdHandler.removeEntry(file);
    }

    public Set getAllFiles(File directory) throws IOException {
        this.checkForInvalidMetadata(directory);
        return this.stdHandler.getAllFiles(directory);
    }

    public String getStickyTagForDirectory(File directory) {
        this.checkForInvalidMetadata(directory);
        return this.stdHandler.getStickyTagForDirectory(directory);
    }

    private static class CvsMetadataIterator
    implements Iterator {
        private final Entry[] entries;
        private int index;

        public CvsMetadataIterator(CvsMetadata data) {
            String[] se = data.getEntries();
            ArrayList<Entry> le = new ArrayList<Entry>();
            for (int i = 0; i < se.length; ++i) {
                Entry entry = new Entry(se[i]);
                if (entry.getName() == null) continue;
                le.add(entry);
            }
            this.entries = le.toArray(new Entry[le.size()]);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.entries.length;
        }

        public Object next() {
            return this.entries[this.index++];
        }
    }
}

