/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class Kit
implements Client.Factory {
    private CVSRoot factory_cvsRoot;
    private ProxyDescriptor factory_proxy;

    private Kit(CVSRoot factory_cvsRoot, ProxyDescriptor factory_proxy) {
        this.factory_cvsRoot = factory_cvsRoot;
        this.factory_proxy = factory_proxy;
    }

    public static File createTmpFolder() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFolder = new File(tmpDir);
        File checkoutFolder = null;
        try {
            File tmp = File.createTempFile("checkout", "", tmpFolder);
            if (!tmp.delete()) {
                return checkoutFolder;
            }
            if (!tmp.mkdirs()) {
                return checkoutFolder;
            }
            tmp.deleteOnExit();
            checkoutFolder = FileUtil.normalizeFile((File)tmp);
        }
        catch (IOException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, NbBundle.getMessage((Class)Kit.class, (String)"BK2018"));
            err.notify((Throwable)e);
        }
        return checkoutFolder;
    }

    public static void deleteRecursively(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File next = files[i];
                Kit.deleteRecursively(next);
            }
            file.delete();
        }
    }

    public static Client createClient(CVSRoot cvsRoot, ProxyDescriptor proxy) {
        Connection connection = ClientRuntime.setupConnection(cvsRoot, proxy);
        Client client = new Client(connection, (AdminHandler)new StandardAdminHandler());
        return client;
    }

    public static Client.Factory createClientFactory(CVSRoot cvsRoot, ProxyDescriptor proxy) {
        return new Kit(cvsRoot, proxy);
    }

    public Client createClient() {
        return Kit.createClient(this.factory_cvsRoot, this.factory_proxy);
    }
}

