/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.system.cvss.util.Utils;

public class Context
implements Serializable {
    public static final Context Empty = new Context(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    private static final long serialVersionUID = 1L;
    private final List filteredFiles;
    private final List rootFiles;
    private final List exclusions;

    public Context(List filteredFiles, List rootFiles, List exclusions) {
        this.filteredFiles = filteredFiles;
        this.rootFiles = rootFiles;
        this.exclusions = exclusions;
        while (this.normalize()) {
        }
    }

    private boolean normalize() {
        Iterator i = this.rootFiles.iterator();
        while (i.hasNext()) {
            File root = (File)i.next();
            Iterator j = this.exclusions.iterator();
            while (j.hasNext()) {
                File exclusion = (File)j.next();
                if (!Utils.isParentOrEqual(exclusion, root)) continue;
                j.remove();
                this.exclusionRemoved(exclusion, root);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(List files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        Iterator i = files.iterator();
        block0: while (i.hasNext()) {
            File file = (File)i.next();
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                File includedFile = (File)j.next();
                if (Utils.isParentOrEqual(includedFile, file) && (file.isFile() || !(includedFile instanceof FlatFolder))) continue block0;
                if (!Utils.isParentOrEqual(file, includedFile) || !includedFile.isFile() && file instanceof FlatFolder) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }

    private void exclusionRemoved(File exclusion, File root) {
        File[] exclusionChildren = exclusion.listFiles();
        if (exclusionChildren == null) {
            return;
        }
        for (int i = 0; i < exclusionChildren.length; ++i) {
            File child = exclusionChildren[i];
            if (Utils.isParentOrEqual(root, child)) continue;
            this.exclusions.add(child);
        }
    }

    public List getRoots() {
        return this.rootFiles;
    }

    public List getExclusions() {
        return this.exclusions;
    }

    public File[] getFiles() {
        return this.filteredFiles.toArray(new File[this.filteredFiles.size()]);
    }

    public File[] getRootFiles() {
        return this.rootFiles.toArray(new File[this.rootFiles.size()]);
    }

    public boolean contains(File file) {
        Iterator i = this.rootFiles.iterator();
        block0: while (i.hasNext()) {
            File root = (File)i.next();
            if (!Utils.isParentOrEqual(root, file)) continue;
            Iterator j = this.exclusions.iterator();
            while (j.hasNext()) {
                File excluded = (File)j.next();
                if (!Utils.isParentOrEqual(excluded, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }
}

