/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.Toolkit;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

public class TextDetail {
    public static final int DH_SHOW = 1;
    public static final int DH_GOTO = 2;
    public static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private SearchPattern searchPattern;

    public TextDetail(DataObject dobj, SearchPattern pattern) {
        this.dobj = dobj;
        this.searchPattern = pattern;
    }

    public void showDetail(int how) {
        JEditorPane[] panes;
        if (this.dobj == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.lineObj == null) {
            LineCookie lineCookie = (LineCookie)this.dobj.getCookie(LineCookie.class);
            if (lineCookie != null) {
                Line.Set lineSet = lineCookie.getLineSet();
                try {
                    this.lineObj = lineSet.getOriginal(this.line - 1);
                }
                catch (IndexOutOfBoundsException ioobex) {
                    this.lineObj = lineSet.getOriginal(TextDetail.findMaxLine(lineSet));
                    this.markLength = 0;
                    this.column = 0;
                }
            }
            if (this.lineObj == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        if (how == 3) {
            return;
        }
        EditorCookie edCookie = (EditorCookie)this.dobj.getCookie(EditorCookie.class);
        if (edCookie != null) {
            edCookie.open();
        }
        if (how == 1) {
            this.lineObj.show(0, this.column - 1);
        } else if (how == 2) {
            this.lineObj.show(2, this.column - 1);
        }
        if (this.markLength > 0 && edCookie != null && (panes = edCookie.getOpenedPanes()) != null && panes.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Caret caret = panes[0].getCaret();
                    caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                }
            });
        }
        SearchHistory.getDefault().setLastSelected(this.searchPattern);
    }

    public String getLineText() {
        return this.lineText;
    }

    public void setLineText(String text) {
        this.lineText = text;
    }

    public DataObject getDataObject() {
        return this.dobj;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int col) {
        this.column = col;
    }

    public void setMarkLength(int len) {
        this.markLength = len;
    }

    public int getMarkLength() {
        return this.markLength;
    }

    private static int findMaxLine(Line.Set set) {
        int from = 0;
        int to = 32000;
        try {
            while (true) {
                set.getOriginal(to);
                from = to;
                to *= 2;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            while (from < to) {
                int middle = (from + to + 1) / 2;
                try {
                    set.getOriginal(middle);
                    from = middle;
                }
                catch (IndexOutOfBoundsException ex2) {
                    to = middle - 1;
                }
            }
            return from;
        }
    }
}

