/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.websvc.registry.ui.TestWebServiceMethodDlg;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodExceptionDialog
extends JPanel {
    private String currentMessage = "";
    private JButton okButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"OPTION_OK"));
    private DialogDescriptor dlg;
    private Dialog dialog;
    private JEditorPane messagePane;
    private JScrollPane scrollPane;

    public MethodExceptionDialog(Exception inException) {
        this.initComponents();
        this.setMessage(inException, false);
    }

    public void show() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"CLIENT_EXCEPTION"), false, 2, DialogDescriptor.OK_OPTION, 0, this.getHelpCtx(), null);
        this.dlg.setOptions(new Object[]{this.okButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dialog.setSize(500, 300);
        this.dialog.show();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TestWebServiceMethodDlg.class);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.messagePane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.messagePane.setEditorKit(new HTMLEditorKit());
        this.scrollPane.setViewportView(this.messagePane);
        this.add((Component)this.scrollPane, "Center");
    }

    public void setMessage(Exception inException, boolean keepOld) {
        String htmlStart = "<HTML><HEAD><style type=\"text/css\">body { font-family: Verdana, sans-serif; font-size: 12; }</style></HEAD><BODY>";
        String htmlEnd = "</BODY></HTML>";
        String exceptionString = "";
        Throwable cause = inException;
        while (null != cause) {
            exceptionString = exceptionString + "<BR><FONT COLOR=\"RED\">" + cause.getLocalizedMessage() + "</FONT>";
            StackTraceElement[] traceElements = cause.getStackTrace();
            String stackTrace = "<BR>Stack Trace<BR><BR>";
            for (int ii = 0; ii < traceElements.length; ++ii) {
                exceptionString = exceptionString + "<BR>" + traceElements[ii].toString();
            }
            if (null == (cause = cause.getCause())) continue;
            exceptionString = exceptionString + "<BR>Next Exception Layer";
        }
        this.currentMessage = keepOld ? this.currentMessage + exceptionString : exceptionString;
        this.messagePane.setText(htmlStart + this.currentMessage + htmlEnd);
    }
}

