/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.wsdl;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.modeler.wsdl.WSDLModelerBase;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.spi.model.Service;
import com.sun.xml.rpc.spi.tools.ModelInfo;
import com.sun.xml.rpc.spi.tools.ProcessorEnvironment;
import com.sun.xml.rpc.util.JAXRPCClassFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.websvc.registry.jaxrpc.Wsdl2Java;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.util.Util;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class WSDLInfo {
    File errorFile;
    private String program = "wscompile";
    private String outputDir;
    private String nonClassOutputDir;
    private String sourceOutputDir;
    private URL wsdlUrl;
    private String packageName = "";
    private String errorMessage;
    private boolean hasOperations;
    private static final String WSDL_DOCUMENTATION = "com.sun.xml.rpc.processor.modeler.wsdl.documentation";
    public static final String SERVICE_DISPLAYNAME_TOKEN = "%%DISPLAY_NAME%%";
    public static final String TOKEN_SEPARATOR = "@";
    public static final String SIG_SEPARATOR = "|";
    public static final String RETURN_SEPARATOR = "!";
    public static final String PARAM_SEPARATOR = ":";
    private com.sun.xml.rpc.spi.model.Model wsdlModel;
    Wsdl2Java wsdl2Java;
    boolean removeGeneratedFiles = true;

    public WSDLInfo() {
        try {
            this.errorFile = File.createTempFile("wscompile", "error");
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify(4096, (Throwable)exc);
        }
    }

    public boolean hasOperations() {
        return this.hasOperations;
    }

    public void setWsdlUrl(URL url) {
        this.wsdlUrl = url;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setPackageName(String pkgName) {
        this.packageName = pkgName;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = "webservice";
        }
        return this.packageName;
    }

    public String getErrorMessage() {
        StringWriter errorWriter = new StringWriter();
        StringBuffer strBuffer = new StringBuffer();
        errorWriter.write("<B>" + NbBundle.getMessage(this.getClass(), (String)"WSDLINFO_ERROR_PARSING") + " </B>");
        errorWriter.write("<BR><B><I>" + this.errorMessage + "</I></B>");
        return errorWriter.toString();
    }

    public void setOutputDirectory(String dir) {
        this.outputDir = dir;
    }

    public String getOutputDirectory() {
        if (this.outputDir == null) {
            File outDir = new File(System.getProperty("user.home"));
            return outDir.getAbsolutePath();
        }
        return this.outputDir;
    }

    public void setRemoveGeneratedFiles(boolean remove) {
        this.removeGeneratedFiles = remove;
    }

    public boolean create() {
        WSDLModelInfo modelInfo = new WSDLModelInfo();
        ClientProcessorEnvironment env = new ClientProcessorEnvironment((OutputStream)new ByteArrayOutputStream(), null, null);
        Configuration config = new Configuration((ProcessorEnvironment)env);
        modelInfo = new WSDLModelInfo();
        config.setModelInfo((ModelInfo)modelInfo);
        modelInfo.setParent(config);
        modelInfo.setLocation(this.getWsdlUrl().toExternalForm());
        Properties options = new Properties();
        options.put("validationWSDL", "true");
        options.put("searchSchemaForSubtypes", "true");
        options.put("useWSIBasicProfile", "false");
        WSDLModelerBase modeler = JAXRPCClassFactory.newInstance().createWSDLModeler(modelInfo, options);
        Model tmpModel = null;
        try {
            tmpModel = modeler.buildModel();
        }
        catch (Exception me) {
            this.errorMessage = " Exception = " + me.getLocalizedMessage();
            return false;
        }
        this.setWSDLModel((com.sun.xml.rpc.spi.model.Model)tmpModel);
        return true;
    }

    private void setWSDLModel(com.sun.xml.rpc.spi.model.Model inModel) {
        this.wsdlModel = inModel;
    }

    public Set getWebServices() {
        HashSet<WebServiceData> webServices = new HashSet<WebServiceData>();
        com.sun.xml.rpc.spi.model.Model model = this.getWSDLModel();
        if (null != model) {
            Iterator services = model.getServices();
            while (services.hasNext()) {
                WebServiceData wsData = new WebServiceData();
                wsData.setURL(this.getWsdlUrl().toString());
                Service service = (Service)services.next();
                String serviceName = service.getJavaIntf().getName();
                wsData.setName(serviceName);
                serviceName = serviceName.substring(serviceName.lastIndexOf(46) + 1, serviceName.length());
                String hotsName = this.getWsdlUrl().getHost();
                String displayName = serviceName;
                wsData.setDisplayName(displayName);
                Iterator ports = service.getPorts();
                while (ports.hasNext()) {
                    Port port = (Port)ports.next();
                    port.setProperty("WSPORTNAME", (Object)port.getName().getLocalPart());
                    wsData.addPort(port);
                    wsData.setWebServiceAddress(port.getAddress());
                    String portName = port.getJavaInterface().getRealName();
                    portName = portName.substring(portName.lastIndexOf(46) + 1, portName.length());
                    wsData.setProxy(portName);
                }
                webServices.add(wsData);
            }
        }
        return webServices;
    }

    private com.sun.xml.rpc.spi.model.Model getWSDLModel() {
        return this.wsdlModel;
    }

    public String getServiceInfo(String inServiceName) {
        StringWriter strWriter = new StringWriter();
        com.sun.xml.rpc.spi.model.Model model = this.getWSDLModel();
        if (null != model) {
            Iterator services = model.getServices();
            int ii = 0;
            while (services.hasNext()) {
                Service service = (Service)services.next();
                String serviceName = service.getJavaIntf().getName();
                if (serviceName.equals(inServiceName)) {
                    Iterator ports;
                    serviceName = serviceName.substring(serviceName.lastIndexOf(46) + 1, serviceName.length());
                    strWriter.write("<a name=\"TOPOFPAGE\">&nbsp</a>");
                    strWriter.write("<FORM NAME=\"service_form." + serviceName + "\">");
                    strWriter.write("<TABLE><TR>");
                    strWriter.write("<TD  VALIGN=TOP><B>" + NbBundle.getMessage(this.getClass(), (String)"SERVICE_WSDL_NAME") + "</B></TD>");
                    strWriter.write("<TD  VALIGN=TOP>" + serviceName + "</TD>");
                    strWriter.write("</TR><TR>");
                    strWriter.write("<TD  VALIGN=TOP><LABEL FOR=\"service_name." + serviceName + "\" ><B>" + NbBundle.getMessage(this.getClass(), (String)"SERVICE_DISPLAY_NAME") + "</B></LABEL></TD>");
                    strWriter.write("<TD  VALIGN=TOP><INPUT TYPE=TEXT ID=\"service_name." + serviceName + "\" NAME=\"service_name." + serviceName + "\" VALUE=\"" + SERVICE_DISPLAYNAME_TOKEN + "\" STYLE=\"background: #ade7ff\"></TD>");
                    strWriter.write("</TR><TR>");
                    strWriter.write("<TD  VALIGN=TOP><LABEL FOR=\"package_name." + serviceName + "\" ><B>" + NbBundle.getMessage(this.getClass(), (String)"CLIENT_PACKAGE_NAME") + "</B></LABEL></TD>");
                    strWriter.write("<TD  VALIGN=TOP><INPUT TYPE=TEXT SIZE=30 ID=\"package_name." + serviceName + "\" NAME=\"package_name." + serviceName + "\" VALUE=\"" + "webservice" + "." + serviceName.toLowerCase() + "\" STYLE=\"background: #ade7ff\"></TD>");
                    strWriter.write("</TR>");
                    String serviceDocumentationContent = (String)service.getProperty(WSDL_DOCUMENTATION);
                    if (null != serviceDocumentationContent) {
                        strWriter.write("<TR>");
                        strWriter.write("<TD  VALIGN=TOP><LABEL><B>" + NbBundle.getMessage(this.getClass(), (String)"SERVICE_DOCUMENTATION") + "</B></LABEL></TD>");
                        strWriter.write("<TD  VALIGN=TOP>" + serviceDocumentationContent + "</TD>");
                        strWriter.write("</TR>");
                    }
                    if (!(ports = service.getPorts()).hasNext()) {
                        strWriter.write("</TABLE>");
                    }
                    while (ports.hasNext()) {
                        Port port = (Port)ports.next();
                        JavaInterface javaInterface = port.getJavaInterface();
                        String proxy = javaInterface.getName();
                        proxy = proxy.substring(proxy.lastIndexOf(46) + 1, proxy.length());
                        strWriter.write("<TR>");
                        strWriter.write("<TD  VALIGN=TOP><B>" + NbBundle.getMessage(this.getClass(), (String)"WEB_SERVICE_PORTNNAME") + "</B></TD>");
                        strWriter.write("<TD  VALIGN=TOP>" + port.getName().toString() + "</TD>");
                        strWriter.write("</TR>");
                        strWriter.write("<TR>");
                        strWriter.write("<TD  VALIGN=TOP><B>" + NbBundle.getMessage(this.getClass(), (String)"WEB_SERVICE_ADDRESS") + "</B></TD>");
                        strWriter.write("<TD  VALIGN=TOP>" + port.getAddress() + "</TD>");
                        strWriter.write("</TR>");
                        Iterator operations = port.getOperations();
                        strWriter.write("<TR>");
                        strWriter.write("<TD  VALIGN=TOP><B>" + NbBundle.getMessage(this.getClass(), (String)"METHODS") + "</B></TD>");
                        strWriter.write("</TR>");
                        boolean methodCount = false;
                        while (operations.hasNext()) {
                            this.hasOperations = true;
                            Operation operation = (Operation)operations.next();
                            JavaMethod method = operation.getJavaMethod();
                            strWriter.write("<TR>");
                            strWriter.write("<TD VALIGN=TOP>");
                            String signatureString = method.getReturnType().getRealName() + RETURN_SEPARATOR;
                            Iterator paramameters = method.getParameters();
                            while (paramameters.hasNext()) {
                                JavaParameter currentParam = (JavaParameter)paramameters.next();
                                signatureString = signatureString + currentParam.getType().getRealName() + PARAM_SEPARATOR;
                            }
                            strWriter.write("<A HREF=\"test@" + serviceName + TOKEN_SEPARATOR + port.getName().getLocalPart() + TOKEN_SEPARATOR + method.getName() + TOKEN_SEPARATOR + SIG_SEPARATOR + signatureString + "\">" + NbBundle.getMessage(this.getClass(), (String)"TEST_METHOD") + "</A>");
                            strWriter.write("</TD>");
                            strWriter.write("<TD VALIGN=TOP>");
                            strWriter.write("<I>" + method.getReturnType().getRealName() + "</I>&nbsp");
                            strWriter.write("<B>" + method.getName() + "</B>(");
                            Iterator params = method.getParameters();
                            while (params.hasNext()) {
                                strWriter.write("<I>");
                                JavaParameter param = (JavaParameter)params.next();
                                String parameterType = Util.getParameterType(port, param);
                                strWriter.write(parameterType);
                                if (params.hasNext()) {
                                    strWriter.write(", ");
                                }
                                strWriter.write("</I>");
                            }
                            strWriter.write(")");
                            for (Object currentException : method.getExceptionsList()) {
                                if (null == currentException || !(currentException instanceof String) || ((String)currentException).length() <= 0) continue;
                                strWriter.write("<I> &nbsp throws &nbsp ");
                                strWriter.write((String)currentException);
                                if (params.hasNext()) {
                                    strWriter.write(", &nbsp");
                                }
                                strWriter.write("</I>");
                            }
                            String operationDocumentationContent = (String)operation.getProperty(WSDL_DOCUMENTATION);
                            if (null != operationDocumentationContent) {
                                strWriter.write("<BR>" + operationDocumentationContent);
                            }
                            strWriter.write("</TD>");
                            strWriter.write("</TR>");
                        }
                    }
                    strWriter.write("</TABLE>");
                    strWriter.write("</FORM>");
                    if (services.hasNext()) {
                        strWriter.write("<HR>");
                    }
                    break;
                }
                ++ii;
            }
        } else {
            strWriter.write("<BR><B>" + NbBundle.getMessage(this.getClass(), (String)"WSDLINFO_ERROR_PARSING") + "</B><BR> ");
        }
        return strWriter.toString();
    }

    public static void main(String[] args) {
        System.setProperty("http.proxyHost", "webcache.sfbay.sun.com");
        System.setProperty("http.proxyPort", "8080");
        WSDLInfo wsdlInfo = new WSDLInfo();
        File wsdlFile = new File("D:\\realtimeservice.wsdl");
        try {
            wsdlInfo.setWsdlUrl(wsdlFile.toURL());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(-1);
        }
        if (wsdlInfo.create()) {
            wsdlInfo.getServiceInfo("RealTimeService");
        } else {
            System.out.println(wsdlInfo.getErrorMessage());
        }
    }
}

