/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.openide.src.Type;

public final class MethodParameter
implements Serializable {
    private String name;
    private Type type;
    private boolean fin;
    static final long serialVersionUID = -6158959006278766562L;

    public MethodParameter(String name, Type type, boolean fin) {
        this.name = name;
        this.type = type;
        this.fin = fin;
    }

    public static MethodParameter parse(String text) throws IllegalArgumentException {
        StringTokenizer tok = new StringTokenizer(text, " []", true);
        boolean rightBracketExpected = false;
        boolean fin = false;
        Type type = null;
        String name = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals(" ")) continue;
            if (type == null) {
                if (token.equals("final")) {
                    if (fin) {
                        throw new IllegalArgumentException();
                    }
                    fin = true;
                    continue;
                }
                type = Type.parse(token);
                continue;
            }
            if (token.equals("[")) {
                if (rightBracketExpected) {
                    throw new IllegalArgumentException();
                }
                rightBracketExpected = true;
                continue;
            }
            if (token.equals("]")) {
                if (!rightBracketExpected) {
                    throw new IllegalArgumentException();
                }
                type = Type.createArray(type);
                rightBracketExpected = false;
                continue;
            }
            if (name != null) {
                throw new IllegalArgumentException();
            }
            name = token;
        }
        if (type == null || name == null || rightBracketExpected) {
            throw new IllegalArgumentException();
        }
        Type t = Type.parse(name);
        if (!t.isClass()) {
            throw new IllegalArgumentException();
        }
        return new MethodParameter(name, type, fin);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFinal(boolean fin) {
        this.fin = fin;
    }

    public boolean isFinal() {
        return this.fin;
    }

    StringBuffer getAsString(StringBuffer appendTo, boolean source) {
        if (this.fin) {
            appendTo.append("final ");
        }
        this.type.getAsString(appendTo, source);
        appendTo.append(" ");
        appendTo.append(this.name);
        return appendTo;
    }

    public String getFullString() {
        return this.getAsString(new StringBuffer(), false).toString();
    }

    public String getSourceString() {
        return this.getAsString(new StringBuffer(), true).toString();
    }

    public String toString() {
        return this.getAsString(new StringBuffer(), false).toString();
    }

    public boolean compareTo(MethodParameter param, boolean onlyType, boolean source) {
        if (!this.type.compareTo(param.type, source)) {
            return false;
        }
        return onlyType ? true : param.fin == this.fin && param.name.equals(this.name);
    }

    public boolean equals(Object o) {
        return o instanceof MethodParameter ? this.compareTo((MethodParameter)o, true, false) : false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode();
    }
}

