/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementProperties;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.IconStrings;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.src.nodes.SourceOptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public abstract class ElementNode
extends AbstractNode
implements IconStrings,
ElementProperties {
    static ResourceBundle bundle = NbBundle.getBundle((Class)ElementNode.class);
    private static ElementFormat invalidFormat;
    protected static final SourceOptions sourceOptions;
    private static final String[] ICON_AFFECTING_PROPERTIES;
    protected Element element;
    protected ElementFormat elementFormat = new ElementFormat("");
    protected boolean writeable;
    private transient PropertyChangeListener listener;

    public ElementNode(Element element, Children children, boolean writeable) {
        super(children);
        this.element = element;
        this.writeable = writeable;
        this.setIconBase(this.resolveIconBase());
        this.setDisplayName(this.getElementFormat().format(element));
        this.listener = this.createElementListener();
        element.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)element));
        this.displayFormat = null;
    }

    public String getShortDescription() {
        try {
            return this.getHintElementFormat().format(this.element);
        }
        catch (IllegalArgumentException e) {
            return super.getShortDescription();
        }
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public final ElementFormat getElementFormat() {
        return this.elementFormat;
    }

    public final void setElementFormat(ElementFormat elementFormat) {
        this.setDisplayName(elementFormat.format(this.element));
        this.elementFormat = elementFormat;
    }

    final void setElementFormat0(ElementFormat elementFormat) {
        try {
            this.setElementFormat(elementFormat);
        }
        catch (IllegalArgumentException iae) {
            this.setElementFormat(ElementNode.getInvalidFormat());
        }
    }

    static ElementFormat getInvalidFormat() {
        if (invalidFormat != null) {
            return invalidFormat;
        }
        invalidFormat = new ElementFormat(bundle.getString("FMT_InvalidFormat"));
        return invalidFormat;
    }

    protected abstract ElementFormat getHintElementFormat();

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ElementNode.class);
    }

    public boolean canRename() {
        return this.isWriteable();
    }

    public boolean canDestroy() {
        return this.isWriteable();
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable ex = ExTransferable.create((Transferable)super.clipboardCopy());
        ex.put((ExTransferable.Single)new ElementStringTransferable());
        return ex;
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.isWriteable()) {
            throw new IOException();
        }
        ExTransferable ex = ExTransferable.create((Transferable)super.clipboardCut());
        ex.put((ExTransferable.Single)new ElementStringTransferable());
        return ex;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.isWriteable();
    }

    public void setActions(SystemAction[] actions) {
        this.systemActions = actions;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie c = super.getCookie(type);
        if (c == null) {
            c = this.element.getCookie(type);
        }
        return c;
    }

    public boolean equals(Object o) {
        return o instanceof ElementNode && this.element.equals(((ElementNode)o).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public Node.Handle getHandle() {
        Node.Handle supe = super.getHandle();
        if (supe != null) {
            return supe;
        }
        if (this.element instanceof SourceElement) {
            return null;
        }
        return new ElementNodeHandle(this.element, this.writeable, this.elementFormat);
    }

    boolean isWriteable() {
        return this.writeable && SourceEditSupport.isWriteable(this.element);
    }

    void superSetName(String name) {
        super.setName(name);
    }

    void superPropertyChange(String name, Object o, Object n) {
        if (this.hasPropertyChangeListener() && (name == null || this.findPropertyNames().contains(name))) {
            super.firePropertyChange(name, o, n);
        }
    }

    private Set findPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        Node.PropertySet[] npsets = this.getPropertySets();
        for (int i = 0; i < npsets.length; ++i) {
            Node.PropertySet npset = npsets[i];
            Node.Property[] nps = npset.getProperties();
            for (int j = 0; j < nps.length; ++j) {
                Node.Property np = nps[j];
                names.add(np.getName());
            }
        }
        return names;
    }

    public Node.PropertySet[] getPropertySets() {
        return super.getPropertySets();
    }

    void superShortDescriptionChange(String o, String n) {
        super.fireShortDescriptionChange(o, n);
    }

    PropertyChangeListener createElementListener() {
        return new ElementListener();
    }

    static {
        sourceOptions = (SourceOptions)SourceOptions.findObject((Class)SourceOptions.class, (boolean)true);
        ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    }

    static abstract class ElementProp
    extends PropertySupport {
        public ElementProp(String name, Class type, boolean canW) {
            super(name, type, bundle.getString("PROP_" + name), bundle.getString("HINT_" + name), true, canW);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(bundle.getString("MSG_Cannot_Write"));
            }
        }

        void runAtomic(Element element, SourceEditSupport.ExceptionalRunnable exRun) throws InvocationTargetException {
            try {
                SourceEditSupport.runAsUser(element, exRun);
            }
            catch (SourceException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    class ElementListener
    implements PropertyChangeListener {
        ElementListener() {
        }

        public void propertyChange(final PropertyChangeEvent evt) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    String propName = evt.getPropertyName();
                    if (propName == null) {
                        ElementNode.this.setDisplayName(ElementNode.this.getElementFormat().format(((ElementListener)ElementListener.this).ElementNode.this.element));
                        ElementNode.this.setIconBase(ElementNode.this.resolveIconBase());
                    } else {
                        if ("valid".equals(propName)) {
                            ElementNode.this.fireNodeDestroyed();
                            return;
                        }
                        if (ElementNode.this.getElementFormat().dependsOnProperty(propName)) {
                            ElementNode.this.setDisplayName(ElementNode.this.getElementFormat().format(((ElementListener)ElementListener.this).ElementNode.this.element));
                        }
                        String[] iconProps = ElementNode.this.getIconAffectingProperties();
                        for (int i = 0; i < iconProps.length; ++i) {
                            if (!iconProps[i].equals(propName)) continue;
                            ElementNode.this.setIconBase(ElementNode.this.resolveIconBase());
                            break;
                        }
                        if (propName.equals("name")) {
                            try {
                                ElementNode.this.superSetName(((MemberElement)((ElementListener)ElementListener.this).ElementNode.this.element).getName().toString());
                            }
                            catch (ClassCastException classCastException) {}
                        } else if (propName.equals("cookie")) {
                            ElementNode.this.superFireCookieChange();
                            return;
                        }
                    }
                    if (ElementNode.this.getHintElementFormat().dependsOnProperty(evt.getPropertyName())) {
                        ElementNode.this.superShortDescriptionChange("", ElementNode.this.getShortDescription());
                    }
                    ElementNode.this.superPropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            });
        }
    }

    private static final class ElementNodeHandle
    implements Node.Handle {
        private static final long serialVersionUID = 910667289626540L;
        private Element element;
        private boolean writable;
        private ElementFormat elementFormat;

        public ElementNodeHandle(Element element, boolean writable, ElementFormat elementFormat) {
            this.element = element;
            this.writable = writable;
            this.elementFormat = elementFormat;
        }

        public Node getNode() throws IOException {
            Node n;
            DefaultFactory factory = new DefaultFactory(this.writable);
            if (this.element instanceof ClassElement) {
                n = factory.createClassNode((ClassElement)this.element);
            } else if (this.element instanceof ConstructorElement) {
                n = factory.createConstructorNode((ConstructorElement)this.element);
            } else if (this.element instanceof FieldElement) {
                n = factory.createFieldNode((FieldElement)this.element);
            } else if (this.element instanceof InitializerElement) {
                n = factory.createInitializerNode((InitializerElement)this.element);
            } else if (this.element instanceof MethodElement) {
                n = factory.createMethodNode((MethodElement)this.element);
            } else {
                throw new IOException("what is element " + this.element + "? cannot restore node");
            }
            if (n instanceof ElementNode) {
                ((ElementNode)n).setElementFormat(this.elementFormat);
            }
            return n;
        }

        public String toString() {
            return "ElementNodeHandle[" + this.element + "]";
        }
    }

    class ElementStringTransferable
    extends ExTransferable.Single {
        ElementStringTransferable() {
            super(DataFlavor.stringFlavor);
        }

        protected Object getData() {
            return ElementNode.this.element.toString();
        }
    }
}

