/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.providers;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.providers.JavaSuggestionContext;
import org.netbeans.modules.tasklist.providers.PropertiesSuggestionContext;
import org.netbeans.modules.tasklist.providers.XMLSuggestionContext;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class SuggestionContext {
    private final DataObject dataObject;
    private String cachedString;
    private static boolean linkageError;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$providers$SuggestionContext;

    SuggestionContext(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public CharSequence getCharSequence() {
        if (this.cachedString == null) {
            EditorCookie edit;
            FileObject fo = this.getFileObject();
            if (!linkageError && fo.hasExt("java")) {
                try {
                    this.cachedString = JavaSuggestionContext.getContent(fo);
                    return this.cachedString;
                }
                catch (LinkageError link) {
                    link.printStackTrace();
                    linkageError = true;
                }
            }
            if (fo.hasExt("properties") && !this.dataObject.isModified()) {
                this.cachedString = PropertiesSuggestionContext.getContent(fo);
                return this.cachedString;
            }
            if ("xml".equalsIgnoreCase(fo.getExt()) && !this.dataObject.isModified()) {
                this.cachedString = XMLSuggestionContext.getContent(fo);
                if (this.cachedString != null) {
                    return this.cachedString;
                }
            }
            if ((edit = (EditorCookie)this.dataObject.getCookie(EditorCookie.class)) != null) {
                try {
                    StyledDocument doc = edit.openDocument();
                    this.cachedString = SuggestionContext.extractString(doc);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        return this.cachedString;
    }

    public Document getDocument() {
        EditorCookie edit = (EditorCookie)this.dataObject.getCookie(EditorCookie.class);
        if (edit != null) {
            try {
                return edit.openDocument();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public FileObject getFileObject() {
        return this.dataObject.getPrimaryFile();
    }

    private static String extractString(final Document doc) {
        final String[] text = new String[1];
        doc.render(new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                block2: {
                    try {
                        text[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException ex) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)ex);
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$tasklist$providers$SuggestionContext == null ? (class$org$netbeans$modules$tasklist$providers$SuggestionContext = SuggestionContext.class$("org.netbeans.modules.tasklist.providers.SuggestionContext")) : class$org$netbeans$modules$tasklist$providers$SuggestionContext).desiredAssertionStatus();
            }
        });
        return text[0];
    }
}

