/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private static final String ANT_NAME = "platform.ant.name";
    private static final String J2SE = "j2se";
    private final PropertyEvaluator evaluator;
    private JavaPlatformManager platformManager;
    private String activePlatformName;
    private boolean isActivePlatformValid;
    private List<PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public BootClassPathImplementation(PropertyEvaluator evaluator) {
        assert (evaluator != null);
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resourcesCache == null) {
            JavaPlatform jp = this.findActivePlatform();
            if (jp != null) {
                ClassPath cp = jp.getBootstrapLibraries();
                List entries = cp.entries();
                ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>(entries.size());
                for (ClassPath.Entry entry : entries) {
                    result.add(ClassPathSupport.createResource((URL)entry.getURL()));
                }
                this.resourcesCache = Collections.unmodifiableList(result);
            } else {
                this.resourcesCache = Collections.emptyList();
            }
        }
        return this.resourcesCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private JavaPlatform findActivePlatform() {
        if (this.platformManager == null) {
            this.platformManager = JavaPlatformManager.getDefault();
            this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
        }
        this.activePlatformName = this.evaluator.getProperty(PLATFORM_ACTIVE);
        if (this.activePlatformName != null) {
            JavaPlatform[] installedPlatforms = this.platformManager.getInstalledPlatforms();
            for (int i = 0; i < installedPlatforms.length; ++i) {
                Specification spec = installedPlatforms[i].getSpecification();
                String antName = (String)installedPlatforms[i].getProperties().get(ANT_NAME);
                if (!J2SE.equalsIgnoreCase(spec.getName()) || !this.activePlatformName.equals(antName)) continue;
                this.isActivePlatformValid = true;
                return installedPlatforms[i];
            }
            this.isActivePlatformValid = false;
            return null;
        }
        return this.platformManager.getDefaultPlatform();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block3: {
            block4: {
                block2: {
                    if (evt.getSource() != this.evaluator || !evt.getPropertyName().equals(PLATFORM_ACTIVE)) break block2;
                    this.resetCache();
                    break block3;
                }
                if (evt.getSource() != this.platformManager || !"installedPlatforms".equals(evt.getPropertyName()) || this.activePlatformName == null) break block3;
                if (!this.isActivePlatformValid) break block4;
                JavaPlatform[] j2sePlatforms = this.platformManager.getPlatforms(null, new Specification(J2SE, null));
                boolean found = false;
                for (int i = 0; i < j2sePlatforms.length; ++i) {
                    String antName = (String)j2sePlatforms[i].getProperties().get(ANT_NAME);
                    if (antName == null || !antName.equals(this.activePlatformName)) continue;
                    found = true;
                }
                if (found) break block3;
                this.resetCache();
                break block3;
            }
            JavaPlatform[] j2sePlatforms = this.platformManager.getPlatforms(null, new Specification(J2SE, null));
            for (int i = 0; i < j2sePlatforms.length; ++i) {
                String antName = (String)j2sePlatforms[i].getProperties().get(ANT_NAME);
                if (antName == null || !antName.equals(this.activePlatformName)) continue;
                this.resetCache();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }
}

