/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarCustomizer;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EarCustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private final AntBasedProjectType abpt;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";

    public EarCustomizerProvider(Project project, AntProjectHelper antProjectHelper, ReferenceHelper refHelper, AntBasedProjectType abpt) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = refHelper;
        this.abpt = abpt;
    }

    public void showCustomizer() {
        this.createDialog().setVisible(true);
    }

    Dialog createDialog() {
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(EarCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(EarCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[1].setActionCommand(COMMAND_CANCEL);
        EarProjectProperties earProperties = new EarProjectProperties((EarProject)this.project, this.refHelper, this.abpt);
        OptionListener optionsListener = new OptionListener(this.project, earProperties);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        ProjectEar pwm = (ProjectEar)this.project.getLookup().lookup(ProjectEar.class);
        EarCustomizer innerPane = new EarCustomizer(earProperties, pwm);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)innerPane, NbBundle.getMessage(EarCustomizerProvider.class, (String)"LBL_Customizer_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), false, options, (Object)options[0], 0, null, null);
        innerPane.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        return DialogDisplayer.getDefault().createDialog(dialogDescriptor);
    }

    private static class OptionListener
    implements ActionListener {
        private Project project;
        private EarProjectProperties earProperties;

        OptionListener(Project project, EarProjectProperties earProperties) {
            this.project = project;
            this.earProperties = earProperties;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (EarCustomizerProvider.COMMAND_OK.equals(command)) {
                this.earProperties.store();
            }
        }
    }
}

