/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.customizer.ArchiveCustomizerPanel;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerGeneral;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerJarContent;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EarCustomizer
extends JPanel {
    private Component currentCustomizer;
    private GridBagConstraints fillConstraints;
    private DialogDescriptor dialogDescriptor;
    private JPanel categoryPanel;
    private JPanel customizerPanel;
    private JLabel jLabel1;

    public EarCustomizer(EarProjectProperties earProperties, ProjectEar wm) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EarCustomizer.class, (String)"ACS_Customize_A11YDesc"));
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.fillConstraints.anchor = 12;
        this.categoryPanel.add((Component)new CategoryView(EarCustomizer.createRootNode(earProperties, wm)), this.fillConstraints);
    }

    private void initComponents() {
        this.categoryPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 4);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.customizerPanel.setLayout(new BoxLayout(this.customizerPanel, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 8, 8);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.jLabel1.setLabelFor(this.categoryPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(EarCustomizer.class).getString("LBL_Categories"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 8, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private static Node createRootNode(EarProjectProperties earProperties, ProjectEar wm) {
        String ICON = "org/netbeans/modules/j2ee/earproject/ui/resources/propertyNode.gif";
        ResourceBundle bundle = NbBundle.getBundle(EarCustomizer.class);
        ConfigurationDescription[] buildDescriptions = new ConfigurationDescription[]{new ConfigurationDescription("Package", bundle.getString("LBL_Config_Packaging"), ICON, new CustomizerJarContent(earProperties), null)};
        ConfigurationDescription[] descriptions = new ConfigurationDescription[]{new ConfigurationDescription("General", bundle.getString("LBL_Config_Sources"), ICON, new CustomizerGeneral(earProperties), null), new ConfigurationDescription("Libraries", bundle.getString("LBL_Config_Libraries"), ICON, new CustomizerLibraries(earProperties), null), new ConfigurationDescription("BuildCategory", bundle.getString("LBL_Category_Build"), ICON, EarCustomizer.createEmptyLabel(null), buildDescriptions), new ConfigurationDescription("Run", bundle.getString("LBL_Category_Run"), ICON, new CustomizerRun(earProperties, wm), null)};
        ConfigurationDescription rootDescription = new ConfigurationDescription("InvisibleRoot", "InvisibleRoot", null, null, descriptions);
        return new ConfigurationNode(rootDescription);
    }

    private static JLabel createEmptyLabel(String text) {
        JLabel label;
        if (text == null) {
            label = new JLabel();
        } else {
            label = new JLabel(text);
            label.setHorizontalAlignment(0);
        }
        return label;
    }

    public HelpCtx getHelpCtx() {
        return this.currentCustomizer instanceof JLabel ? null : HelpCtx.findHelp((Component)this.currentCustomizer);
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
        if (null != dialogDescriptor) {
            dialogDescriptor.setHelpCtx(this.getHelpCtx());
        }
    }

    private static class ConfigurationChildren
    extends Children.Keys {
        private final Collection descriptions;

        public ConfigurationChildren(ConfigurationDescription[] descriptions) {
            this.descriptions = Arrays.asList(descriptions);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new ConfigurationNode((ConfigurationDescription)key)};
        }
    }

    private static class ConfigurationNode
    extends AbstractNode {
        private final Component customizer;

        public ConfigurationNode(ConfigurationDescription description) {
            super((Children)(description.children == null ? Children.LEAF : new ConfigurationChildren(description.children)));
            this.setName(description.name);
            this.setDisplayName(description.displayName);
            if (description.iconBase != null) {
                this.setIconBaseWithExtension(description.iconBase);
            }
            this.customizer = description.customizer;
        }

        public boolean hasCustomizer() {
            return this.customizer != null;
        }

        public Component getCustomizer() {
            return this.customizer;
        }
    }

    private static class ConfigurationDescription {
        private String name;
        private String displayName;
        private String iconBase;
        private Component customizer;
        private ConfigurationDescription[] children;

        ConfigurationDescription(String name, String displayName, String iconBase, Component customizer, ConfigurationDescription[] children) {
            this.name = name;
            this.displayName = displayName;
            this.iconBase = iconBase;
            this.customizer = customizer;
            this.children = children;
        }
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager manager = new ExplorerManager();
        private final BeanTreeView btv;

        CategoryView(Node rootNode) {
            this.setLayout(new BorderLayout());
            Dimension size = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(size);
            this.btv.setPreferredSize(size);
            this.btv.setMaximumSize(size);
            this.add((Component)this.btv, "Center");
            this.manager.setRootContext(rootNode);
            this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
            this.selectFirstNode();
            this.btv.expandAll();
            this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EarCustomizer.class, (String)"ACS_CustomizeTree_A11YName"));
            this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EarCustomizer.class, (String)"ACS_CustomizeTree_A11YDesc"));
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void addNotify() {
            super.addNotify();
            this.btv.expandAll();
        }

        private void selectFirstNode() {
            Node[] nodes;
            Children ch = this.manager.getRootContext().getChildren();
            if (ch != null && (nodes = ch.getNodes()) != null && nodes.length > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodes[0]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] nodes = CategoryView.this.manager.getSelectedNodes();
                    if (nodes == null || nodes.length <= 0) {
                        return;
                    }
                    Node node = nodes[0];
                    if (EarCustomizer.this.currentCustomizer != null) {
                        EarCustomizer.this.customizerPanel.remove(EarCustomizer.this.currentCustomizer);
                    }
                    if (node.hasCustomizer()) {
                        EarCustomizer.this.currentCustomizer = node.getCustomizer();
                        if (EarCustomizer.this.currentCustomizer instanceof ArchiveCustomizerPanel) {
                            ((ArchiveCustomizerPanel)((Object)EarCustomizer.this.currentCustomizer)).initValues();
                        }
                        EarCustomizer.this.customizerPanel.add(EarCustomizer.this.currentCustomizer, EarCustomizer.this.fillConstraints);
                        EarCustomizer.this.customizerPanel.validate();
                        EarCustomizer.this.customizerPanel.repaint();
                        if (EarCustomizer.this.dialogDescriptor != null) {
                            EarCustomizer.this.dialogDescriptor.setHelpCtx(EarCustomizer.this.getHelpCtx());
                        }
                    } else {
                        EarCustomizer.this.currentCustomizer = null;
                        if (EarCustomizer.this.dialogDescriptor != null) {
                            EarCustomizer.this.dialogDescriptor.setHelpCtx(null);
                        }
                    }
                    return;
                }
            }
        }
    }
}

